/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types.stream;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpAnnotationFW;
import org.reaktivity.specification.amqp.internal.types.AmqpApplicationPropertyFW;
import org.reaktivity.specification.amqp.internal.types.AmqpBinaryFW;
import org.reaktivity.specification.amqp.internal.types.AmqpBodyKindFW;
import org.reaktivity.specification.amqp.internal.types.AmqpPropertiesFW;
import org.reaktivity.specification.amqp.internal.types.Array32FW;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;

public final class AmqpDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_DELIVERY_TAG = 4;
    public static final int FIELD_OFFSET_MESSAGE_FORMAT = 0;
    private static final int FIELD_SIZE_MESSAGE_FORMAT = 4;
    public static final int FIELD_OFFSET_FLAGS = 4;
    private static final int FIELD_SIZE_FLAGS = 1;
    public static final int FIELD_OFFSET_ANNOTATIONS = 5;
    public static final int FIELD_OFFSET_PROPERTIES = 0;
    public static final int FIELD_OFFSET_APPLICATION_PROPERTIES = 0;
    public static final int FIELD_OFFSET_BODY_KIND = 0;
    public static final int FIELD_OFFSET_DEFERRED = 0;
    private static final int FIELD_SIZE_DEFERRED = 4;
    private final AmqpBinaryFW deliveryTagRO = new AmqpBinaryFW();
    private final Array32FW<AmqpAnnotationFW> annotationsRO = new Array32FW<AmqpAnnotationFW>(new AmqpAnnotationFW());
    private final AmqpPropertiesFW propertiesRO = new AmqpPropertiesFW();
    private final Array32FW<AmqpApplicationPropertyFW> applicationPropertiesRO = new Array32FW<AmqpApplicationPropertyFW>(new AmqpApplicationPropertyFW());
    private final AmqpBodyKindFW bodyKindRO = new AmqpBodyKindFW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public AmqpBinaryFW deliveryTag() {
        return this.deliveryTagRO;
    }

    public long messageFormat() {
        return (long)this.buffer().getInt(this.deliveryTagRO.limit() + 0, ByteOrder.BIG_ENDIAN) & 0xFFFFFFFFL;
    }

    public int flags() {
        return this.buffer().getByte(this.deliveryTagRO.limit() + 4) & 0xFF;
    }

    public Array32FW<AmqpAnnotationFW> annotations() {
        return this.annotationsRO;
    }

    public AmqpPropertiesFW properties() {
        return this.propertiesRO;
    }

    public Array32FW<AmqpApplicationPropertyFW> applicationProperties() {
        return this.applicationPropertiesRO;
    }

    public AmqpBodyKindFW bodyKind() {
        return this.bodyKindRO;
    }

    public int deferred() {
        return this.buffer().getInt(this.bodyKindRO.limit() + 0, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public AmqpDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.deliveryTagRO.wrap(buffer, offset + 4, maxLimit);
        this.annotationsRO.wrap(buffer, this.deliveryTagRO.limit() + 5, maxLimit);
        this.propertiesRO.wrap(buffer, this.annotationsRO.limit() + 0, maxLimit);
        this.applicationPropertiesRO.wrap(buffer, this.propertiesRO.limit() + 0, maxLimit);
        this.bodyKindRO.wrap(buffer, this.applicationPropertiesRO.limit() + 0, maxLimit);
        AmqpDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.deliveryTagRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (null == this.annotationsRO.tryWrap(buffer, this.deliveryTagRO.limit() + 5, maxLimit)) {
            return null;
        }
        if (null == this.propertiesRO.tryWrap(buffer, this.annotationsRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.applicationPropertiesRO.tryWrap(buffer, this.propertiesRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.bodyKindRO.tryWrap(buffer, this.applicationPropertiesRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.bodyKindRO.limit() + 0 + 4;
    }

    public String toString() {
        return String.format("AMQP_DATA_EX [typeId=%d, deliveryTag=%s, messageFormat=%d, flags=%d, annotations=%s, properties=%s, applicationProperties=%s, bodyKind=%s, deferred=%d]", this.typeId(), this.deliveryTag(), this.messageFormat(), this.flags(), this.annotations(), this.properties(), this.applicationProperties(), this.bodyKind(), this.deferred());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpDataExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_DELIVERY_TAG = 1;
        private static final int INDEX_MESSAGE_FORMAT = 2;
        private static final int INDEX_FLAGS = 3;
        private static final int INDEX_ANNOTATIONS = 4;
        private static final int INDEX_PROPERTIES = 5;
        private static final int INDEX_APPLICATION_PROPERTIES = 6;
        private static final int INDEX_BODY_KIND = 7;
        private static final int INDEX_DEFERRED = 8;
        public static final int DEFAULT_DEFERRED = 0;
        private static final int FIELD_COUNT = 9;
        private final AmqpBinaryFW.Builder deliveryTagRW = new AmqpBinaryFW.Builder();
        private final Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW> annotationsRW = new Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW>(new AmqpAnnotationFW.Builder(), new AmqpAnnotationFW());
        private final AmqpPropertiesFW.Builder propertiesRW = new AmqpPropertiesFW.Builder();
        private final Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW> applicationPropertiesRW = new Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW>(new AmqpApplicationPropertyFW.Builder(), new AmqpApplicationPropertyFW());
        private final AmqpBodyKindFW.Builder bodyKindRW = new AmqpBodyKindFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpDataExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder deliveryTag(Consumer<AmqpBinaryFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            AmqpBinaryFW.Builder deliveryTagRW = this.deliveryTagRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(deliveryTagRW);
            this.limit(deliveryTagRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder deliveryTag(AmqpBinaryFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder messageFormat(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"messageFormat\"", value));
            }
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"messageFormat\"", value));
            }
            if (this.lastFieldSet < 1) {
                this.deliveryTag((AmqpBinaryFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 4;
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), (int)(value & 0xFFFFFFFFL), ByteOrder.BIG_ENDIAN);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder flags(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"flags\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"flags\"", value));
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 1;
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder annotations(Consumer<Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW>> mutator) {
            assert (this.lastFieldSet == 3);
            Flyweight.Builder annotationsRW = this.annotationsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW>)annotationsRW);
            this.limit(((Array32FW)((Array32FW.Builder)annotationsRW).build()).limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder annotations(Array32FW<AmqpAnnotationFW> field) {
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + field.sizeof();
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 4;
            return this;
        }

        public Builder annotationsItem(Consumer<AmqpAnnotationFW.Builder> mutator) {
            assert (this.lastFieldSet >= 3);
            if (this.lastFieldSet < 4) {
                this.annotationsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.annotationsRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.annotationsRW.build()).limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder properties(Consumer<AmqpPropertiesFW.Builder> mutator) {
            if (this.lastFieldSet < 4) {
                this.annotations((Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW> b) -> {});
            }
            assert (this.lastFieldSet == 4);
            AmqpPropertiesFW.Builder propertiesRW = this.propertiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(propertiesRW);
            this.limit(propertiesRW.build().limit());
            this.lastFieldSet = 5;
            return this;
        }

        public Builder properties(AmqpPropertiesFW field) {
            if (this.lastFieldSet < 4) {
                this.annotations((Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW> b) -> {});
            }
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + field.sizeof();
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 5;
            return this;
        }

        public Builder applicationProperties(Consumer<Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW>> mutator) {
            if (this.lastFieldSet < 5) {
                this.properties((AmqpPropertiesFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 5);
            Flyweight.Builder applicationPropertiesRW = this.applicationPropertiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW>)applicationPropertiesRW);
            this.limit(((Array32FW)((Array32FW.Builder)applicationPropertiesRW).build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder applicationProperties(Array32FW<AmqpApplicationPropertyFW> field) {
            if (this.lastFieldSet < 5) {
                this.properties((AmqpPropertiesFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + field.sizeof();
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 6;
            return this;
        }

        public Builder applicationPropertiesItem(Consumer<AmqpApplicationPropertyFW.Builder> mutator) {
            if (this.lastFieldSet < 5) {
                this.properties((AmqpPropertiesFW.Builder b) -> {});
            }
            assert (this.lastFieldSet >= 5);
            if (this.lastFieldSet < 6) {
                this.applicationPropertiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.applicationPropertiesRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.applicationPropertiesRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder bodyKind(Consumer<AmqpBodyKindFW.Builder> mutator) {
            if (this.lastFieldSet < 6) {
                this.applicationProperties((Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW> b) -> {});
            }
            assert (this.lastFieldSet == 6);
            AmqpBodyKindFW.Builder bodyKindRW = this.bodyKindRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(bodyKindRW);
            this.limit(bodyKindRW.build().limit());
            this.lastFieldSet = 7;
            return this;
        }

        public Builder bodyKind(AmqpBodyKindFW field) {
            if (this.lastFieldSet < 6) {
                this.applicationProperties((Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW> b) -> {});
            }
            assert (this.lastFieldSet == 6);
            int newLimit = this.limit() + field.sizeof();
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 7;
            return this;
        }

        public Builder deferred(int value) {
            assert (this.lastFieldSet == 7);
            int newLimit = this.limit() + 4;
            AmqpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value, ByteOrder.BIG_ENDIAN);
            this.lastFieldSet = 8;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpDataExFW>, ? extends Flyweight.Builder<AmqpDataExFW>, AmqpDataExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpDataExFW build() {
            if (this.lastFieldSet < 8) {
                this.deferred(0);
            }
            assert (this.lastFieldSet == 8);
            this.lastFieldSet = -1;
            return (AmqpDataExFW)super.build();
        }
    }
}

