/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpBinaryFW;
import org.reaktivity.specification.amqp.internal.types.AmqpMessageIdFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.String8FW;

public final class AmqpPropertiesFW
extends Flyweight {
    private static final int INDEX_MESSAGE_ID = 0;
    private static final long MASK_MESSAGE_ID = 1L;
    private static final int INDEX_USER_ID = 1;
    private static final long MASK_USER_ID = 2L;
    private static final int INDEX_TO = 2;
    private static final long MASK_TO = 4L;
    private static final int INDEX_SUBJECT = 3;
    private static final long MASK_SUBJECT = 8L;
    private static final int INDEX_REPLY_TO = 4;
    private static final long MASK_REPLY_TO = 16L;
    private static final int INDEX_CORRELATION_ID = 5;
    private static final long MASK_CORRELATION_ID = 32L;
    private static final int INDEX_CONTENT_TYPE = 6;
    private static final long MASK_CONTENT_TYPE = 64L;
    private static final int INDEX_CONTENT_ENCODING = 7;
    private static final long MASK_CONTENT_ENCODING = 128L;
    private static final int INDEX_ABSOLUTE_EXPIRY_TIME = 8;
    private static final long MASK_ABSOLUTE_EXPIRY_TIME = 256L;
    private static final int INDEX_CREATION_TIME = 9;
    private static final long MASK_CREATION_TIME = 512L;
    private static final int INDEX_GROUP_ID = 10;
    private static final long MASK_GROUP_ID = 1024L;
    private static final int INDEX_GROUP_SEQUENCE = 11;
    private static final long MASK_GROUP_SEQUENCE = 2048L;
    private static final int INDEX_REPLY_TO_GROUP_ID = 12;
    private static final long MASK_REPLY_TO_GROUP_ID = 4096L;
    private static final int LENGTH_SIZE = 4;
    private static final int FIELD_COUNT_SIZE = 4;
    private static final int BIT_MASK_SIZE = 8;
    private static final int FIELD_SIZE_ABSOLUTE_EXPIRY_TIME = 8;
    private static final int FIELD_SIZE_CREATION_TIME = 8;
    private static final int FIELD_SIZE_GROUP_SEQUENCE = 4;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 4;
    private static final int BIT_MASK_OFFSET = 8;
    private static final int FIRST_FIELD_OFFSET = 16;
    private AmqpMessageIdFW messageIdRO = new AmqpMessageIdFW();
    private AmqpBinaryFW userIdRO = new AmqpBinaryFW();
    private String8FW toRO = new String8FW();
    private String8FW subjectRO = new String8FW();
    private String8FW replyToRO = new String8FW();
    private AmqpMessageIdFW correlationIdRO = new AmqpMessageIdFW();
    private String8FW contentTypeRO = new String8FW();
    private String8FW contentEncodingRO = new String8FW();
    private String8FW groupIdRO = new String8FW();
    private String8FW replyToGroupIdRO = new String8FW();
    private final int[] optionalOffsets = new int[13];
    private long bitmask;

    public AmqpMessageIdFW messageId() {
        assert ((this.bitmask() & 1L) != 0L) : "Field \"messageId\" is not set";
        return this.messageIdRO;
    }

    public boolean hasMessageId() {
        return (this.bitmask() & 1L) != 0L;
    }

    public AmqpBinaryFW userId() {
        assert ((this.bitmask() & 2L) != 0L) : "Field \"userId\" is not set";
        return this.userIdRO;
    }

    public boolean hasUserId() {
        return (this.bitmask() & 2L) != 0L;
    }

    public String8FW to() {
        assert ((this.bitmask() & 4L) != 0L) : "Field \"to\" is not set";
        return this.toRO;
    }

    public boolean hasTo() {
        return (this.bitmask() & 4L) != 0L;
    }

    public String8FW subject() {
        assert ((this.bitmask() & 8L) != 0L) : "Field \"subject\" is not set";
        return this.subjectRO;
    }

    public boolean hasSubject() {
        return (this.bitmask() & 8L) != 0L;
    }

    public String8FW replyTo() {
        assert ((this.bitmask() & 0x10L) != 0L) : "Field \"replyTo\" is not set";
        return this.replyToRO;
    }

    public boolean hasReplyTo() {
        return (this.bitmask() & 0x10L) != 0L;
    }

    public AmqpMessageIdFW correlationId() {
        assert ((this.bitmask() & 0x20L) != 0L) : "Field \"correlationId\" is not set";
        return this.correlationIdRO;
    }

    public boolean hasCorrelationId() {
        return (this.bitmask() & 0x20L) != 0L;
    }

    public String8FW contentType() {
        assert ((this.bitmask() & 0x40L) != 0L) : "Field \"contentType\" is not set";
        return this.contentTypeRO;
    }

    public boolean hasContentType() {
        return (this.bitmask() & 0x40L) != 0L;
    }

    public String8FW contentEncoding() {
        assert ((this.bitmask() & 0x80L) != 0L) : "Field \"contentEncoding\" is not set";
        return this.contentEncodingRO;
    }

    public boolean hasContentEncoding() {
        return (this.bitmask() & 0x80L) != 0L;
    }

    public long absoluteExpiryTime() {
        assert ((this.bitmask() & 0x100L) != 0L) : "Field \"absoluteExpiryTime\" is not set";
        return this.buffer().getLong(this.optionalOffsets[8], ByteOrder.BIG_ENDIAN);
    }

    public boolean hasAbsoluteExpiryTime() {
        return (this.bitmask() & 0x100L) != 0L;
    }

    public long creationTime() {
        assert ((this.bitmask() & 0x200L) != 0L) : "Field \"creationTime\" is not set";
        return this.buffer().getLong(this.optionalOffsets[9], ByteOrder.BIG_ENDIAN);
    }

    public boolean hasCreationTime() {
        return (this.bitmask() & 0x200L) != 0L;
    }

    public String8FW groupId() {
        assert ((this.bitmask() & 0x400L) != 0L) : "Field \"groupId\" is not set";
        return this.groupIdRO;
    }

    public boolean hasGroupId() {
        return (this.bitmask() & 0x400L) != 0L;
    }

    public int groupSequence() {
        assert ((this.bitmask() & 0x800L) != 0L) : "Field \"groupSequence\" is not set";
        return this.buffer().getInt(this.optionalOffsets[11], ByteOrder.BIG_ENDIAN);
    }

    public boolean hasGroupSequence() {
        return (this.bitmask() & 0x800L) != 0L;
    }

    public String8FW replyToGroupId() {
        assert ((this.bitmask() & 0x1000L) != 0L) : "Field \"replyToGroupId\" is not set";
        return this.replyToGroupIdRO;
    }

    public boolean hasReplyToGroupId() {
        return (this.bitmask() & 0x1000L) != 0L;
    }

    public int fieldCount() {
        return this.buffer().getInt(this.offset() + 4, ByteOrder.BIG_ENDIAN);
    }

    private long bitmask() {
        return this.buffer().getLong(this.offset() + 8, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public AmqpPropertiesFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        AmqpPropertiesFW.checkLimit(offset + 0 + 4, maxLimit);
        int limit = this.limit();
        AmqpPropertiesFW.checkLimit(limit, maxLimit);
        long bitmask = this.bitmask();
        int fieldLimit = offset + 8 + 8;
        block15: for (int field = 0; field < 13; ++field) {
            switch (field) {
                case 0: {
                    if ((bitmask & 1L) == 0L) continue block15;
                    this.messageIdRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.messageIdRO.limit();
                    continue block15;
                }
                case 1: {
                    if ((bitmask & 2L) == 0L) continue block15;
                    this.userIdRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.userIdRO.limit();
                    continue block15;
                }
                case 2: {
                    if ((bitmask & 4L) == 0L) continue block15;
                    this.toRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.toRO.limit();
                    continue block15;
                }
                case 3: {
                    if ((bitmask & 8L) == 0L) continue block15;
                    this.subjectRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.subjectRO.limit();
                    continue block15;
                }
                case 4: {
                    if ((bitmask & 0x10L) == 0L) continue block15;
                    this.replyToRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.replyToRO.limit();
                    continue block15;
                }
                case 5: {
                    if ((bitmask & 0x20L) == 0L) continue block15;
                    this.correlationIdRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.correlationIdRO.limit();
                    continue block15;
                }
                case 6: {
                    if ((bitmask & 0x40L) == 0L) continue block15;
                    this.contentTypeRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.contentTypeRO.limit();
                    continue block15;
                }
                case 7: {
                    if ((bitmask & 0x80L) == 0L) continue block15;
                    this.contentEncodingRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.contentEncodingRO.limit();
                    continue block15;
                }
                case 8: {
                    if ((bitmask & 0x100L) == 0L) continue block15;
                    this.optionalOffsets[8] = fieldLimit;
                    fieldLimit += 8;
                    continue block15;
                }
                case 9: {
                    if ((bitmask & 0x200L) == 0L) continue block15;
                    this.optionalOffsets[9] = fieldLimit;
                    fieldLimit += 8;
                    continue block15;
                }
                case 10: {
                    if ((bitmask & 0x400L) == 0L) continue block15;
                    this.groupIdRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.groupIdRO.limit();
                    continue block15;
                }
                case 11: {
                    if ((bitmask & 0x800L) == 0L) continue block15;
                    this.optionalOffsets[11] = fieldLimit;
                    fieldLimit += 4;
                    continue block15;
                }
                case 12: {
                    if ((bitmask & 0x1000L) == 0L) continue block15;
                    this.replyToGroupIdRO.wrap(buffer, fieldLimit, maxLimit);
                    fieldLimit = this.replyToGroupIdRO.limit();
                }
            }
        }
        AmqpPropertiesFW.checkLimit(fieldLimit, limit);
        return this;
    }

    @Override
    public AmqpPropertiesFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        if (offset + 0 + 4 > maxLimit) {
            return null;
        }
        int limit = this.limit();
        if (limit > maxLimit) {
            return null;
        }
        long bitmask = this.bitmask();
        int fieldLimit = offset + 8 + 8;
        block15: for (int field = 0; field < 13; ++field) {
            switch (field) {
                case 0: {
                    if ((bitmask & 1L) == 0L) continue block15;
                    if (this.messageIdRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.messageIdRO.limit();
                    continue block15;
                }
                case 1: {
                    if ((bitmask & 2L) == 0L) continue block15;
                    if (this.userIdRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.userIdRO.limit();
                    continue block15;
                }
                case 2: {
                    if ((bitmask & 4L) == 0L) continue block15;
                    if (this.toRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.toRO.limit();
                    continue block15;
                }
                case 3: {
                    if ((bitmask & 8L) == 0L) continue block15;
                    if (this.subjectRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.subjectRO.limit();
                    continue block15;
                }
                case 4: {
                    if ((bitmask & 0x10L) == 0L) continue block15;
                    if (this.replyToRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.replyToRO.limit();
                    continue block15;
                }
                case 5: {
                    if ((bitmask & 0x20L) == 0L) continue block15;
                    if (this.correlationIdRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.correlationIdRO.limit();
                    continue block15;
                }
                case 6: {
                    if ((bitmask & 0x40L) == 0L) continue block15;
                    if (this.contentTypeRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.contentTypeRO.limit();
                    continue block15;
                }
                case 7: {
                    if ((bitmask & 0x80L) == 0L) continue block15;
                    if (this.contentEncodingRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.contentEncodingRO.limit();
                    continue block15;
                }
                case 8: {
                    if ((bitmask & 0x100L) == 0L) continue block15;
                    this.optionalOffsets[8] = fieldLimit;
                    fieldLimit += 8;
                    continue block15;
                }
                case 9: {
                    if ((bitmask & 0x200L) == 0L) continue block15;
                    this.optionalOffsets[9] = fieldLimit;
                    fieldLimit += 8;
                    continue block15;
                }
                case 10: {
                    if ((bitmask & 0x400L) == 0L) continue block15;
                    if (this.groupIdRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.groupIdRO.limit();
                    continue block15;
                }
                case 11: {
                    if ((bitmask & 0x800L) == 0L) continue block15;
                    this.optionalOffsets[11] = fieldLimit;
                    fieldLimit += 4;
                    continue block15;
                }
                case 12: {
                    if ((bitmask & 0x1000L) == 0L) continue block15;
                    if (this.replyToGroupIdRO.tryWrap(buffer, fieldLimit, maxLimit) == null) {
                        return null;
                    }
                    fieldLimit = this.replyToGroupIdRO.limit();
                }
            }
        }
        if (fieldLimit > limit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + this.buffer().getInt(this.offset() + 0, ByteOrder.BIG_ENDIAN);
    }

    public String toString() {
        long bitmask = this.bitmask();
        AmqpMessageIdFW messageId = null;
        AmqpBinaryFW userId = null;
        String8FW to = null;
        String8FW subject = null;
        String8FW replyTo = null;
        AmqpMessageIdFW correlationId = null;
        String8FW contentType = null;
        String8FW contentEncoding = null;
        Long absoluteExpiryTime = null;
        Long creationTime = null;
        String8FW groupId = null;
        Integer groupSequence = null;
        String8FW replyToGroupId = null;
        StringBuilder format = new StringBuilder();
        format.append("AMQP_PROPERTIES [bitmask={0}");
        if (this.hasMessageId()) {
            format.append(", messageId={1}");
            messageId = this.messageId();
        }
        if (this.hasUserId()) {
            format.append(", userId={2}");
            userId = this.userId();
        }
        if (this.hasTo()) {
            format.append(", to={3}");
            to = this.to();
        }
        if (this.hasSubject()) {
            format.append(", subject={4}");
            subject = this.subject();
        }
        if (this.hasReplyTo()) {
            format.append(", replyTo={5}");
            replyTo = this.replyTo();
        }
        if (this.hasCorrelationId()) {
            format.append(", correlationId={6}");
            correlationId = this.correlationId();
        }
        if (this.hasContentType()) {
            format.append(", contentType={7}");
            contentType = this.contentType();
        }
        if (this.hasContentEncoding()) {
            format.append(", contentEncoding={8}");
            contentEncoding = this.contentEncoding();
        }
        if (this.hasAbsoluteExpiryTime()) {
            format.append(", absoluteExpiryTime={9}");
            absoluteExpiryTime = this.absoluteExpiryTime();
        }
        if (this.hasCreationTime()) {
            format.append(", creationTime={10}");
            creationTime = this.creationTime();
        }
        if (this.hasGroupId()) {
            format.append(", groupId={11}");
            groupId = this.groupId();
        }
        if (this.hasGroupSequence()) {
            format.append(", groupSequence={12}");
            groupSequence = this.groupSequence();
        }
        if (this.hasReplyToGroupId()) {
            format.append(", replyToGroupId={13}");
            replyToGroupId = this.replyToGroupId();
        }
        format.append("]");
        return MessageFormat.format(format.toString(), String.format("0x%16X", bitmask), messageId, userId, to, subject, replyTo, correlationId, contentType, contentEncoding, absoluteExpiryTime, creationTime, groupId, groupSequence, replyToGroupId);
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpPropertiesFW> {
        private final AmqpMessageIdFW.Builder messageIdRW = new AmqpMessageIdFW.Builder();
        private final AmqpBinaryFW.Builder userIdRW = new AmqpBinaryFW.Builder();
        private final String8FW.Builder toRW = new String8FW.Builder();
        private final String8FW.Builder subjectRW = new String8FW.Builder();
        private final String8FW.Builder replyToRW = new String8FW.Builder();
        private final AmqpMessageIdFW.Builder correlationIdRW = new AmqpMessageIdFW.Builder();
        private final String8FW.Builder contentTypeRW = new String8FW.Builder();
        private final String8FW.Builder contentEncodingRW = new String8FW.Builder();
        private final String8FW.Builder groupIdRW = new String8FW.Builder();
        private final String8FW.Builder replyToGroupIdRW = new String8FW.Builder();
        private long fieldsMask;

        public Builder() {
            super(new AmqpPropertiesFW());
        }

        public Builder messageId(AmqpMessageIdFW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFFFL) == 0L) : "Field \"messageId\" cannot be set out of order";
            int newLimit = this.limit() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), value.buffer(), value.offset(), value.sizeof());
            this.fieldsMask |= 1L;
            this.limit(newLimit);
            return this;
        }

        public Builder messageId(Consumer<AmqpMessageIdFW.Builder> mutator) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFFFL) == 0L) : "Field \"messageId\" cannot be set out of order";
            AmqpMessageIdFW.Builder messageIdRW = this.messageIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(messageIdRW);
            this.fieldsMask |= 1L;
            this.limit(((AmqpMessageIdFW)messageIdRW.build()).limit());
            this.fieldsMask |= 1L;
            return this;
        }

        public Builder userId(AmqpBinaryFW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFFEL) == 0L) : "Field \"userId\" cannot be set out of order";
            int newLimit = this.limit() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), value.buffer(), value.offset(), value.sizeof());
            this.fieldsMask |= 2L;
            this.limit(newLimit);
            return this;
        }

        public Builder userId(Consumer<AmqpBinaryFW.Builder> mutator) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFFEL) == 0L) : "Field \"userId\" cannot be set out of order";
            AmqpBinaryFW.Builder userIdRW = this.userIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(userIdRW);
            this.fieldsMask |= 2L;
            this.limit(userIdRW.build().limit());
            this.fieldsMask |= 2L;
            return this;
        }

        private String8FW.Builder to() {
            return this.toRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder to(String value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFFCL) == 0L) : "Field \"to\" is already set or subsequent fields are already set";
            String8FW.Builder toRW = this.to();
            toRW.set(value, StandardCharsets.UTF_8);
            this.fieldsMask |= 4L;
            this.limit(toRW.build().limit());
            return this;
        }

        public Builder to(String8FW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFFCL) == 0L) : "Field \"to\" is already set or subsequent fields are already set";
            String8FW.Builder toRW = this.to();
            toRW.set((Flyweight)value);
            this.fieldsMask |= 4L;
            this.limit(toRW.build().limit());
            return this;
        }

        public Builder to(DirectBuffer buffer, int offset, int length) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFFCL) == 0L) : "Field \"to\" is already set or subsequent fields are already set";
            String8FW.Builder toRW = this.to();
            toRW.set(buffer, offset, length);
            this.fieldsMask |= 4L;
            this.limit(toRW.build().limit());
            return this;
        }

        private String8FW.Builder subject() {
            return this.subjectRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder subject(String value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFF8L) == 0L) : "Field \"subject\" is already set or subsequent fields are already set";
            String8FW.Builder subjectRW = this.subject();
            subjectRW.set(value, StandardCharsets.UTF_8);
            this.fieldsMask |= 8L;
            this.limit(subjectRW.build().limit());
            return this;
        }

        public Builder subject(String8FW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFF8L) == 0L) : "Field \"subject\" is already set or subsequent fields are already set";
            String8FW.Builder subjectRW = this.subject();
            subjectRW.set((Flyweight)value);
            this.fieldsMask |= 8L;
            this.limit(subjectRW.build().limit());
            return this;
        }

        public Builder subject(DirectBuffer buffer, int offset, int length) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFF8L) == 0L) : "Field \"subject\" is already set or subsequent fields are already set";
            String8FW.Builder subjectRW = this.subject();
            subjectRW.set(buffer, offset, length);
            this.fieldsMask |= 8L;
            this.limit(subjectRW.build().limit());
            return this;
        }

        private String8FW.Builder replyTo() {
            return this.replyToRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder replyTo(String value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFF0L) == 0L) : "Field \"replyTo\" is already set or subsequent fields are already set";
            String8FW.Builder replyToRW = this.replyTo();
            replyToRW.set(value, StandardCharsets.UTF_8);
            this.fieldsMask |= 0x10L;
            this.limit(replyToRW.build().limit());
            return this;
        }

        public Builder replyTo(String8FW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFF0L) == 0L) : "Field \"replyTo\" is already set or subsequent fields are already set";
            String8FW.Builder replyToRW = this.replyTo();
            replyToRW.set((Flyweight)value);
            this.fieldsMask |= 0x10L;
            this.limit(replyToRW.build().limit());
            return this;
        }

        public Builder replyTo(DirectBuffer buffer, int offset, int length) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFF0L) == 0L) : "Field \"replyTo\" is already set or subsequent fields are already set";
            String8FW.Builder replyToRW = this.replyTo();
            replyToRW.set(buffer, offset, length);
            this.fieldsMask |= 0x10L;
            this.limit(replyToRW.build().limit());
            return this;
        }

        public Builder correlationId(AmqpMessageIdFW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFE0L) == 0L) : "Field \"correlationId\" cannot be set out of order";
            int newLimit = this.limit() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), value.buffer(), value.offset(), value.sizeof());
            this.fieldsMask |= 0x20L;
            this.limit(newLimit);
            return this;
        }

        public Builder correlationId(Consumer<AmqpMessageIdFW.Builder> mutator) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFE0L) == 0L) : "Field \"correlationId\" cannot be set out of order";
            AmqpMessageIdFW.Builder correlationIdRW = this.correlationIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(correlationIdRW);
            this.fieldsMask |= 0x20L;
            this.limit(((AmqpMessageIdFW)correlationIdRW.build()).limit());
            this.fieldsMask |= 0x20L;
            return this;
        }

        private String8FW.Builder contentType() {
            return this.contentTypeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder contentType(String value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFC0L) == 0L) : "Field \"contentType\" is already set or subsequent fields are already set";
            String8FW.Builder contentTypeRW = this.contentType();
            contentTypeRW.set(value, StandardCharsets.UTF_8);
            this.fieldsMask |= 0x40L;
            this.limit(contentTypeRW.build().limit());
            return this;
        }

        public Builder contentType(String8FW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFC0L) == 0L) : "Field \"contentType\" is already set or subsequent fields are already set";
            String8FW.Builder contentTypeRW = this.contentType();
            contentTypeRW.set((Flyweight)value);
            this.fieldsMask |= 0x40L;
            this.limit(contentTypeRW.build().limit());
            return this;
        }

        public Builder contentType(DirectBuffer buffer, int offset, int length) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFFC0L) == 0L) : "Field \"contentType\" is already set or subsequent fields are already set";
            String8FW.Builder contentTypeRW = this.contentType();
            contentTypeRW.set(buffer, offset, length);
            this.fieldsMask |= 0x40L;
            this.limit(contentTypeRW.build().limit());
            return this;
        }

        private String8FW.Builder contentEncoding() {
            return this.contentEncodingRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder contentEncoding(String value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFF80L) == 0L) : "Field \"contentEncoding\" is already set or subsequent fields are already set";
            String8FW.Builder contentEncodingRW = this.contentEncoding();
            contentEncodingRW.set(value, StandardCharsets.UTF_8);
            this.fieldsMask |= 0x80L;
            this.limit(contentEncodingRW.build().limit());
            return this;
        }

        public Builder contentEncoding(String8FW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFF80L) == 0L) : "Field \"contentEncoding\" is already set or subsequent fields are already set";
            String8FW.Builder contentEncodingRW = this.contentEncoding();
            contentEncodingRW.set((Flyweight)value);
            this.fieldsMask |= 0x80L;
            this.limit(contentEncodingRW.build().limit());
            return this;
        }

        public Builder contentEncoding(DirectBuffer buffer, int offset, int length) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFF80L) == 0L) : "Field \"contentEncoding\" is already set or subsequent fields are already set";
            String8FW.Builder contentEncodingRW = this.contentEncoding();
            contentEncodingRW.set(buffer, offset, length);
            this.fieldsMask |= 0x80L;
            this.limit(contentEncodingRW.build().limit());
            return this;
        }

        public Builder absoluteExpiryTime(long value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFF00L) == 0L) : "Field \"absoluteExpiryTime\" cannot be set out of order";
            int newLimit = this.limit() + 8;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value, ByteOrder.BIG_ENDIAN);
            this.fieldsMask |= 0x100L;
            this.limit(newLimit);
            return this;
        }

        public Builder creationTime(long value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFE00L) == 0L) : "Field \"creationTime\" cannot be set out of order";
            int newLimit = this.limit() + 8;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value, ByteOrder.BIG_ENDIAN);
            this.fieldsMask |= 0x200L;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder groupId() {
            return this.groupIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder groupId(String value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFC00L) == 0L) : "Field \"groupId\" is already set or subsequent fields are already set";
            String8FW.Builder groupIdRW = this.groupId();
            groupIdRW.set(value, StandardCharsets.UTF_8);
            this.fieldsMask |= 0x400L;
            this.limit(groupIdRW.build().limit());
            return this;
        }

        public Builder groupId(String8FW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFC00L) == 0L) : "Field \"groupId\" is already set or subsequent fields are already set";
            String8FW.Builder groupIdRW = this.groupId();
            groupIdRW.set((Flyweight)value);
            this.fieldsMask |= 0x400L;
            this.limit(groupIdRW.build().limit());
            return this;
        }

        public Builder groupId(DirectBuffer buffer, int offset, int length) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFFC00L) == 0L) : "Field \"groupId\" is already set or subsequent fields are already set";
            String8FW.Builder groupIdRW = this.groupId();
            groupIdRW.set(buffer, offset, length);
            this.fieldsMask |= 0x400L;
            this.limit(groupIdRW.build().limit());
            return this;
        }

        public Builder groupSequence(int value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFF800L) == 0L) : "Field \"groupSequence\" cannot be set out of order";
            int newLimit = this.limit() + 4;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value, ByteOrder.BIG_ENDIAN);
            this.fieldsMask |= 0x800L;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder replyToGroupId() {
            return this.replyToGroupIdRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder replyToGroupId(String value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFF000L) == 0L) : "Field \"replyToGroupId\" is already set or subsequent fields are already set";
            String8FW.Builder replyToGroupIdRW = this.replyToGroupId();
            replyToGroupIdRW.set(value, StandardCharsets.UTF_8);
            this.fieldsMask |= 0x1000L;
            this.limit(replyToGroupIdRW.build().limit());
            return this;
        }

        public Builder replyToGroupId(String8FW value) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFF000L) == 0L) : "Field \"replyToGroupId\" is already set or subsequent fields are already set";
            String8FW.Builder replyToGroupIdRW = this.replyToGroupId();
            replyToGroupIdRW.set((Flyweight)value);
            this.fieldsMask |= 0x1000L;
            this.limit(replyToGroupIdRW.build().limit());
            return this;
        }

        public Builder replyToGroupId(DirectBuffer buffer, int offset, int length) {
            assert ((this.fieldsMask & 0xFFFFFFFFFFFFF000L) == 0L) : "Field \"replyToGroupId\" is already set or subsequent fields are already set";
            String8FW.Builder replyToGroupIdRW = this.replyToGroupId();
            replyToGroupIdRW.set(buffer, offset, length);
            this.fieldsMask |= 0x1000L;
            this.limit(replyToGroupIdRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.fieldsMask = 0L;
            int newLimit = this.limit() + 16;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            return this;
        }

        @Override
        public AmqpPropertiesFW build() {
            this.buffer().putInt(this.offset() + 0, this.limit() - this.offset(), ByteOrder.BIG_ENDIAN);
            this.buffer().putInt(this.offset() + 4, Long.bitCount(this.fieldsMask), ByteOrder.BIG_ENDIAN);
            this.buffer().putLong(this.offset() + 8, this.fieldsMask, ByteOrder.BIG_ENDIAN);
            return (AmqpPropertiesFW)super.build();
        }
    }
}

