/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.MapFW;

public final class Map32FW<K extends Flyweight, V extends Flyweight>
extends MapFW<K, V> {
    private static final int LENGTH_SIZE = 4;
    private static final int FIELD_COUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 4;
    private static final int FIELDS_OFFSET = 8;
    private static final long LENGTH_MAX_VALUE = 0xFFFFFFFFL;
    private final ByteOrder byteOrder;
    private final K keyRO;
    private final V valueRO;
    private final DirectBuffer entriesRO = new UnsafeBuffer(0L, 0);

    public Map32FW(K keyRO, V valueRO) {
        this.keyRO = keyRO;
        this.valueRO = valueRO;
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public Map32FW(K keyRO, V valueRO, ByteOrder byteOrder) {
        this.keyRO = keyRO;
        this.valueRO = valueRO;
        this.byteOrder = byteOrder;
    }

    @Override
    public int length() {
        return this.buffer().getInt(this.offset() + 0, this.byteOrder);
    }

    @Override
    public int fieldCount() {
        return this.buffer().getInt(this.offset() + 4, this.byteOrder);
    }

    @Override
    public DirectBuffer entries() {
        return this.entriesRO;
    }

    @Override
    public void forEach(Function<K, Consumer<V>> consumer) {
        int offset = this.offset() + 8;
        int fieldCount = this.fieldCount();
        for (int i = 0; i < fieldCount; i += 2) {
            ((Flyweight)this.keyRO).wrap(this.buffer(), offset, this.limit());
            ((Flyweight)this.valueRO).wrap(this.buffer(), ((Flyweight)this.keyRO).limit(), this.limit());
            offset = ((Flyweight)this.valueRO).limit();
            consumer.apply(this.keyRO).accept(this.valueRO);
        }
    }

    @Override
    public Map32FW<K, V> tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        int itemsSize = this.length() - 4;
        this.entriesRO.wrap(buffer, offset + 8, itemsSize);
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public Map32FW<K, V> wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int itemsSize = this.length() - 4;
        this.entriesRO.wrap(buffer, offset + 8, itemsSize);
        Map32FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + this.length();
    }

    public String toString() {
        return String.format("map32<%d, %d>", this.length(), this.fieldCount());
    }

    public static final class Builder<K extends Flyweight, V extends Flyweight, KB extends Flyweight.Builder<K>, VB extends Flyweight.Builder<V>>
    extends MapFW.Builder<Map32FW, K, V, KB, VB> {
        private final ByteOrder byteOrder;
        private final KB keyRW;
        private final VB valueRW;
        private int fieldCount;

        public Builder(K keyRO, V valueRO, KB keyRW, VB valueRW) {
            super(new Map32FW<K, V>(keyRO, valueRO));
            this.keyRW = keyRW;
            this.valueRW = valueRW;
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(K keyRO, V valueRO, KB keyRW, VB valueRW, ByteOrder byteOrder) {
            super(new Map32FW<K, V>(keyRO, valueRO));
            this.keyRW = keyRW;
            this.valueRW = valueRW;
            this.byteOrder = byteOrder;
        }

        public Builder<K, V, KB, VB> wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 8;
            Flyweight.checkLimit(newLimit, maxLimit);
            this.limit(newLimit);
            this.fieldCount = 0;
            return this;
        }

        public Builder<K, V, KB, VB> entry(Consumer<KB> key, Consumer<VB> value) {
            ((Flyweight.Builder)this.keyRW).wrap(this.buffer(), this.limit(), this.maxLimit());
            key.accept(this.keyRW);
            Flyweight.checkLimit(((Flyweight.Builder)this.keyRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.keyRW).limit());
            ++this.fieldCount;
            ((Flyweight.Builder)this.valueRW).wrap(this.buffer(), this.limit(), this.maxLimit());
            value.accept(this.valueRW);
            Flyweight.checkLimit(((Flyweight.Builder)this.valueRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.valueRW).limit());
            ++this.fieldCount;
            return this;
        }

        public Builder<K, V, KB, VB> entries(DirectBuffer buffer, int srcOffset, int length, int fieldCount) {
            this.buffer().putBytes(this.offset() + 8, buffer, srcOffset, length);
            int newLimit = this.offset() + 8 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            this.fieldCount = fieldCount;
            return this;
        }

        @Override
        public Map32FW build() {
            int length = this.limit() - this.offset() - 4;
            this.buffer().putInt(this.offset() + 0, length, this.byteOrder);
            this.buffer().putInt(this.offset() + 4, this.fieldCount, this.byteOrder);
            return (Map32FW)super.build();
        }
    }
}

