/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.String8FW;
import org.reaktivity.specification.amqp.internal.types.StringFW;

public final class AmqpAnnotationKeyFW
extends Flyweight {
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 0;
    public static final int KIND_ID = 1;
    public static final int FIELD_OFFSET_ID = 1;
    private static final int FIELD_SIZE_ID = 8;
    public static final int KIND_NAME = 2;
    public static final int FIELD_OFFSET_NAME = 1;
    private final String8FW nameRO = new String8FW();

    public int kind() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public long id() {
        return this.buffer().getLong(this.offset() + 1);
    }

    public String8FW name() {
        return this.nameRO;
    }

    @Override
    public AmqpAnnotationKeyFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 1: {
                break;
            }
            case 2: {
                if (this.nameRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public AmqpAnnotationKeyFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 1: {
                break;
            }
            case 2: {
                this.nameRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
        }
        AmqpAnnotationKeyFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 1: {
                return this.offset() + 1 + 8;
            }
            case 2: {
                return this.name().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case 1: {
                return String.format("AMQP_ANNOTATION_KEY [id=%d]", this.id());
            }
            case 2: {
                return String.format("AMQP_ANNOTATION_KEY [name=%s]", this.name());
            }
        }
        return String.format("AMQP_ANNOTATION_KEY [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpAnnotationKeyFW> {
        private final String8FW.Builder nameRW = new String8FW.Builder();

        public Builder() {
            super(new AmqpAnnotationKeyFW());
        }

        public Builder kind(int value) {
            this.buffer().putByte(this.offset() + 0, (byte)(value & 0xFF));
            return this;
        }

        public Builder id(long value) {
            this.kind(1);
            this.buffer().putLong(this.offset() + 1, value);
            this.limit(this.offset() + 1 + 8);
            return this;
        }

        private String8FW.Builder name() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.nameRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder name(String value) {
            if (value == null) {
                this.limit(this.offset() + 1);
            } else {
                this.kind(2);
                String8FW.Builder name = this.name();
                name.set(value, StandardCharsets.UTF_8);
                this.limit(name.build().limit());
            }
            return this;
        }

        public Builder name(StringFW value) {
            if (value == null) {
                this.limit(this.offset() + 1);
            } else {
                this.kind(2);
                String8FW.Builder name = this.name();
                name.set(value);
                this.limit(name.build().limit());
            }
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

