/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilities;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilitiesFW;
import org.reaktivity.specification.amqp.internal.types.AmqpReceiverSettleModeFW;
import org.reaktivity.specification.amqp.internal.types.AmqpSenderSettleModeFW;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.String8FW;

public final class AmqpBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_ADDRESS = 4;
    public static final int FIELD_OFFSET_CAPABILITIES = 0;
    public static final int FIELD_OFFSET_SENDER_SETTLE_MODE = 0;
    public static final int FIELD_OFFSET_RECEIVER_SETTLE_MODE = 0;
    private final String8FW addressRO = new String8FW();
    private AmqpCapabilitiesFW capabilitiesRO = new AmqpCapabilitiesFW();
    private final AmqpSenderSettleModeFW senderSettleModeRO = new AmqpSenderSettleModeFW();
    private final AmqpReceiverSettleModeFW receiverSettleModeRO = new AmqpReceiverSettleModeFW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public String8FW address() {
        return this.addressRO;
    }

    public AmqpCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    public AmqpSenderSettleModeFW senderSettleMode() {
        return this.senderSettleModeRO;
    }

    public AmqpReceiverSettleModeFW receiverSettleMode() {
        return this.receiverSettleModeRO;
    }

    @Override
    public AmqpBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.addressRO.wrap(buffer, offset + 4, maxLimit);
        this.capabilitiesRO.wrap(buffer, this.addressRO.limit() + 0, maxLimit);
        this.senderSettleModeRO.wrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit);
        this.receiverSettleModeRO.wrap(buffer, this.senderSettleModeRO.limit() + 0, maxLimit);
        AmqpBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.addressRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, this.addressRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.senderSettleModeRO.tryWrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.receiverSettleModeRO.tryWrap(buffer, this.senderSettleModeRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.receiverSettleModeRO.limit();
    }

    public String toString() {
        return String.format("AMQP_BEGIN_EX [typeId=%d, address=%s, capabilities=%s, senderSettleMode=%s, receiverSettleMode=%s]", this.typeId(), this.addressRO.asString(), this.capabilities(), this.senderSettleMode(), this.receiverSettleMode());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_ADDRESS = 1;
        private static final int INDEX_CAPABILITIES = 2;
        public static final AmqpCapabilities DEFAULT_CAPABILITIES = AmqpCapabilities.SEND_AND_RECEIVE;
        private static final int INDEX_SENDER_SETTLE_MODE = 3;
        private static final int INDEX_RECEIVER_SETTLE_MODE = 4;
        private static final int FIELD_COUNT = 5;
        private final String8FW.Builder addressRW = new String8FW.Builder();
        private final AmqpCapabilitiesFW.Builder capabilitiesRW = new AmqpCapabilitiesFW.Builder();
        private final AmqpSenderSettleModeFW.Builder senderSettleModeRW = new AmqpSenderSettleModeFW.Builder();
        private final AmqpReceiverSettleModeFW.Builder receiverSettleModeRW = new AmqpReceiverSettleModeFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            AmqpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder address() {
            assert (this.lastFieldSet == 0);
            return this.addressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder address(String value) {
            String8FW.Builder addressRW = this.address();
            addressRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(addressRW.build().limit());
            return this;
        }

        public Builder address(String8FW value) {
            String8FW.Builder addressRW = this.address();
            addressRW.set((Flyweight)value);
            this.lastFieldSet = 1;
            this.limit(addressRW.build().limit());
            return this;
        }

        public Builder address(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder addressRW = this.address();
            addressRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(addressRW.build().limit());
            return this;
        }

        public Builder capabilities(Consumer<AmqpCapabilitiesFW.Builder> mutator) {
            assert (this.lastFieldSet == 1);
            AmqpCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder capabilities(AmqpCapabilitiesFW field) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            AmqpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder senderSettleMode(Consumer<AmqpSenderSettleModeFW.Builder> mutator) {
            if (this.lastFieldSet < 2) {
                this.capabilities((AmqpCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 2);
            AmqpSenderSettleModeFW.Builder senderSettleModeRW = this.senderSettleModeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(senderSettleModeRW);
            this.limit(senderSettleModeRW.build().limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder senderSettleMode(AmqpSenderSettleModeFW field) {
            if (this.lastFieldSet < 2) {
                this.capabilities((AmqpCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + field.sizeof();
            AmqpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder receiverSettleMode(Consumer<AmqpReceiverSettleModeFW.Builder> mutator) {
            assert (this.lastFieldSet == 3);
            AmqpReceiverSettleModeFW.Builder receiverSettleModeRW = this.receiverSettleModeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(receiverSettleModeRW);
            this.limit(receiverSettleModeRW.build().limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder receiverSettleMode(AmqpReceiverSettleModeFW field) {
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + field.sizeof();
            AmqpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 4;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpBeginExFW>, ? extends Flyweight.Builder<AmqpBeginExFW>, AmqpBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpBeginExFW build() {
            assert (this.lastFieldSet == 4);
            this.lastFieldSet = -1;
            return (AmqpBeginExFW)super.build();
        }
    }
}

