/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.BytesMatcher;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.amqp.internal.types.AmqpAnnotationFW;
import org.reaktivity.specification.amqp.internal.types.AmqpApplicationPropertyFW;
import org.reaktivity.specification.amqp.internal.types.AmqpBinaryFW;
import org.reaktivity.specification.amqp.internal.types.AmqpBodyKind;
import org.reaktivity.specification.amqp.internal.types.AmqpBodyKindFW;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilities;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilitiesFW;
import org.reaktivity.specification.amqp.internal.types.AmqpMessageIdFW;
import org.reaktivity.specification.amqp.internal.types.AmqpPropertiesFW;
import org.reaktivity.specification.amqp.internal.types.AmqpReceiverSettleMode;
import org.reaktivity.specification.amqp.internal.types.AmqpReceiverSettleModeFW;
import org.reaktivity.specification.amqp.internal.types.AmqpSenderSettleMode;
import org.reaktivity.specification.amqp.internal.types.AmqpSenderSettleModeFW;
import org.reaktivity.specification.amqp.internal.types.AmqpTransferFlag;
import org.reaktivity.specification.amqp.internal.types.Array32FW;
import org.reaktivity.specification.amqp.internal.types.control.AmqpRouteExFW;
import org.reaktivity.specification.amqp.internal.types.stream.AmqpAbortExFW;
import org.reaktivity.specification.amqp.internal.types.stream.AmqpBeginExFW;
import org.reaktivity.specification.amqp.internal.types.stream.AmqpDataExFW;

public final class AmqpFunctions {
    private static final int MAX_BUFFER_SIZE = 8192;
    private static final byte[] NULL_TYPE = new byte[]{64};
    private static final byte BOOLEAN_TYPE = 86;
    private static final byte[] TRUE_TYPE = new byte[]{65};
    private static final byte[] FALSE_TYPE = new byte[]{66};
    private static final byte UBYTE_TYPE = 80;
    private static final byte USHORT_TYPE = 96;
    private static final byte UINT_TYPE = 112;
    private static final byte SMALLUINT_TYPE = 82;
    private static final byte[] UINT0_TYPE = new byte[]{67};
    private static final byte ULONG_TYPE = -128;
    private static final byte SMALLULONG_TYPE = 83;
    private static final byte[] ULONG0_TYPE = new byte[]{68};
    private static final byte BYTE_TYPE = 81;
    private static final byte SHORT_TYPE = 97;
    private static final byte INT_TYPE = 113;
    private static final byte SMALLINT_TYPE = 84;
    private static final byte LONG_TYPE = -127;
    private static final byte SMALLLONG_TYPE = 85;
    private static final byte CHAR_TYPE = 115;
    private static final byte TIMESTAMP_TYPE = -125;
    private static final byte VBIN8_TYPE = -96;
    private static final byte VBIN32_TYPE = -80;
    private static final byte STR8UTF8_TYPE = -95;
    private static final byte STR32UTF8_TYPE = -79;
    private static final byte SYM8_TYPE = -93;
    private static final byte SYM32_TYPE = -77;
    private static final int CONSTRUCTOR_BYTE_SIZE = 1;
    private static final int FIXED_SIZE1 = 1;
    private static final int FIXED_SIZE2 = 2;
    private static final int FIXED_SIZE4 = 4;
    private static final int FIXED_SIZE8 = 8;
    private static final Map<String, Byte> BYTES_BY_NAMES;

    @Function
    public static AmqpRouteExBuilder routeEx() {
        return new AmqpRouteExBuilder();
    }

    @Function
    public static AmqpBeginExBuilder beginEx() {
        return new AmqpBeginExBuilder();
    }

    @Function
    public static AmqpDataExBuilder dataEx() {
        return new AmqpDataExBuilder();
    }

    @Function
    public static AmqpDataExMatcherBuilder matchDataEx() {
        return new AmqpDataExMatcherBuilder();
    }

    @Function
    public static AmqpAbortExBuilder abortEx() {
        return new AmqpAbortExBuilder();
    }

    @Function
    public static byte[] randomBytes(int length) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)((Random)random).nextInt(256);
        }
        return bytes;
    }

    @Function
    public static String randomString(int length) {
        int leftLimit = 97;
        int rightLimit = 122;
        Random random = new Random();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomLimitedInt = leftLimit + (int)(random.nextFloat() * (float)(rightLimit - leftLimit + 1));
            buffer.append((char)randomLimitedInt);
        }
        return buffer.toString();
    }

    @Function(name="_null")
    public static byte[] nullValue() {
        return NULL_TYPE;
    }

    @Function(name="boolean")
    public static byte[] booleanValue(boolean value) {
        int byteLength = 2;
        byte byteValue = (byte)(value ? 1 : 0);
        return ByteBuffer.allocate(byteLength).put((byte)86).put(byteValue).array();
    }

    @Function(name="_true")
    public static byte[] trueValue() {
        return TRUE_TYPE;
    }

    @Function(name="_false")
    public static byte[] falseValue() {
        return FALSE_TYPE;
    }

    @Function
    public static byte[] ubyte(int value) {
        int byteLength = 2;
        return ByteBuffer.allocate(byteLength).put((byte)80).put((byte)value).array();
    }

    @Function
    public static byte[] ushort(int value) {
        int byteLength = 3;
        return ByteBuffer.allocate(byteLength).put((byte)96).putShort((short)value).array();
    }

    @Function
    public static byte[] uint(long value) {
        int byteLength = 5;
        return ByteBuffer.allocate(byteLength).put((byte)112).putInt((int)value).array();
    }

    @Function
    public static byte[] smalluint(int value) {
        int byteLength = 2;
        return ByteBuffer.allocate(byteLength).put((byte)82).put((byte)value).array();
    }

    @Function
    public static byte[] uint0() {
        return UINT0_TYPE;
    }

    @Function
    public static byte[] ulong(long value) {
        int byteLength = 9;
        return ByteBuffer.allocate(byteLength).put((byte)-128).putLong(value).array();
    }

    @Function
    public static byte[] smallulong(int value) {
        int byteLength = 2;
        return ByteBuffer.allocate(byteLength).put((byte)83).put((byte)value).array();
    }

    @Function
    public static byte[] ulong0() {
        return ULONG0_TYPE;
    }

    @Function(name="byte")
    public static byte[] byteValue(int value) {
        int byteLength = 2;
        return ByteBuffer.allocate(byteLength).put((byte)81).put((byte)value).array();
    }

    @Function(name="short")
    public static byte[] shortValue(int value) {
        int byteLength = 3;
        return ByteBuffer.allocate(byteLength).put((byte)97).putShort((short)value).array();
    }

    @Function(name="int")
    public static byte[] intValue(int value) {
        int byteLength = 5;
        return ByteBuffer.allocate(byteLength).put((byte)113).putInt(value).array();
    }

    @Function
    public static byte[] smallint(int value) {
        int byteLength = 2;
        return ByteBuffer.allocate(byteLength).put((byte)84).put((byte)value).array();
    }

    @Function(name="long")
    public static byte[] longValue(long value) {
        int byteLength = 9;
        return ByteBuffer.allocate(byteLength).put((byte)-127).putLong(value).array();
    }

    @Function
    public static byte[] smalllong(int value) {
        int byteLength = 2;
        return ByteBuffer.allocate(byteLength).put((byte)85).put((byte)value).array();
    }

    @Function(name="char")
    public static byte[] charValue(String value) {
        int byteLength = 5;
        int codePoint = value.codePointAt(0);
        byte[] valueArray = value.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(byteLength).put((byte)115);
        if (codePoint <= 127) {
            buffer.putShort((short)0).put((byte)0).put((byte)(valueArray[0] & 0x7F));
        } else if (codePoint <= 2047) {
            int byte1 = valueArray[0] & 0x1F;
            int byte2 = valueArray[1] & 0x3F;
            buffer.putShort((short)0).put((byte)(byte1 >> 2)).put((byte)(byte2 | byte1 << 6));
        } else if (codePoint <= 65535) {
            int byte1 = valueArray[0] & 0xF;
            int byte2 = valueArray[1] & 0x3F;
            int byte3 = valueArray[2] & 0x3F;
            buffer.put((byte)0).put((byte)(byte1 >> 4)).put((byte)(byte2 >> 2 | byte1 << 4)).put((byte)(byte3 | byte2 << 6));
        } else if (codePoint <= 0x10FFFF) {
            int byte1 = valueArray[0] & 7;
            int byte2 = valueArray[1] & 0x3F;
            int byte3 = valueArray[2] & 0x3F;
            int byte4 = valueArray[3] & 0x3F;
            buffer.put((byte)(byte1 >> 6)).put((byte)(byte2 >> 4 | byte1 << 6)).put((byte)(byte3 >> 2 | byte2 << 4)).put((byte)(byte4 | byte3 << 6));
        }
        return buffer.array();
    }

    @Function
    public static byte[] timestamp(long value) {
        int byteLength = 9;
        return ByteBuffer.allocate(byteLength).put((byte)-125).putLong(value).array();
    }

    @Function
    public static byte[] binary8(String value) {
        int length = value.length();
        int byteLength = 2 + length;
        return ByteBuffer.allocate(byteLength).put((byte)-96).put((byte)length).put(value.getBytes(StandardCharsets.UTF_8)).array();
    }

    @Function
    public static byte[] binary32(String value) {
        int length = value.length();
        int byteLength = 5 + length;
        return ByteBuffer.allocate(byteLength).put((byte)-80).putInt(length).put(value.getBytes(StandardCharsets.UTF_8)).array();
    }

    @Function
    public static byte[] string8(String value) {
        int length = value.length();
        int byteLength = 2 + length;
        return ByteBuffer.allocate(byteLength).put((byte)-95).put((byte)length).put(value.getBytes(StandardCharsets.UTF_8)).array();
    }

    @Function
    public static byte[] string32(String value) {
        int length = value.length();
        int byteLength = 5 + length;
        return ByteBuffer.allocate(byteLength).put((byte)-79).putInt(length).put(value.getBytes(StandardCharsets.UTF_8)).array();
    }

    @Function
    public static byte[] symbol8(String value) {
        int length = value.length();
        int byteLength = 2 + length;
        return ByteBuffer.allocate(byteLength).put((byte)-93).put((byte)length).put(value.getBytes(StandardCharsets.UTF_8)).array();
    }

    @Function
    public static byte[] symbol32(String value) {
        int length = value.length();
        int byteLength = 5 + length;
        return ByteBuffer.allocate(byteLength).put((byte)-77).putInt(length).put(value.getBytes(StandardCharsets.UTF_8)).array();
    }

    @Function
    public static byte[] propertyTypes(String ... values) {
        ByteBuffer buffer = ByteBuffer.allocate(values.length);
        for (String value : values) {
            buffer.put(BYTES_BY_NAMES.get(value));
        }
        return buffer.array();
    }

    private AmqpFunctions() {
    }

    static {
        HashMap<String, Byte> byteByNames = new HashMap<String, Byte>();
        byteByNames.put("null", NULL_TYPE[0]);
        byteByNames.put("boolean", (byte)86);
        byteByNames.put("true", TRUE_TYPE[0]);
        byteByNames.put("false", FALSE_TYPE[0]);
        byteByNames.put("ubyte", (byte)80);
        byteByNames.put("ushort", (byte)96);
        byteByNames.put("uint", (byte)112);
        byteByNames.put("smalluint", (byte)82);
        byteByNames.put("uint0", UINT0_TYPE[0]);
        byteByNames.put("ulong", (byte)-128);
        byteByNames.put("smallulong", (byte)83);
        byteByNames.put("ulong0", ULONG0_TYPE[0]);
        byteByNames.put("byte", (byte)81);
        byteByNames.put("short", (byte)97);
        byteByNames.put("int", (byte)113);
        byteByNames.put("smallint", (byte)84);
        byteByNames.put("long", (byte)-127);
        byteByNames.put("smalllong", (byte)85);
        byteByNames.put("char", (byte)115);
        byteByNames.put("timestamp", (byte)-125);
        byteByNames.put("vbin8", (byte)-96);
        byteByNames.put("vbin32", (byte)-80);
        byteByNames.put("str8-utf8", (byte)-95);
        byteByNames.put("str32-utf8", (byte)-79);
        byteByNames.put("sym8", (byte)-93);
        byteByNames.put("sym32", (byte)-77);
        BYTES_BY_NAMES = byteByNames;
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(AmqpFunctions.class);
        }

        public String getPrefixName() {
            return "amqp";
        }
    }

    public static class AmqpAbortExBuilder {
        private final AmqpAbortExFW.Builder abortExRW;

        public AmqpAbortExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.abortExRW = new AmqpAbortExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public AmqpAbortExBuilder typeId(int typeId) {
            this.abortExRW.typeId(typeId);
            return this;
        }

        public AmqpAbortExBuilder condition(String condition) {
            this.abortExRW.condition(condition);
            return this;
        }

        public byte[] build() {
            AmqpAbortExFW amqpAbortEx = this.abortExRW.build();
            byte[] result = new byte[amqpAbortEx.sizeof()];
            amqpAbortEx.buffer().getBytes(0, result);
            return result;
        }
    }

    public static final class AmqpDataExMatcherBuilder {
        private final DirectBuffer bufferRO = new UnsafeBuffer();
        private final AmqpDataExFW dataExRO = new AmqpDataExFW();
        private Integer typeId;
        private Integer deferred;
        private AmqpBinaryFW.Builder deliveryTagRW;
        private Long messageFormat;
        private Integer flags;
        private String bodyKind;
        private Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW> annotationsRW;
        private AmqpPropertiesFW.Builder propertiesRW;
        private Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW> applicationPropertiesRW;

        public AmqpDataExMatcherBuilder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        public AmqpDataExMatcherBuilder deferred(int deferred) {
            this.deferred = deferred;
            return this;
        }

        public AmqpDataExMatcherBuilder deliveryTag(String deliveryTag) {
            assert (this.deliveryTagRW == null);
            this.deliveryTagRW = new AmqpBinaryFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
            this.deliveryTagRW.bytes(b -> b.set(deliveryTag.getBytes(StandardCharsets.UTF_8)));
            return this;
        }

        public AmqpDataExMatcherBuilder messageFormat(long messageFormat) {
            assert (this.messageFormat == null);
            this.messageFormat = messageFormat;
            return this;
        }

        public AmqpDataExMatcherBuilder flags(String ... flags) {
            assert (this.flags == null);
            int value = 0;
            block6: for (String flag : flags) {
                AmqpTransferFlag transferFlag = AmqpTransferFlag.valueOf(flag);
                switch (transferFlag) {
                    case SETTLED: {
                        value |= 1;
                        continue block6;
                    }
                    case RESUME: {
                        value |= 2;
                        continue block6;
                    }
                    case ABORTED: {
                        value |= 4;
                        continue block6;
                    }
                    case BATCHABLE: {
                        value |= 8;
                    }
                }
            }
            this.flags = value;
            return this;
        }

        public AmqpDataExMatcherBuilder annotation(Object key, byte[] value) {
            if (this.annotationsRW == null) {
                this.annotationsRW = new Array32FW.Builder<AmqpAnnotationFW.Builder, AmqpAnnotationFW>(new AmqpAnnotationFW.Builder(), new AmqpAnnotationFW()).wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
            }
            return key instanceof Long ? this.annotations((Long)key, value) : this.annotations((String)key, value);
        }

        private AmqpDataExMatcherBuilder annotations(long key, byte[] value) {
            this.annotationsRW.item(a -> a.key(k -> k.id(key)).value(v -> v.bytes(o -> o.set(value))));
            return this;
        }

        private AmqpDataExMatcherBuilder annotations(String key, byte[] value) {
            this.annotationsRW.item(a -> a.key(k -> k.name(key)).value(v -> v.bytes(o -> o.set(value))));
            return this;
        }

        public AmqpDataExMatcherBuilder messageId(Object messageId) {
            AmqpPropertiesFW.Builder properties = this.properties();
            if (messageId instanceof Long) {
                properties.messageId((AmqpMessageIdFW.Builder m) -> m.ulong((Long)messageId));
                return this;
            }
            if (messageId instanceof byte[]) {
                properties.messageId((AmqpMessageIdFW.Builder m) -> m.binary(b -> b.bytes(x -> x.set((byte[])messageId))));
                return this;
            }
            properties.messageId((AmqpMessageIdFW.Builder m) -> m.stringtype((String)messageId));
            return this;
        }

        public AmqpDataExMatcherBuilder userId(String userId) {
            this.properties().userId((AmqpBinaryFW.Builder u) -> u.bytes(b -> b.set(userId.getBytes(StandardCharsets.UTF_8))));
            return this;
        }

        public AmqpDataExMatcherBuilder to(String to) {
            this.properties().to(to);
            return this;
        }

        public AmqpDataExMatcherBuilder subject(String subject) {
            this.properties().subject(subject);
            return this;
        }

        public AmqpDataExMatcherBuilder replyTo(String replyTo) {
            this.properties().replyTo(replyTo);
            return this;
        }

        public AmqpDataExMatcherBuilder correlationId(Object correlationId) {
            AmqpPropertiesFW.Builder properties = this.properties();
            if (correlationId instanceof Long) {
                properties.correlationId((AmqpMessageIdFW.Builder m) -> m.ulong((Long)correlationId));
                return this;
            }
            if (correlationId instanceof byte[]) {
                properties.correlationId((AmqpMessageIdFW.Builder m) -> m.binary(b -> b.bytes(x -> x.set((byte[])correlationId))));
                return this;
            }
            properties.correlationId((AmqpMessageIdFW.Builder m) -> m.stringtype((String)correlationId));
            return this;
        }

        public AmqpDataExMatcherBuilder contentType(String contentType) {
            this.properties().contentType(contentType);
            return this;
        }

        public AmqpDataExMatcherBuilder contentEncoding(String contentEncoding) {
            this.properties().contentEncoding(contentEncoding);
            return this;
        }

        public AmqpDataExMatcherBuilder absoluteExpiryTime(long absoluteExpiryTime) {
            this.properties().absoluteExpiryTime(absoluteExpiryTime);
            return this;
        }

        public AmqpDataExMatcherBuilder creationTime(long creationTime) {
            this.properties().creationTime(creationTime);
            return this;
        }

        public AmqpDataExMatcherBuilder groupId(String groupId) {
            this.properties().groupId(groupId);
            return this;
        }

        public AmqpDataExMatcherBuilder groupSequence(int groupSequence) {
            this.properties().groupSequence(groupSequence);
            return this;
        }

        public AmqpDataExMatcherBuilder replyToGroupId(String replyToGroupId) {
            this.properties().replyToGroupId(replyToGroupId);
            return this;
        }

        private AmqpPropertiesFW.Builder properties() {
            if (this.propertiesRW == null) {
                this.propertiesRW = new AmqpPropertiesFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
            }
            return this.propertiesRW;
        }

        public AmqpDataExMatcherBuilder property(String key, byte[] value) {
            if (this.applicationPropertiesRW == null) {
                this.applicationPropertiesRW = new Array32FW.Builder<AmqpApplicationPropertyFW.Builder, AmqpApplicationPropertyFW>(new AmqpApplicationPropertyFW.Builder(), new AmqpApplicationPropertyFW()).wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
            }
            this.applicationPropertiesRW.item(a -> a.key(key).value(v -> v.bytes(o -> o.set(value))));
            return this;
        }

        public AmqpDataExMatcherBuilder bodyKind(String bodyKind) {
            assert (this.bodyKind == null);
            this.bodyKind = bodyKind;
            return this;
        }

        public BytesMatcher build() {
            return this.typeId != null ? this::match : buf -> null;
        }

        private AmqpDataExFW match(ByteBuffer byteBuf) throws Exception {
            this.bufferRO.wrap(byteBuf);
            AmqpDataExFW dataEx = this.dataExRO.tryWrap(this.bufferRO, byteBuf.position(), byteBuf.capacity());
            if (dataEx != null && this.matchTypeId(dataEx) && this.matchDeferred(dataEx) && this.matchDeliveryTag(dataEx) && this.matchMessageFormat(dataEx) && this.matchFlags(dataEx) && this.matchAnnotations(dataEx) && this.matchProperties(dataEx) && this.matchApplicationProperties(dataEx) && this.matchBodyKind(dataEx)) {
                byteBuf.position(byteBuf.position() + dataEx.sizeof());
                return dataEx;
            }
            throw new Exception(dataEx.toString());
        }

        private boolean matchTypeId(AmqpDataExFW dataEx) {
            return this.typeId.intValue() == dataEx.typeId();
        }

        private boolean matchDeferred(AmqpDataExFW dataEx) {
            return this.deferred == null || this.deferred.intValue() == dataEx.deferred();
        }

        private boolean matchDeliveryTag(AmqpDataExFW dataEx) {
            return this.deliveryTagRW == null || this.deliveryTagRW.build().equals(dataEx.deliveryTag());
        }

        private boolean matchMessageFormat(AmqpDataExFW dataEx) {
            return this.messageFormat == null || this.messageFormat.longValue() == dataEx.messageFormat();
        }

        private boolean matchFlags(AmqpDataExFW dataEx) {
            return this.flags == null || this.flags.intValue() == dataEx.flags();
        }

        private boolean matchAnnotations(AmqpDataExFW dataEx) {
            return this.annotationsRW == null || this.annotationsRW.build().equals(dataEx.annotations());
        }

        private boolean matchProperties(AmqpDataExFW dataEx) {
            return this.propertiesRW == null || this.propertiesRW.build().equals(dataEx.properties());
        }

        private boolean matchApplicationProperties(AmqpDataExFW dataEx) {
            return this.applicationPropertiesRW == null || this.applicationPropertiesRW.build().equals(dataEx.applicationProperties());
        }

        private boolean matchBodyKind(AmqpDataExFW dataEx) {
            return this.bodyKind == null || this.bodyKind.equals(dataEx.bodyKind().get().name());
        }
    }

    public static class AmqpDataExBuilder {
        private final AmqpDataExFW.Builder dataExRW;
        private AmqpPropertiesFW.Builder propertiesRW;
        private boolean isPropertiesSet;

        public AmqpDataExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.dataExRW = new AmqpDataExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public AmqpDataExBuilder typeId(int typeId) {
            this.dataExRW.typeId(typeId);
            return this;
        }

        public AmqpDataExBuilder deferred(int deferred) {
            this.dataExRW.deferred(deferred);
            return this;
        }

        public AmqpDataExBuilder deliveryTag(String deliveryTag) {
            this.dataExRW.deliveryTag((AmqpBinaryFW.Builder d) -> d.bytes(b -> b.set(deliveryTag.getBytes(StandardCharsets.UTF_8))));
            return this;
        }

        public AmqpDataExBuilder messageFormat(long messageFormat) {
            this.dataExRW.messageFormat(messageFormat);
            return this;
        }

        public AmqpDataExBuilder flags(String ... flags) {
            int value = 0;
            block6: for (String flag : flags) {
                AmqpTransferFlag transferFlag = AmqpTransferFlag.valueOf(flag);
                switch (transferFlag) {
                    case SETTLED: {
                        value |= 1;
                        continue block6;
                    }
                    case RESUME: {
                        value |= 2;
                        continue block6;
                    }
                    case ABORTED: {
                        value |= 4;
                        continue block6;
                    }
                    case BATCHABLE: {
                        value |= 8;
                    }
                }
            }
            this.dataExRW.flags(value);
            return this;
        }

        public AmqpDataExBuilder annotation(Object key, byte[] value) {
            return key instanceof Long ? this.annotations((Long)key, value) : this.annotations((String)key, value);
        }

        private AmqpDataExBuilder annotations(long key, byte[] value) {
            this.dataExRW.annotationsItem(a -> a.key(k -> k.id(key)).value(v -> v.bytes(o -> o.set(value))));
            return this;
        }

        private AmqpDataExBuilder annotations(String key, byte[] value) {
            this.dataExRW.annotationsItem(a -> a.key(k -> k.name(key)).value(v -> v.bytes(o -> o.set(value))));
            return this;
        }

        public AmqpDataExBuilder messageId(Object messageId) {
            AmqpPropertiesFW.Builder properties = this.properties();
            if (messageId instanceof Long) {
                properties.messageId((AmqpMessageIdFW.Builder m) -> m.ulong((Long)messageId));
                return this;
            }
            if (messageId instanceof byte[]) {
                properties.messageId((AmqpMessageIdFW.Builder m) -> m.binary(b -> b.bytes(x -> x.set((byte[])messageId))));
                return this;
            }
            properties.messageId((AmqpMessageIdFW.Builder m) -> m.stringtype((String)messageId));
            return this;
        }

        public AmqpDataExBuilder userId(String userId) {
            this.properties().userId((AmqpBinaryFW.Builder u) -> u.bytes(b -> b.set(userId.getBytes(StandardCharsets.UTF_8))));
            return this;
        }

        public AmqpDataExBuilder to(String to) {
            this.properties().to(to);
            return this;
        }

        public AmqpDataExBuilder subject(String subject) {
            this.properties().subject(subject);
            return this;
        }

        public AmqpDataExBuilder replyTo(String replyTo) {
            this.properties().replyTo(replyTo);
            return this;
        }

        public AmqpDataExBuilder correlationId(Object correlationId) {
            AmqpPropertiesFW.Builder properties = this.properties();
            if (correlationId instanceof Long) {
                properties.correlationId((AmqpMessageIdFW.Builder m) -> m.ulong((Long)correlationId));
                return this;
            }
            if (correlationId instanceof byte[]) {
                properties.correlationId((AmqpMessageIdFW.Builder m) -> m.binary(b -> b.bytes(x -> x.set((byte[])correlationId))));
                return this;
            }
            properties.correlationId((AmqpMessageIdFW.Builder m) -> m.stringtype((String)correlationId));
            return this;
        }

        public AmqpDataExBuilder contentType(String contentType) {
            this.properties().contentType(contentType);
            return this;
        }

        public AmqpDataExBuilder contentEncoding(String contentEncoding) {
            this.properties().contentEncoding(contentEncoding);
            return this;
        }

        public AmqpDataExBuilder absoluteExpiryTime(long absoluteExpiryTime) {
            this.properties().absoluteExpiryTime(absoluteExpiryTime);
            return this;
        }

        public AmqpDataExBuilder creationTime(long creationTime) {
            this.properties().creationTime(creationTime);
            return this;
        }

        public AmqpDataExBuilder groupId(String groupId) {
            this.properties().groupId(groupId);
            return this;
        }

        public AmqpDataExBuilder groupSequence(int groupSequence) {
            this.properties().groupSequence(groupSequence);
            return this;
        }

        public AmqpDataExBuilder replyToGroupId(String replyToGroupId) {
            this.properties().replyToGroupId(replyToGroupId);
            return this;
        }

        public AmqpDataExBuilder property(String key, byte[] value) {
            if (this.propertiesRW != null && !this.isPropertiesSet) {
                AmqpPropertiesFW properties = this.propertiesRW.build();
                this.dataExRW.properties(properties);
                this.isPropertiesSet = true;
            }
            this.dataExRW.applicationPropertiesItem(a -> a.key(key).value(v -> v.bytes(o -> o.set(value))));
            return this;
        }

        private AmqpPropertiesFW.Builder properties() {
            if (this.propertiesRW == null) {
                this.propertiesRW = new AmqpPropertiesFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
            }
            return this.propertiesRW;
        }

        public AmqpDataExBuilder bodyKind(String bodyKind) {
            if (this.propertiesRW != null && !this.isPropertiesSet) {
                AmqpPropertiesFW properties = this.propertiesRW.build();
                this.dataExRW.properties(properties);
                this.isPropertiesSet = true;
            }
            this.dataExRW.bodyKind((AmqpBodyKindFW.Builder b) -> b.set(AmqpBodyKind.valueOf(bodyKind)));
            return this;
        }

        public byte[] build() {
            if (this.propertiesRW != null && !this.isPropertiesSet) {
                AmqpPropertiesFW properties = this.propertiesRW.build();
                this.dataExRW.properties(properties);
            }
            AmqpDataExFW amqpDataEx = this.dataExRW.build();
            byte[] result = new byte[amqpDataEx.sizeof()];
            amqpDataEx.buffer().getBytes(0, result);
            return result;
        }
    }

    public static class AmqpBeginExBuilder {
        private final AmqpBeginExFW.Builder beginExRW;

        public AmqpBeginExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.beginExRW = new AmqpBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public AmqpBeginExBuilder typeId(int typeId) {
            this.beginExRW.typeId(typeId);
            return this;
        }

        public AmqpBeginExBuilder address(String address) {
            this.beginExRW.address(address);
            return this;
        }

        public AmqpBeginExBuilder capabilities(String capabilities) {
            this.beginExRW.capabilities((AmqpCapabilitiesFW.Builder r) -> r.set(AmqpCapabilities.valueOf(capabilities)));
            return this;
        }

        public AmqpBeginExBuilder senderSettleMode(String senderSettleMode) {
            this.beginExRW.senderSettleMode((AmqpSenderSettleModeFW.Builder s) -> s.set(AmqpSenderSettleMode.valueOf(senderSettleMode)));
            return this;
        }

        public AmqpBeginExBuilder receiverSettleMode(String receiverSettleMode) {
            this.beginExRW.receiverSettleMode((AmqpReceiverSettleModeFW.Builder r) -> r.set(AmqpReceiverSettleMode.valueOf(receiverSettleMode)));
            return this;
        }

        public byte[] build() {
            AmqpBeginExFW amqpBeginEx = this.beginExRW.build();
            byte[] result = new byte[amqpBeginEx.sizeof()];
            amqpBeginEx.buffer().getBytes(0, result);
            return result;
        }
    }

    public static class AmqpRouteExBuilder {
        private final AmqpRouteExFW.Builder routeExRW;

        public AmqpRouteExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.routeExRW = new AmqpRouteExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public AmqpRouteExBuilder address(String address) {
            this.routeExRW.address(address);
            return this;
        }

        public AmqpRouteExBuilder capabilities(String capabilities) {
            this.routeExRW.capabilities((AmqpCapabilitiesFW.Builder r) -> r.set(AmqpCapabilities.valueOf(capabilities)));
            return this;
        }

        public byte[] build() {
            AmqpRouteExFW amqpRouteEx = this.routeExRW.build();
            byte[] result = new byte[amqpRouteEx.sizeof()];
            amqpRouteEx.buffer().getBytes(0, result);
            return result;
        }
    }
}

