/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpAnnotationKeyFW;
import org.reaktivity.specification.amqp.internal.types.AmqpBinaryFW;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;

public final class AmqpAnnotationFW
extends Flyweight {
    public static final int FIELD_OFFSET_KEY = 0;
    public static final int FIELD_OFFSET_VALUE = 0;
    private final AmqpAnnotationKeyFW keyRO = new AmqpAnnotationKeyFW();
    private final AmqpBinaryFW valueRO = new AmqpBinaryFW();

    public AmqpAnnotationKeyFW key() {
        return this.keyRO;
    }

    public AmqpBinaryFW value() {
        return this.valueRO;
    }

    @Override
    public AmqpAnnotationFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.keyRO.wrap(buffer, offset + 0, maxLimit);
        this.valueRO.wrap(buffer, this.keyRO.limit() + 0, maxLimit);
        AmqpAnnotationFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpAnnotationFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.keyRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.valueRO.tryWrap(buffer, this.keyRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("AMQP_ANNOTATION [key=%s, value=%s]", this.key(), this.value());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpAnnotationFW> {
        private static final int INDEX_KEY = 0;
        private static final int INDEX_VALUE = 1;
        private static final int FIELD_COUNT = 2;
        private final AmqpAnnotationKeyFW.Builder keyRW = new AmqpAnnotationKeyFW.Builder();
        private final AmqpBinaryFW.Builder valueRW = new AmqpBinaryFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpAnnotationFW());
        }

        public Builder key(Consumer<AmqpAnnotationKeyFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            AmqpAnnotationKeyFW.Builder keyRW = this.keyRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(keyRW);
            this.limit(((AmqpAnnotationKeyFW)keyRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder key(AmqpAnnotationKeyFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder value(Consumer<AmqpBinaryFW.Builder> mutator) {
            if (this.lastFieldSet < 0) {
                this.key((AmqpAnnotationKeyFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 0);
            AmqpBinaryFW.Builder valueRW = this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(valueRW);
            this.limit(valueRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder value(AmqpBinaryFW field) {
            if (this.lastFieldSet < 0) {
                this.key((AmqpAnnotationKeyFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpAnnotationFW>, ? extends Flyweight.Builder<AmqpAnnotationFW>, AmqpAnnotationFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpAnnotationFW build() {
            if (this.lastFieldSet < 1) {
                this.value((AmqpBinaryFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (AmqpAnnotationFW)super.build();
        }
    }
}

