/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpBinaryFW;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.String32FW;

public final class AmqpApplicationPropertyFW
extends Flyweight {
    public static final int FIELD_OFFSET_KEY = 0;
    public static final int FIELD_OFFSET_VALUE = 0;
    private final String32FW keyRO = new String32FW(ByteOrder.BIG_ENDIAN);
    private final AmqpBinaryFW valueRO = new AmqpBinaryFW();

    public String32FW key() {
        return this.keyRO;
    }

    public AmqpBinaryFW value() {
        return this.valueRO;
    }

    @Override
    public AmqpApplicationPropertyFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.keyRO.wrap(buffer, offset + 0, maxLimit);
        this.valueRO.wrap(buffer, this.keyRO.limit() + 0, maxLimit);
        AmqpApplicationPropertyFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpApplicationPropertyFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.keyRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.valueRO.tryWrap(buffer, this.keyRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("AMQP_APPLICATION_PROPERTY [key=%s, value=%s]", this.keyRO.asString(), this.value());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpApplicationPropertyFW> {
        private static final int INDEX_KEY = 0;
        private static final int INDEX_VALUE = 1;
        private static final int FIELD_COUNT = 2;
        private final String32FW.Builder keyRW = new String32FW.Builder(ByteOrder.BIG_ENDIAN);
        private final AmqpBinaryFW.Builder valueRW = new AmqpBinaryFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpApplicationPropertyFW());
        }

        private String32FW.Builder key() {
            assert (this.lastFieldSet == -1);
            return this.keyRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder key(String value) {
            String32FW.Builder keyRW = this.key();
            keyRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(keyRW.build().limit());
            return this;
        }

        public Builder key(String32FW value) {
            String32FW.Builder keyRW = this.key();
            keyRW.set((Flyweight)value);
            this.lastFieldSet = 0;
            this.limit(keyRW.build().limit());
            return this;
        }

        public Builder key(DirectBuffer buffer, int offset, int length) {
            String32FW.Builder keyRW = this.key();
            keyRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(keyRW.build().limit());
            return this;
        }

        public Builder value(Consumer<AmqpBinaryFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            AmqpBinaryFW.Builder valueRW = this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(valueRW);
            this.limit(valueRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder value(AmqpBinaryFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpApplicationPropertyFW>, ? extends Flyweight.Builder<AmqpApplicationPropertyFW>, AmqpApplicationPropertyFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpApplicationPropertyFW build() {
            if (this.lastFieldSet < 1) {
                this.value((AmqpBinaryFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (AmqpApplicationPropertyFW)super.build();
        }
    }
}

