/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.OctetsFW;

public final class AmqpBinaryFW
extends Flyweight {
    public static final int FIELD_OFFSET_LENGTH = 0;
    private static final int FIELD_SIZE_LENGTH = 2;
    public static final int FIELD_OFFSET_BYTES = 2;
    private final OctetsFW bytesRO = new OctetsFW();

    public int length() {
        return this.buffer().getShort(this.offset() + 0, ByteOrder.BIG_ENDIAN) & 0xFFFF;
    }

    public OctetsFW bytes() {
        return this.bytesRO;
    }

    @Override
    public AmqpBinaryFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.bytesRO.wrap(buffer, offset + 2, offset + 2 + this.length());
        AmqpBinaryFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpBinaryFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 2 + this.length();
        if (limit > maxLimit || null == this.bytesRO.tryWrap(buffer, offset + 2, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.bytesRO.limit();
    }

    public String toString() {
        return String.format("AMQP_BINARY [length=%d, bytes=%s]", this.length(), this.bytes());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpBinaryFW> {
        public static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_BYTES = 0;
        private static final int FIELD_COUNT = 1;
        private int dynamicOffsetLength;
        private final OctetsFW.Builder bytesRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpBinaryFW());
        }

        private Builder length(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"length\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"length\"", value));
            }
            int newLimit = this.limit() + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF), ByteOrder.BIG_ENDIAN);
            this.dynamicOffsetLength = this.limit();
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder bytes() {
            this.length(0);
            assert (this.lastFieldSet == -1);
            return this.bytesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder bytes(OctetsFW value) {
            OctetsFW.Builder bytesRW = this.bytes();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"bytes\" that does not default to null");
            }
            bytesRW.set(value);
            int newLimit = ((OctetsFW)bytesRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder bytes(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder bytesRW = this.bytes();
            mutator.accept(bytesRW);
            int newLimit = ((OctetsFW)bytesRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder bytes(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder bytesRW = this.bytes();
            bytesRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)bytesRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpBinaryFW>, ? extends Flyweight.Builder<AmqpBinaryFW>, AmqpBinaryFW> array) {
            super.wrap(array);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpBinaryFW build() {
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (AmqpBinaryFW)super.build();
        }
    }
}

