/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.http.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.http.internal.types.Array32FW;
import org.reaktivity.specification.http.internal.types.ArrayFW;
import org.reaktivity.specification.http.internal.types.Flyweight;
import org.reaktivity.specification.http.internal.types.HttpHeaderFW;

public final class HttpEndExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TRAILERS = 4;
    private final Array32FW<HttpHeaderFW> trailersRO = new Array32FW<HttpHeaderFW>(new HttpHeaderFW());

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public Array32FW<HttpHeaderFW> trailers() {
        return this.trailersRO;
    }

    @Override
    public HttpEndExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.trailersRO.wrap(buffer, offset + 4, maxLimit);
        HttpEndExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public HttpEndExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.trailersRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.trailersRO.limit();
    }

    public String toString() {
        return String.format("HTTP_END_EX [typeId=%d, trailers=%s]", this.typeId(), this.trailers());
    }

    public static final class Builder
    extends Flyweight.Builder<HttpEndExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_TRAILERS = 1;
        private static final int FIELD_COUNT = 2;
        private final Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> trailersRW = new Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new HttpEndExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            HttpEndExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder trailers(Consumer<Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
            assert (this.lastFieldSet == 0);
            Flyweight.Builder trailersRW = this.trailersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>)trailersRW);
            this.limit(((Array32FW)((Array32FW.Builder)trailersRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder trailers(Array32FW<HttpHeaderFW> field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            HttpEndExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder trailersItem(Consumer<HttpHeaderFW.Builder> mutator) {
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.trailersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.trailersRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.trailersRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<HttpEndExFW>, ? extends Flyweight.Builder<HttpEndExFW>, HttpEndExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public HttpEndExFW build() {
            if (this.lastFieldSet < 1) {
                this.trailers((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (HttpEndExFW)super.build();
        }
    }
}

