/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.http.internal;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableBoolean;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.BytesMatcher;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.http.internal.types.control.HttpRouteExFW;
import org.reaktivity.specification.http.internal.types.stream.HttpBeginExFW;
import org.reaktivity.specification.http.internal.types.stream.HttpChallengeExFW;
import org.reaktivity.specification.http.internal.types.stream.HttpDataExFW;
import org.reaktivity.specification.http.internal.types.stream.HttpEndExFW;

public final class HttpFunctions {
    @Function
    public static HttpRouteExBuilder routeEx() {
        return new HttpRouteExBuilder();
    }

    @Function
    public static HttpBeginExBuilder beginEx() {
        return new HttpBeginExBuilder();
    }

    @Function
    public static HttpBeginExMatcherBuilder matchBeginEx() {
        return new HttpBeginExMatcherBuilder();
    }

    @Function
    public static HttpDataExBuilder dataEx() {
        return new HttpDataExBuilder();
    }

    @Function
    public static HttpEndExBuilder endEx() {
        return new HttpEndExBuilder();
    }

    @Function
    public static HttpChallengeExBuilder challengeEx() {
        return new HttpChallengeExBuilder();
    }

    @Function
    public static String randomInvalidVersion() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String randomVersion = null;
        Pattern validVersionPattern = Pattern.compile("HTTP/1\\.(\\d)+");
        Matcher validVersionMatcher = null;
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+-=`~[]\\{}|;':\",./<>?";
        do {
            StringBuilder result = new StringBuilder();
            int randomLength = ((Random)random).nextInt(30) + 1;
            for (int i = 0; i < randomLength; ++i) {
                result.append(chars.charAt(((Random)random).nextInt(chars.length())));
            }
            randomVersion = result.toString();
            validVersionMatcher = validVersionPattern.matcher(randomVersion);
        } while (randomVersion.length() > 1 && validVersionMatcher.matches());
        return randomVersion;
    }

    @Function
    public static String randomMethodNot(String method) {
        String result;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String[] methods = new String[]{"GET", "OPTIONS", "HEAD", "POST", "PUT", "DELETE", "TRACE", "CONNECT"};
        while ((result = methods[((Random)random).nextInt(methods.length)]).equalsIgnoreCase(method)) {
        }
        return result;
    }

    @Function
    public static String randomHeaderNot(String header) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String commonHeaderChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+-=`~[]\\{}|;':\",./<>?";
        StringBuilder result = new StringBuilder();
        do {
            int maxHeaderLength = 200;
            int randomHeaderLength = ((Random)random).nextInt(maxHeaderLength) + 1;
            for (int i = 0; i < randomHeaderLength; ++i) {
                result.append(commonHeaderChars.charAt(((Random)random).nextInt(commonHeaderChars.length())));
            }
        } while (result.toString().equalsIgnoreCase(header));
        return result.toString();
    }

    @Function
    public static String randomizeLetterCase(String text) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            c = ((Random)random).nextBoolean() ? Character.toUpperCase(c) : Character.toLowerCase(c);
            result.append(c);
        }
        return result.toString();
    }

    @Function
    public static String randomCaseNot(String value) {
        String result;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        char[] resultChars = new char[value.length()];
        do {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                resultChars[i] = ((Random)random).nextBoolean() ? Character.toUpperCase(c) : Character.toLowerCase(c);
            }
        } while ((result = new String(resultChars)).equals(value));
        return result;
    }

    @Function
    public static byte[] copyOfRange(byte[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to);
    }

    @Function
    public static byte[] randomAscii(int length) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] result = new byte[length];
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+-=`~[]\\{}|;':\",./<>?";
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)alphabet.charAt(((Random)random).nextInt(alphabet.length()));
        }
        return result;
    }

    @Function
    public static byte[] randomBytes(int length) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)((Random)random).nextInt(256);
        }
        return bytes;
    }

    @Function
    public static byte[] randomBytesUTF8(int length) {
        byte[] bytes = new byte[length];
        HttpFunctions.randomBytesUTF8(bytes, 0, length);
        return bytes;
    }

    @Function
    public static byte[] randomBytesInvalidUTF8(int length) {
        byte[] bytes = new byte[length];
        bytes[0] = -128;
        HttpFunctions.randomBytesUTF8(bytes, 1, length - 1);
        return bytes;
    }

    @Function
    public static byte[] randomBytesUnalignedUTF8(int length, int unalignAt) {
        assert (-1 < unalignAt && unalignAt < length);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[length];
        int straddleWidth = ((Random)random).nextInt(3) + 2;
        int straddleAt = unalignAt - straddleWidth + 1;
        HttpFunctions.randomBytesUTF8(bytes, 0, straddleAt);
        int realignAt = HttpFunctions.randomCharBytesUTF8(bytes, straddleAt, straddleWidth);
        HttpFunctions.randomBytesUTF8(bytes, realignAt, length);
        return bytes;
    }

    private static void randomBytesUTF8(byte[] bytes, int start, int end) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int offset = start;
        while (offset < end) {
            int remaining = end - offset;
            int width = Math.min(((Random)random).nextInt(4) + 1, remaining);
            offset = HttpFunctions.randomCharBytesUTF8(bytes, offset, width);
        }
    }

    private static int randomCharBytesUTF8(byte[] bytes, int offset, int width) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        switch (width) {
            case 1: {
                bytes[offset++] = (byte)((Random)random).nextInt(128);
                break;
            }
            case 2: {
                bytes[offset++] = (byte)(0xC0 | ((Random)random).nextInt(32) | 1 << ((Random)random).nextInt(4) + 1);
                bytes[offset++] = (byte)(0x80 | ((Random)random).nextInt(64));
                break;
            }
            case 3: {
                bytes[offset++] = (byte)(0xE0 | ((Random)random).nextInt(8) | 1 << ((Random)random).nextInt(3));
                bytes[offset++] = (byte)(0x80 | ((Random)random).nextInt(64));
                bytes[offset++] = (byte)(0x80 | ((Random)random).nextInt(64));
                break;
            }
            case 4: {
                bytes[offset++] = (byte)(0xF0 | ((Random)random).nextInt(4) | 1 << ((Random)random).nextInt(2));
                bytes[offset++] = (byte)(0x80 | ((Random)random).nextInt(16));
                bytes[offset++] = (byte)(0x80 | ((Random)random).nextInt(64));
                bytes[offset++] = (byte)(0x80 | ((Random)random).nextInt(64));
            }
        }
        return offset;
    }

    private HttpFunctions() {
    }

    public static final class HttpRouteExBuilder {
        private final HttpRouteExFW.Builder routeExRW;

        private HttpRouteExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.routeExRW = new HttpRouteExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public HttpRouteExBuilder header(String name, String value) {
            this.routeExRW.headersItem(b -> b.name(name).value(value));
            return this;
        }

        public HttpRouteExBuilder override(String name, String value) {
            this.routeExRW.overridesItem(b -> b.name(name).value(value));
            return this;
        }

        public byte[] build() {
            HttpRouteExFW routeEx = this.routeExRW.build();
            byte[] array = new byte[routeEx.sizeof()];
            routeEx.buffer().getBytes(routeEx.offset(), array);
            return array;
        }
    }

    public static final class HttpBeginExBuilder {
        private final HttpBeginExFW.Builder beginExRW;

        private HttpBeginExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.beginExRW = new HttpBeginExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public HttpBeginExBuilder typeId(int typeId) {
            this.beginExRW.typeId(typeId);
            return this;
        }

        public HttpBeginExBuilder header(String name, String value) {
            this.beginExRW.headersItem(b -> b.name(name).value(value));
            return this;
        }

        public byte[] build() {
            HttpBeginExFW beginEx = this.beginExRW.build();
            byte[] array = new byte[beginEx.sizeof()];
            beginEx.buffer().getBytes(beginEx.offset(), array);
            return array;
        }
    }

    public static final class HttpBeginExMatcherBuilder {
        private final DirectBuffer bufferRO = new UnsafeBuffer();
        private final HttpBeginExFW beginExRO = new HttpBeginExFW();
        private final Map<String, Predicate<String>> headers = new LinkedHashMap<String, Predicate<String>>();
        private Integer typeId;

        public HttpBeginExMatcherBuilder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        public HttpBeginExMatcherBuilder header(String name, String value) {
            this.headers.put(name, value::equals);
            return this;
        }

        public HttpBeginExMatcherBuilder headerRegex(String name, String regex) {
            Pattern pattern = Pattern.compile(regex);
            this.headers.put(name, v -> pattern.matcher((CharSequence)v).matches());
            return this;
        }

        public BytesMatcher build() {
            return this.typeId != null ? this::match : buf -> null;
        }

        private HttpBeginExFW match(ByteBuffer byteBuf) throws Exception {
            if (!byteBuf.hasRemaining()) {
                return null;
            }
            this.bufferRO.wrap(byteBuf);
            HttpBeginExFW beginEx = this.beginExRO.tryWrap(this.bufferRO, byteBuf.position(), byteBuf.capacity());
            if (beginEx != null && this.matchTypeId(beginEx) && this.matchHeaders(beginEx)) {
                byteBuf.position(byteBuf.position() + beginEx.sizeof());
                return beginEx;
            }
            throw new Exception(beginEx.toString());
        }

        private boolean matchHeaders(HttpBeginExFW beginEx) {
            MutableBoolean match = new MutableBoolean(true);
            this.headers.forEach((k, v) -> match.value &= beginEx.headers().anyMatch(h -> k.equals(h.name().asString()) && v.test(h.value().asString())));
            return match.value;
        }

        private boolean matchTypeId(HttpBeginExFW beginEx) {
            return this.typeId.intValue() == beginEx.typeId();
        }
    }

    public static final class HttpDataExBuilder {
        private final HttpDataExFW.Builder dataExRW;

        private HttpDataExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.dataExRW = new HttpDataExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public HttpDataExBuilder typeId(int typeId) {
            this.dataExRW.typeId(typeId);
            return this;
        }

        public HttpDataExBuilder promise(String name, String value) {
            this.dataExRW.promiseItem(b -> b.name(name).value(value));
            return this;
        }

        public byte[] build() {
            HttpDataExFW dataEx = this.dataExRW.build();
            byte[] array = new byte[dataEx.sizeof()];
            dataEx.buffer().getBytes(dataEx.offset(), array);
            return array;
        }
    }

    public static final class HttpEndExBuilder {
        private final HttpEndExFW.Builder endExRW;

        private HttpEndExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.endExRW = new HttpEndExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public HttpEndExBuilder typeId(int typeId) {
            this.endExRW.typeId(typeId);
            return this;
        }

        public HttpEndExBuilder trailer(String name, String value) {
            this.endExRW.trailersItem(b -> b.name(name).value(value));
            return this;
        }

        public byte[] build() {
            HttpEndExFW endEx = this.endExRW.build();
            byte[] array = new byte[endEx.sizeof()];
            endEx.buffer().getBytes(endEx.offset(), array);
            return array;
        }
    }

    public static final class HttpChallengeExBuilder {
        private final HttpChallengeExFW.Builder challengeExRW;

        private HttpChallengeExBuilder() {
            UnsafeBuffer writeExBuffer = new UnsafeBuffer(new byte[8192]);
            this.challengeExRW = new HttpChallengeExFW.Builder().wrap((MutableDirectBuffer)writeExBuffer, 0, writeExBuffer.capacity());
        }

        public HttpChallengeExBuilder typeId(int typeId) {
            this.challengeExRW.typeId(typeId);
            return this;
        }

        public HttpChallengeExBuilder header(String name, String value) {
            this.challengeExRW.headersItem(b -> b.name(name).value(value));
            return this;
        }

        public byte[] build() {
            HttpChallengeExFW challengeEx = this.challengeExRW.build();
            byte[] array = new byte[challengeEx.sizeof()];
            challengeEx.buffer().getBytes(challengeEx.offset(), array);
            return array;
        }
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(HttpFunctions.class);
        }

        public String getPrefixName() {
            return "http";
        }
    }
}

