/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.http.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.http.internal.types.ArrayFW;
import org.reaktivity.specification.http.internal.types.Flyweight;
import org.reaktivity.specification.http.internal.types.OctetsFW;
import org.reaktivity.specification.http.internal.types.String8FW;
import org.reaktivity.specification.http.internal.types.control.RoleFW;

public final class RouteFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_NUKLEUS = 8;
    public static final int FIELD_OFFSET_ROLE = 0;
    public static final int FIELD_OFFSET_AUTHORIZATION = 0;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_LOCAL_ADDRESS = 8;
    public static final int FIELD_OFFSET_REMOTE_ADDRESS = 0;
    public static final int FIELD_OFFSET_EXTENSION = 0;
    public static final int TYPE_ID = 1;
    private final String8FW nukleusRO = new String8FW();
    private final RoleFW roleRO = new RoleFW();
    private final String8FW localAddressRO = new String8FW();
    private final String8FW remoteAddressRO = new String8FW();
    private final OctetsFW extensionRO = new OctetsFW();

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public String8FW nukleus() {
        return this.nukleusRO;
    }

    public RoleFW role() {
        return this.roleRO;
    }

    public long authorization() {
        return this.buffer().getLong(this.roleRO.limit() + 0);
    }

    public String8FW localAddress() {
        return this.localAddressRO;
    }

    public String8FW remoteAddress() {
        return this.remoteAddressRO;
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 1;
    }

    @Override
    public RouteFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nukleusRO.wrap(buffer, offset + 8, maxLimit);
        this.roleRO.wrap(buffer, this.nukleusRO.limit() + 0, maxLimit);
        this.localAddressRO.wrap(buffer, this.roleRO.limit() + 8, maxLimit);
        this.remoteAddressRO.wrap(buffer, this.localAddressRO.limit() + 0, maxLimit);
        this.extensionRO.wrap(buffer, this.remoteAddressRO.limit() + 0, maxLimit);
        RouteFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public RouteFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.nukleusRO.tryWrap(buffer, offset + 8, maxLimit)) {
            return null;
        }
        if (null == this.roleRO.tryWrap(buffer, this.nukleusRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.localAddressRO.tryWrap(buffer, this.roleRO.limit() + 8, maxLimit)) {
            return null;
        }
        if (null == this.remoteAddressRO.tryWrap(buffer, this.localAddressRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.extensionRO.tryWrap(buffer, this.remoteAddressRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("ROUTE [correlationId=%d, nukleus=%s, role=%s, authorization=%d, localAddress=%s, remoteAddress=%s, extension=%s]", this.correlationId(), this.nukleusRO.asString(), this.role(), this.authorization(), this.localAddressRO.asString(), this.remoteAddressRO.asString(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<RouteFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_NUKLEUS = 1;
        private static final int INDEX_ROLE = 2;
        private static final int INDEX_AUTHORIZATION = 3;
        public static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_LOCAL_ADDRESS = 4;
        private static final int INDEX_REMOTE_ADDRESS = 5;
        private static final int INDEX_EXTENSION = 6;
        private static final int FIELD_COUNT = 7;
        private final String8FW.Builder nukleusRW = new String8FW.Builder();
        private final RoleFW.Builder roleRW = new RoleFW.Builder();
        private final String8FW.Builder localAddressRW = new String8FW.Builder();
        private final String8FW.Builder remoteAddressRW = new String8FW.Builder();
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new RouteFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            RouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder nukleus() {
            assert (this.lastFieldSet == 0);
            return this.nukleusRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder nukleus(String value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(String8FW value) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set((Flyweight)value);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder nukleus(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder nukleusRW = this.nukleus();
            nukleusRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(nukleusRW.build().limit());
            return this;
        }

        public Builder role(Consumer<RoleFW.Builder> mutator) {
            assert (this.lastFieldSet == 1);
            RoleFW.Builder roleRW = this.roleRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(roleRW);
            this.limit(roleRW.build().limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder role(RoleFW field) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            RouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder authorization(long value) {
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 8;
            RouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder localAddress() {
            if (this.lastFieldSet < 3) {
                this.authorization(0L);
            }
            assert (this.lastFieldSet == 3);
            return this.localAddressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder localAddress(String value) {
            String8FW.Builder localAddressRW = this.localAddress();
            localAddressRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 4;
            this.limit(localAddressRW.build().limit());
            return this;
        }

        public Builder localAddress(String8FW value) {
            String8FW.Builder localAddressRW = this.localAddress();
            localAddressRW.set((Flyweight)value);
            this.lastFieldSet = 4;
            this.limit(localAddressRW.build().limit());
            return this;
        }

        public Builder localAddress(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder localAddressRW = this.localAddress();
            localAddressRW.set(buffer, offset, length);
            this.lastFieldSet = 4;
            this.limit(localAddressRW.build().limit());
            return this;
        }

        private String8FW.Builder remoteAddress() {
            assert (this.lastFieldSet == 4);
            return this.remoteAddressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder remoteAddress(String value) {
            String8FW.Builder remoteAddressRW = this.remoteAddress();
            remoteAddressRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 5;
            this.limit(remoteAddressRW.build().limit());
            return this;
        }

        public Builder remoteAddress(String8FW value) {
            String8FW.Builder remoteAddressRW = this.remoteAddress();
            remoteAddressRW.set((Flyweight)value);
            this.lastFieldSet = 5;
            this.limit(remoteAddressRW.build().limit());
            return this;
        }

        public Builder remoteAddress(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder remoteAddressRW = this.remoteAddress();
            remoteAddressRW.set(buffer, offset, length);
            this.lastFieldSet = 5;
            this.limit(remoteAddressRW.build().limit());
            return this;
        }

        private OctetsFW.Builder extension() {
            assert (this.lastFieldSet == 5);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public RouteFW build() {
            if (this.lastFieldSet < 6) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 6);
            this.lastFieldSet = -1;
            return (RouteFW)super.build();
        }
    }
}

