/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.http.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.http.internal.types.Flyweight;
import org.reaktivity.specification.http.internal.types.ListFW;

public final class List0FW
extends ListFW {
    private static final DirectBuffer FIELDS_EMPTY_VALUE = new UnsafeBuffer(0L, 0);
    private static final int LENGTH_SIZE = 0;
    private static final int FIELD_COUNT_SIZE = 0;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 0;
    private static final int LENGTH_VALUE = 0;
    private static final int FIELD_COUNT_VALUE = 0;

    @Override
    public int limit() {
        return this.offset() + 0 + this.length();
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public int fieldCount() {
        return 0;
    }

    @Override
    public DirectBuffer fields() {
        return FIELDS_EMPTY_VALUE;
    }

    @Override
    public List0FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public List0FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        List0FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return String.format("list0<%d, %d>", this.length(), this.fieldCount());
    }

    public static final class Builder
    extends ListFW.Builder<List0FW> {
        private int fieldCount;

        public Builder() {
            super(new List0FW());
        }

        public Builder field(Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.limit(), this.maxLimit());
            ++this.fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            return this;
        }

        public Builder fields(int fieldCount, Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.limit(), this.maxLimit());
            this.fieldCount += fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            return this;
        }

        public Builder fields(int fieldCount, DirectBuffer buffer, int index, int length) {
            this.fieldCount += fieldCount;
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), buffer, index, length);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.fieldCount = 0;
            Flyweight.checkLimit(this.limit(), maxLimit);
            return this;
        }

        @Override
        public List0FW build() {
            return (List0FW)super.build();
        }
    }
}

