/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.http.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.http.internal.types.ArrayFW;
import org.reaktivity.specification.http.internal.types.Flyweight;
import org.reaktivity.specification.http.internal.types.OctetsFW;

public final class FlushFW
extends Flyweight {
    public static final int FIELD_OFFSET_ROUTE_ID = 0;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int FIELD_OFFSET_STREAM_ID = 8;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 16;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE_ID = 24;
    private static final int FIELD_SIZE_TRACE_ID = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 32;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_BUDGET_ID = 40;
    private static final int FIELD_SIZE_BUDGET_ID = 8;
    public static final int FIELD_OFFSET_RESERVED = 48;
    private static final int FIELD_SIZE_RESERVED = 4;
    public static final int FIELD_OFFSET_EXTENSION = 52;
    public static final int TYPE_ID = 5;
    private final OctetsFW extensionRO = new OctetsFW();

    public long routeId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long streamId() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long traceId() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 32);
    }

    public long budgetId() {
        return this.buffer().getLong(this.offset() + 40);
    }

    public int reserved() {
        return this.buffer().getInt(this.offset() + 48);
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 5;
    }

    @Override
    public FlushFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.extensionRO.wrap(buffer, offset + 52, maxLimit);
        FlushFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public FlushFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.extensionRO.tryWrap(buffer, offset + 52, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("FLUSH [routeId=%d, streamId=%d, timestamp=%d, traceId=%d, authorization=%d, budgetId=%d, reserved=%d, extension=%s]", this.routeId(), this.streamId(), this.timestamp(), this.traceId(), this.authorization(), this.budgetId(), this.reserved(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<FlushFW> {
        private static final int INDEX_ROUTE_ID = 0;
        private static final int INDEX_STREAM_ID = 1;
        private static final int INDEX_TIMESTAMP = 2;
        public static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE_ID = 3;
        public static final long DEFAULT_TRACE_ID = 0L;
        private static final int INDEX_AUTHORIZATION = 4;
        public static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_BUDGET_ID = 5;
        private static final int INDEX_RESERVED = 6;
        public static final int DEFAULT_RESERVED = 0;
        private static final int INDEX_EXTENSION = 7;
        private static final int FIELD_COUNT = 8;
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new FlushFW());
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            FlushFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder streamId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            FlushFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            FlushFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder traceId(long value) {
            if (this.lastFieldSet < 2) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 8;
            FlushFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            if (this.lastFieldSet < 3) {
                this.traceId(0L);
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 8;
            FlushFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        public Builder budgetId(long value) {
            if (this.lastFieldSet < 4) {
                this.authorization(0L);
            }
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + 8;
            FlushFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 5;
            this.limit(newLimit);
            return this;
        }

        public Builder reserved(int value) {
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + 4;
            FlushFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 6;
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder extension() {
            if (this.lastFieldSet < 6) {
                this.reserved(0);
            }
            assert (this.lastFieldSet == 6);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 7;
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 7;
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 7;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<FlushFW>, ? extends Flyweight.Builder<FlushFW>, FlushFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public FlushFW build() {
            if (this.lastFieldSet < 7) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 7);
            this.lastFieldSet = -1;
            return (FlushFW)super.build();
        }
    }
}

