/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.http.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.http.internal.types.Array32FW;
import org.reaktivity.specification.http.internal.types.ArrayFW;
import org.reaktivity.specification.http.internal.types.Flyweight;
import org.reaktivity.specification.http.internal.types.HttpHeaderFW;

public final class HttpDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_PROMISE = 4;
    private final Array32FW<HttpHeaderFW> promiseRO = new Array32FW<HttpHeaderFW>(new HttpHeaderFW());

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public Array32FW<HttpHeaderFW> promise() {
        return this.promiseRO;
    }

    @Override
    public HttpDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.promiseRO.wrap(buffer, offset + 4, maxLimit);
        HttpDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public HttpDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.promiseRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.promiseRO.limit();
    }

    public String toString() {
        return String.format("HTTP_DATA_EX [typeId=%d, promise=%s]", this.typeId(), this.promise());
    }

    public static final class Builder
    extends Flyweight.Builder<HttpDataExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_PROMISE = 1;
        private static final int FIELD_COUNT = 2;
        private final Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> promiseRW = new Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new HttpDataExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            HttpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder promise(Consumer<Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
            assert (this.lastFieldSet == 0);
            Flyweight.Builder promiseRW = this.promiseRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>)promiseRW);
            this.limit(((Array32FW)((Array32FW.Builder)promiseRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder promise(Array32FW<HttpHeaderFW> field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            HttpDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder promiseItem(Consumer<HttpHeaderFW.Builder> mutator) {
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.promiseRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.promiseRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.promiseRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<HttpDataExFW>, ? extends Flyweight.Builder<HttpDataExFW>, HttpDataExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public HttpDataExFW build() {
            if (this.lastFieldSet < 1) {
                this.promise((Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (HttpDataExFW)super.build();
        }
    }
}

