/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.kafka.internal.types.BoundedOctetsFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;

public final class BoundedOctets32FW
extends BoundedOctetsFW {
    private static final int LENGTH_SIZE = 4;
    private static final int LENGTH_OFFSET = 0;
    private static final int VALUE_OFFSET = 4;
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);
    private final ByteOrder byteOrder;

    public BoundedOctets32FW() {
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public BoundedOctets32FW(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public <T> T get(Flyweight.Visitor<T> visitor) {
        return visitor.visit(this.buffer(), this.offset() + 4, this.limit());
    }

    @Override
    public DirectBuffer value() {
        return this.valueRO;
    }

    @Override
    public int length() {
        return this.buffer().getInt(this.offset() + 0, this.byteOrder);
    }

    @Override
    public BoundedOctets32FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        this.valueRO.wrap(buffer, offset + 4, this.length());
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public BoundedOctets32FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.valueRO.wrap(buffer, offset + 4, this.length());
        BoundedOctets32FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + this.length();
    }

    public String toString() {
        return String.format("boundedOctets32[%d]", this.length());
    }

    public static final class Builder
    extends BoundedOctetsFW.Builder<BoundedOctets32FW> {
        private final ByteOrder byteOrder;

        public Builder() {
            super(new BoundedOctets32FW());
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(ByteOrder byteOrder) {
            super(new BoundedOctets32FW(byteOrder));
            this.byteOrder = byteOrder;
        }

        public Builder set(BoundedOctetsFW value) {
            int newLimit = this.offset() + 4 + value.length();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.offset() + 0, value.length(), this.byteOrder);
            this.buffer().putBytes(this.offset() + 4, value.buffer(), value.offset() + 4, value.length());
            this.limit(newLimit);
            return this;
        }

        public Builder set(DirectBuffer value, int offset, int length) {
            int newLimit = this.offset() + 4 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.offset() + 0, length, this.byteOrder);
            this.buffer().putBytes(this.offset() + 4, value, offset, length);
            this.limit(newLimit);
            return this;
        }

        public Builder set(byte[] value) {
            int newLimit = this.offset() + 4 + value.length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.offset() + 0, value.length, this.byteOrder);
            this.buffer().putBytes(this.offset() + 4, value);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 4, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

