/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.OctetsFW;
import org.reaktivity.specification.kafka.internal.types.Varint32FW;

public final class KafkaKeyFW
extends Flyweight {
    public static final int FIELD_OFFSET_LENGTH = 0;
    public static final int FIELD_OFFSET_VALUE = 0;
    private final Varint32FW lengthRO = new Varint32FW();
    private OctetsFW valueRO = new OctetsFW();

    public int length() {
        return this.lengthRO.value();
    }

    public OctetsFW value() {
        return this.length() == -1 ? null : this.valueRO;
    }

    @Override
    public KafkaKeyFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.lengthRO.wrap(buffer, offset + 0, maxLimit);
        this.valueRO.wrap(buffer, this.lengthRO.limit() + 0, this.lengthRO.limit() + 0 + (this.length() == -1 ? 0 : this.length()));
        KafkaKeyFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaKeyFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.lengthRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        int limit = this.lengthRO.limit() + 0 + (this.length() == -1 ? 0 : this.length());
        if (limit > maxLimit || null == this.valueRO.tryWrap(buffer, this.lengthRO.limit() + 0, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_KEY [length=%s, value=%s]", this.length(), this.value());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaKeyFW> {
        private static final int INDEX_LENGTH = 0;
        public static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_VALUE = 1;
        private static final int FIELD_COUNT = 2;
        private int dynamicValueLength;
        private final Varint32FW.Builder lengthRW = new Varint32FW.Builder();
        private final OctetsFW.Builder valueRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaKeyFW());
        }

        public Builder length(int value) {
            assert (this.lastFieldSet == -1);
            Varint32FW.Builder lengthRW = this.lengthRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            lengthRW.set(value);
            this.dynamicValueLength = value;
            this.limit(lengthRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder length(Varint32FW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        private OctetsFW.Builder value() {
            if (this.lastFieldSet < 0) {
                this.length(0);
            }
            assert (this.lastFieldSet == 0);
            return this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder value(OctetsFW value) {
            int newLimit;
            int size$;
            OctetsFW.Builder valueRW = this.value();
            if (value == null) {
                size$ = -1;
                newLimit = this.limit();
            } else {
                valueRW.set(value);
                newLimit = ((OctetsFW)valueRW.build()).limit();
                size$ = newLimit - this.limit();
            }
            if (size$ != this.dynamicValueLength) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"value\", does not match value %d set in %s", size$, this.dynamicValueLength, "length"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder value(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder valueRW = this.value();
            mutator.accept(valueRW);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueLength) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"value\", does not match value %d set in %s", size$, this.dynamicValueLength, "length"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder value(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder valueRW = this.value();
            valueRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueLength) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"value\", does not match value %d set in %s", size$, this.dynamicValueLength, "length"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaKeyFW>, ? extends Flyweight.Builder<KafkaKeyFW>, KafkaKeyFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaKeyFW build() {
            if (this.lastFieldSet < 1) {
                this.length(-1);
                this.lastFieldSet = 1;
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (KafkaKeyFW)super.build();
        }
    }
}

