/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFetchFlushExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMergedFlushExFW;

public final class KafkaFlushExFW
extends Flyweight {
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 4;
    public static final int KIND_MERGED = 255;
    public static final int FIELD_OFFSET_MERGED = 5;
    public static final int KIND_FETCH = 1;
    public static final int FIELD_OFFSET_FETCH = 5;
    private final KafkaMergedFlushExFW mergedRO = new KafkaMergedFlushExFW();
    private final KafkaFetchFlushExFW fetchRO = new KafkaFetchFlushExFW();

    public int kind() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public KafkaMergedFlushExFW merged() {
        return this.mergedRO;
    }

    public KafkaFetchFlushExFW fetch() {
        return this.fetchRO;
    }

    @Override
    public KafkaFlushExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 255: {
                if (this.mergedRO.tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 1: {
                if (this.fetchRO.tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaFlushExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 255: {
                this.mergedRO.wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 1: {
                this.fetchRO.wrap(buffer, offset + 5, maxLimit);
                break;
            }
        }
        KafkaFlushExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 255: {
                return this.merged().limit();
            }
            case 1: {
                return this.fetch().limit();
            }
        }
        return this.offset() + 0 + 4;
    }

    public String toString() {
        switch (this.kind()) {
            case 255: {
                return String.format("KAFKA_FLUSH_EX [typeId=%d, merged=%s]", this.typeId(), this.merged());
            }
            case 1: {
                return String.format("KAFKA_FLUSH_EX [typeId=%d, fetch=%s]", this.typeId(), this.fetch());
            }
        }
        return String.format("KAFKA_FLUSH_EX [typeId=%d]", this.typeId());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaFlushExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private final KafkaMergedFlushExFW.Builder mergedRW = new KafkaMergedFlushExFW.Builder();
        private final KafkaFetchFlushExFW.Builder fetchRW = new KafkaFetchFlushExFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaFlushExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            KafkaFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder kind(int value) {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            this.buffer().putByte(this.offset() + 4, (byte)(value & 0xFF));
            return this;
        }

        private KafkaMergedFlushExFW.Builder merged() {
            int newLimit = this.maxLimit();
            KafkaFlushExFW.checkLimit(newLimit, this.maxLimit());
            return this.mergedRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder merged(Consumer<KafkaMergedFlushExFW.Builder> mutator) {
            this.kind(255);
            KafkaMergedFlushExFW.Builder merged = this.merged();
            mutator.accept(merged);
            this.limit(merged.build().limit());
            return this;
        }

        private KafkaFetchFlushExFW.Builder fetch() {
            int newLimit = this.maxLimit();
            KafkaFlushExFW.checkLimit(newLimit, this.maxLimit());
            return this.fetchRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder fetch(Consumer<KafkaFetchFlushExFW.Builder> mutator) {
            this.kind(1);
            KafkaFetchFlushExFW.Builder fetch = this.fetch();
            mutator.accept(fetch);
            this.limit(fetch.build().limit());
            return this;
        }

        @Override
        public KafkaFlushExFW build() {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            return (KafkaFlushExFW)super.build();
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            return this;
        }
    }
}

