/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaAge;

public final class KafkaAgeFW
extends Flyweight {
    private static final int FIELD_OFFSET_VALUE = 0;
    private static final int FIELD_SIZE_VALUE = 1;

    @Override
    public int limit() {
        return this.offset() + 1;
    }

    public KafkaAge get() {
        return KafkaAge.valueOf(this.buffer().getByte(this.offset() + 0));
    }

    @Override
    public KafkaAgeFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaAgeFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        KafkaAgeFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : this.get().toString();
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaAgeFW> {
        private boolean valueSet;

        public Builder() {
            super(new KafkaAgeFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }

        public Builder set(KafkaAgeFW value) {
            int newLimit = this.offset() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(KafkaAge value) {
            MutableDirectBuffer buffer = this.buffer();
            int offset = this.offset();
            int newLimit = offset + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            buffer.putByte(offset, (byte)value.ordinal());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public KafkaAgeFW build() {
            if (!this.valueSet) {
                throw new IllegalStateException("KafkaAge not set");
            }
            return (KafkaAgeFW)super.build();
        }
    }
}

