/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaType;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaTypeFW;

public final class KafkaDeltaFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE = 0;
    public static final int FIELD_OFFSET_ANCESTOR_OFFSET = 0;
    private static final int FIELD_SIZE_ANCESTOR_OFFSET = 8;
    private KafkaDeltaTypeFW typeRO = new KafkaDeltaTypeFW();

    public KafkaDeltaTypeFW type() {
        return this.typeRO;
    }

    public long ancestorOffset() {
        return this.buffer().getLong(this.typeRO.limit() + 0);
    }

    @Override
    public KafkaDeltaFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.typeRO.wrap(buffer, offset + 0, maxLimit);
        KafkaDeltaFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaDeltaFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.typeRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.typeRO.limit() + 0 + 8;
    }

    public String toString() {
        return String.format("KAFKA_DELTA [type=%s, ancestorOffset=%d]", this.type(), this.ancestorOffset());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaDeltaFW> {
        private static final int INDEX_TYPE = 0;
        public static final KafkaDeltaType DEFAULT_TYPE = KafkaDeltaType.NONE;
        private static final int INDEX_ANCESTOR_OFFSET = 1;
        public static final long DEFAULT_ANCESTOR_OFFSET = -1L;
        private static final int FIELD_COUNT = 2;
        private final KafkaDeltaTypeFW.Builder typeRW = new KafkaDeltaTypeFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaDeltaFW());
        }

        public Builder type(Consumer<KafkaDeltaTypeFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            KafkaDeltaTypeFW.Builder typeRW = this.typeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(typeRW);
            this.limit(typeRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder type(KafkaDeltaTypeFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder ancestorOffset(long value) {
            if (this.lastFieldSet < 0) {
                this.type((KafkaDeltaTypeFW.Builder b) -> b.set(DEFAULT_TYPE));
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaDeltaFW>, ? extends Flyweight.Builder<KafkaDeltaFW>, KafkaDeltaFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaDeltaFW build() {
            if (this.lastFieldSet < 1) {
                this.ancestorOffset(-1L);
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (KafkaDeltaFW)super.build();
        }
    }
}

