/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.control;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;

public final class ResponseFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    @Override
    public ResponseFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ResponseFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ResponseFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 0 + 8;
    }

    public String toString() {
        return String.format("RESPONSE [correlationId=%d]", this.correlationId());
    }

    public static final class Builder
    extends Flyweight.Builder<ResponseFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int FIELD_COUNT = 1;
        private int lastFieldSet = -1;

        public Builder() {
            super(new ResponseFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            ResponseFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<ResponseFW>, ? extends Flyweight.Builder<ResponseFW>, ResponseFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ResponseFW build() {
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (ResponseFW)super.build();
        }
    }
}

