/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaDescribeDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFetchDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMergedDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMetaDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaProduceDataExFW;

public final class KafkaDataExFW
extends Flyweight {
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 4;
    public static final int KIND_MERGED = 255;
    public static final int FIELD_OFFSET_MERGED = 5;
    public static final int KIND_META = 3;
    public static final int FIELD_OFFSET_META = 5;
    public static final int KIND_DESCRIBE = 32;
    public static final int FIELD_OFFSET_DESCRIBE = 5;
    public static final int KIND_FETCH = 1;
    public static final int FIELD_OFFSET_FETCH = 5;
    public static final int KIND_PRODUCE = 0;
    public static final int FIELD_OFFSET_PRODUCE = 5;
    private final KafkaMergedDataExFW mergedRO = new KafkaMergedDataExFW();
    private final KafkaMetaDataExFW metaRO = new KafkaMetaDataExFW();
    private final KafkaDescribeDataExFW describeRO = new KafkaDescribeDataExFW();
    private final KafkaFetchDataExFW fetchRO = new KafkaFetchDataExFW();
    private final KafkaProduceDataExFW produceRO = new KafkaProduceDataExFW();

    public int kind() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public KafkaMergedDataExFW merged() {
        return this.mergedRO;
    }

    public KafkaMetaDataExFW meta() {
        return this.metaRO;
    }

    public KafkaDescribeDataExFW describe() {
        return this.describeRO;
    }

    public KafkaFetchDataExFW fetch() {
        return this.fetchRO;
    }

    public KafkaProduceDataExFW produce() {
        return this.produceRO;
    }

    @Override
    public KafkaDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 255: {
                if (this.mergedRO.tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 3: {
                if (this.metaRO.tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 32: {
                if (this.describeRO.tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 1: {
                if (this.fetchRO.tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 0: {
                if (this.produceRO.tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 255: {
                this.mergedRO.wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 3: {
                this.metaRO.wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 32: {
                this.describeRO.wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 1: {
                this.fetchRO.wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 0: {
                this.produceRO.wrap(buffer, offset + 5, maxLimit);
                break;
            }
        }
        KafkaDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 255: {
                return this.merged().limit();
            }
            case 3: {
                return this.meta().limit();
            }
            case 32: {
                return this.describe().limit();
            }
            case 1: {
                return this.fetch().limit();
            }
            case 0: {
                return this.produce().limit();
            }
        }
        return this.offset() + 0 + 4;
    }

    public String toString() {
        switch (this.kind()) {
            case 255: {
                return String.format("KAFKA_DATA_EX [typeId=%d, merged=%s]", this.typeId(), this.merged());
            }
            case 3: {
                return String.format("KAFKA_DATA_EX [typeId=%d, meta=%s]", this.typeId(), this.meta());
            }
            case 32: {
                return String.format("KAFKA_DATA_EX [typeId=%d, describe=%s]", this.typeId(), this.describe());
            }
            case 1: {
                return String.format("KAFKA_DATA_EX [typeId=%d, fetch=%s]", this.typeId(), this.fetch());
            }
            case 0: {
                return String.format("KAFKA_DATA_EX [typeId=%d, produce=%s]", this.typeId(), this.produce());
            }
        }
        return String.format("KAFKA_DATA_EX [typeId=%d]", this.typeId());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaDataExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private final KafkaMergedDataExFW.Builder mergedRW = new KafkaMergedDataExFW.Builder();
        private final KafkaMetaDataExFW.Builder metaRW = new KafkaMetaDataExFW.Builder();
        private final KafkaDescribeDataExFW.Builder describeRW = new KafkaDescribeDataExFW.Builder();
        private final KafkaFetchDataExFW.Builder fetchRW = new KafkaFetchDataExFW.Builder();
        private final KafkaProduceDataExFW.Builder produceRW = new KafkaProduceDataExFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaDataExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder kind(int value) {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            this.buffer().putByte(this.offset() + 4, (byte)(value & 0xFF));
            return this;
        }

        private KafkaMergedDataExFW.Builder merged() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            return this.mergedRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder merged(Consumer<KafkaMergedDataExFW.Builder> mutator) {
            this.kind(255);
            KafkaMergedDataExFW.Builder merged = this.merged();
            mutator.accept(merged);
            this.limit(merged.build().limit());
            return this;
        }

        private KafkaMetaDataExFW.Builder meta() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            return this.metaRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder meta(Consumer<KafkaMetaDataExFW.Builder> mutator) {
            this.kind(3);
            KafkaMetaDataExFW.Builder meta = this.meta();
            mutator.accept(meta);
            this.limit(meta.build().limit());
            return this;
        }

        private KafkaDescribeDataExFW.Builder describe() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            return this.describeRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder describe(Consumer<KafkaDescribeDataExFW.Builder> mutator) {
            this.kind(32);
            KafkaDescribeDataExFW.Builder describe = this.describe();
            mutator.accept(describe);
            this.limit(describe.build().limit());
            return this;
        }

        private KafkaFetchDataExFW.Builder fetch() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            return this.fetchRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder fetch(Consumer<KafkaFetchDataExFW.Builder> mutator) {
            this.kind(1);
            KafkaFetchDataExFW.Builder fetch = this.fetch();
            mutator.accept(fetch);
            this.limit(fetch.build().limit());
            return this;
        }

        private KafkaProduceDataExFW.Builder produce() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            return this.produceRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder produce(Consumer<KafkaProduceDataExFW.Builder> mutator) {
            this.kind(0);
            KafkaProduceDataExFW.Builder produce = this.produce();
            mutator.accept(produce);
            this.limit(produce.build().limit());
            return this;
        }

        @Override
        public KafkaDataExFW build() {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            return (KafkaDataExFW)super.build();
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            return this;
        }
    }
}

