/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetFW;

public final class KafkaFetchFlushExFW
extends Flyweight {
    public static final int FIELD_OFFSET_PARTITION = 0;
    private final KafkaOffsetFW partitionRO = new KafkaOffsetFW();

    public KafkaOffsetFW partition() {
        return this.partitionRO;
    }

    @Override
    public KafkaFetchFlushExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.partitionRO.wrap(buffer, offset + 0, maxLimit);
        KafkaFetchFlushExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaFetchFlushExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.partitionRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.partitionRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_FETCH_FLUSH_EX [partition=%s]", this.partition());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaFetchFlushExFW> {
        private static final int INDEX_PARTITION = 0;
        private static final int FIELD_COUNT = 1;
        private final KafkaOffsetFW.Builder partitionRW = new KafkaOffsetFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaFetchFlushExFW());
        }

        public Builder partition(Consumer<KafkaOffsetFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            KafkaOffsetFW.Builder partitionRW = this.partitionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(partitionRW);
            this.limit(partitionRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder partition(KafkaOffsetFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaFetchFlushExFW>, ? extends Flyweight.Builder<KafkaFetchFlushExFW>, KafkaFetchFlushExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaFetchFlushExFW build() {
            if (this.lastFieldSet < 0) {
                this.partition((KafkaOffsetFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (KafkaFetchFlushExFW)super.build();
        }
    }
}

