/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaCapabilities;
import org.reaktivity.specification.kafka.internal.types.KafkaCapabilitiesFW;
import org.reaktivity.specification.kafka.internal.types.KafkaFilterFW;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetFW;

public final class KafkaMergedFlushExFW
extends Flyweight {
    public static final int FIELD_OFFSET_PROGRESS = 0;
    public static final int FIELD_OFFSET_CAPABILITIES = 0;
    public static final int FIELD_OFFSET_FILTERS = 0;
    private final Array32FW<KafkaOffsetFW> progressRO = new Array32FW<KafkaOffsetFW>(new KafkaOffsetFW());
    private KafkaCapabilitiesFW capabilitiesRO = new KafkaCapabilitiesFW();
    private final Array32FW<KafkaFilterFW> filtersRO = new Array32FW<KafkaFilterFW>(new KafkaFilterFW());

    public Array32FW<KafkaOffsetFW> progress() {
        return this.progressRO;
    }

    public KafkaCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    public Array32FW<KafkaFilterFW> filters() {
        return this.filtersRO;
    }

    @Override
    public KafkaMergedFlushExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.progressRO.wrap(buffer, offset + 0, maxLimit);
        this.capabilitiesRO.wrap(buffer, this.progressRO.limit() + 0, maxLimit);
        this.filtersRO.wrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit);
        KafkaMergedFlushExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaMergedFlushExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.progressRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, this.progressRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.filtersRO.tryWrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.filtersRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_MERGED_FLUSH_EX [progress=%s, capabilities=%s, filters=%s]", this.progress(), this.capabilities(), this.filters());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaMergedFlushExFW> {
        private static final int INDEX_PROGRESS = 0;
        private static final int INDEX_CAPABILITIES = 1;
        public static final KafkaCapabilities DEFAULT_CAPABILITIES = KafkaCapabilities.PRODUCE_AND_FETCH;
        private static final int INDEX_FILTERS = 2;
        private static final int FIELD_COUNT = 3;
        private final Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> progressRW = new Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW>(new KafkaOffsetFW.Builder(), new KafkaOffsetFW());
        private final KafkaCapabilitiesFW.Builder capabilitiesRW = new KafkaCapabilitiesFW.Builder();
        private final Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> filtersRW = new Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>(new KafkaFilterFW.Builder(), new KafkaFilterFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaMergedFlushExFW());
        }

        public Builder progress(Consumer<Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW>> mutator) {
            assert (this.lastFieldSet == -1);
            Flyweight.Builder progressRW = this.progressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW>)progressRW);
            this.limit(((Array32FW)((Array32FW.Builder)progressRW).build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder progress(Array32FW<KafkaOffsetFW> field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            KafkaMergedFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder progressItem(Consumer<KafkaOffsetFW.Builder> mutator) {
            assert (this.lastFieldSet >= -1);
            if (this.lastFieldSet < 0) {
                this.progressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.progressRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.progressRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder capabilities(Consumer<KafkaCapabilitiesFW.Builder> mutator) {
            if (this.lastFieldSet < 0) {
                this.progress((Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> b) -> {});
            }
            assert (this.lastFieldSet == 0);
            KafkaCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder capabilities(KafkaCapabilitiesFW field) {
            if (this.lastFieldSet < 0) {
                this.progress((Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> b) -> {});
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            KafkaMergedFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder filters(Consumer<Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>> mutator) {
            if (this.lastFieldSet < 1) {
                this.capabilities((KafkaCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 1);
            Flyweight.Builder filtersRW = this.filtersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>)filtersRW);
            this.limit(((Array32FW)((Array32FW.Builder)filtersRW).build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder filters(Array32FW<KafkaFilterFW> field) {
            if (this.lastFieldSet < 1) {
                this.capabilities((KafkaCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            KafkaMergedFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder filtersItem(Consumer<KafkaFilterFW.Builder> mutator) {
            if (this.lastFieldSet < 1) {
                this.capabilities((KafkaCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet >= 1);
            if (this.lastFieldSet < 2) {
                this.filtersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.filtersRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.filtersRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaMergedFlushExFW>, ? extends Flyweight.Builder<KafkaMergedFlushExFW>, KafkaMergedFlushExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaMergedFlushExFW build() {
            if (this.lastFieldSet < 2) {
                this.filters((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> b) -> {});
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (KafkaMergedFlushExFW)super.build();
        }
    }
}

