/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaAgeFW;
import org.reaktivity.specification.kafka.internal.types.KafkaHeaderFW;
import org.reaktivity.specification.kafka.internal.types.KafkaKeyFW;

public final class KafkaConditionFW
extends Flyweight {
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 0;
    public static final int KIND_KEY = 0;
    public static final int FIELD_OFFSET_KEY = 1;
    public static final int KIND_HEADER = 1;
    public static final int FIELD_OFFSET_HEADER = 1;
    public static final int KIND_AGE = 2;
    public static final int FIELD_OFFSET_AGE = 1;
    private final KafkaKeyFW keyRO = new KafkaKeyFW();
    private final KafkaHeaderFW headerRO = new KafkaHeaderFW();
    private final KafkaAgeFW ageRO = new KafkaAgeFW();

    public int kind() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public KafkaKeyFW key() {
        return this.keyRO;
    }

    public KafkaHeaderFW header() {
        return this.headerRO;
    }

    public KafkaAgeFW age() {
        return this.ageRO;
    }

    @Override
    public KafkaConditionFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 0: {
                if (this.keyRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 1: {
                if (this.headerRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 2: {
                if (this.ageRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaConditionFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 0: {
                this.keyRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 1: {
                this.headerRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 2: {
                this.ageRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
        }
        KafkaConditionFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 0: {
                return this.key().limit();
            }
            case 1: {
                return this.header().limit();
            }
            case 2: {
                return this.age().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case 0: {
                return String.format("KAFKA_CONDITION [key=%s]", this.key());
            }
            case 1: {
                return String.format("KAFKA_CONDITION [header=%s]", this.header());
            }
            case 2: {
                return String.format("KAFKA_CONDITION [age=%s]", this.age());
            }
        }
        return String.format("KAFKA_CONDITION [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaConditionFW> {
        private final KafkaKeyFW.Builder keyRW = new KafkaKeyFW.Builder();
        private final KafkaHeaderFW.Builder headerRW = new KafkaHeaderFW.Builder();
        private final KafkaAgeFW.Builder ageRW = new KafkaAgeFW.Builder();

        public Builder() {
            super(new KafkaConditionFW());
        }

        public Builder kind(int value) {
            this.buffer().putByte(this.offset() + 0, (byte)(value & 0xFF));
            return this;
        }

        private KafkaKeyFW.Builder key() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.keyRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder key(Consumer<KafkaKeyFW.Builder> mutator) {
            this.kind(0);
            KafkaKeyFW.Builder key = this.key();
            mutator.accept(key);
            this.limit(key.build().limit());
            return this;
        }

        private KafkaHeaderFW.Builder header() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.headerRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder header(Consumer<KafkaHeaderFW.Builder> mutator) {
            this.kind(1);
            KafkaHeaderFW.Builder header = this.header();
            mutator.accept(header);
            this.limit(header.build().limit());
            return this;
        }

        private KafkaAgeFW.Builder age() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.ageRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder age(Consumer<KafkaAgeFW.Builder> mutator) {
            this.kind(2);
            KafkaAgeFW.Builder age = this.age();
            mutator.accept(age);
            this.limit(age.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

