/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.OctetsFW;
import org.reaktivity.specification.kafka.internal.types.Varint32FW;

public final class KafkaHeaderFW
extends Flyweight {
    public static final int FIELD_OFFSET_NAME_LEN = 0;
    public static final int FIELD_OFFSET_NAME = 0;
    public static final int FIELD_OFFSET_VALUE_LEN = 0;
    public static final int FIELD_OFFSET_VALUE = 0;
    private final Varint32FW nameLenRO = new Varint32FW();
    private final OctetsFW nameRO = new OctetsFW();
    private final Varint32FW valueLenRO = new Varint32FW();
    private OctetsFW valueRO = new OctetsFW();

    public int nameLen() {
        return this.nameLenRO.value();
    }

    public OctetsFW name() {
        return this.nameRO;
    }

    public int valueLen() {
        return this.valueLenRO.value();
    }

    public OctetsFW value() {
        return this.valueLen() == -1 ? null : this.valueRO;
    }

    @Override
    public KafkaHeaderFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nameLenRO.wrap(buffer, offset + 0, maxLimit);
        this.nameRO.wrap(buffer, this.nameLenRO.limit() + 0, this.nameLenRO.limit() + 0 + this.nameLen());
        this.valueLenRO.wrap(buffer, this.nameRO.limit() + 0, maxLimit);
        this.valueRO.wrap(buffer, this.valueLenRO.limit() + 0, this.valueLenRO.limit() + 0 + (this.valueLen() == -1 ? 0 : this.valueLen()));
        KafkaHeaderFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaHeaderFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.nameLenRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        int limit = this.nameLenRO.limit() + 0 + this.nameLen();
        if (limit > maxLimit || null == this.nameRO.tryWrap(buffer, this.nameLenRO.limit() + 0, limit)) {
            return null;
        }
        if (null == this.valueLenRO.tryWrap(buffer, this.nameRO.limit() + 0, maxLimit)) {
            return null;
        }
        limit = this.valueLenRO.limit() + 0 + (this.valueLen() == -1 ? 0 : this.valueLen());
        if (limit > maxLimit || null == this.valueRO.tryWrap(buffer, this.valueLenRO.limit() + 0, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_HEADER [nameLen=%s, name=%s, valueLen=%s, value=%s]", this.nameLen(), this.name(), this.valueLen(), this.value());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaHeaderFW> {
        private static final int INDEX_NAME_LEN = 0;
        public static final int DEFAULT_NAME_LEN = 0;
        private static final int INDEX_NAME = 1;
        private static final int INDEX_VALUE_LEN = 2;
        public static final int DEFAULT_VALUE_LEN = 0;
        private static final int INDEX_VALUE = 3;
        private static final int FIELD_COUNT = 4;
        private int dynamicValueNameLen;
        private final Varint32FW.Builder nameLenRW = new Varint32FW.Builder();
        private final OctetsFW.Builder nameRW = new OctetsFW.Builder();
        private int dynamicValueValueLen;
        private final Varint32FW.Builder valueLenRW = new Varint32FW.Builder();
        private final OctetsFW.Builder valueRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaHeaderFW());
        }

        public Builder nameLen(int value) {
            assert (this.lastFieldSet == -1);
            Varint32FW.Builder nameLenRW = this.nameLenRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            nameLenRW.set(value);
            this.dynamicValueNameLen = value;
            this.limit(nameLenRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder nameLen(Varint32FW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        private OctetsFW.Builder name() {
            if (this.lastFieldSet < 0) {
                this.nameLen(0);
            }
            assert (this.lastFieldSet == 0);
            return this.nameRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder name(OctetsFW value) {
            OctetsFW.Builder nameRW = this.name();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"name\" that does not default to null");
            }
            nameRW.set(value);
            int newLimit = ((OctetsFW)nameRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueNameLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"name\", does not match value %d set in %s", size$, this.dynamicValueNameLen, "nameLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder name(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder nameRW = this.name();
            mutator.accept(nameRW);
            int newLimit = ((OctetsFW)nameRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueNameLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"name\", does not match value %d set in %s", size$, this.dynamicValueNameLen, "nameLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder name(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder nameRW = this.name();
            nameRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)nameRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueNameLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"name\", does not match value %d set in %s", size$, this.dynamicValueNameLen, "nameLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder valueLen(int value) {
            assert (this.lastFieldSet == 1);
            Varint32FW.Builder valueLenRW = this.valueLenRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            valueLenRW.set(value);
            this.dynamicValueValueLen = value;
            this.limit(valueLenRW.build().limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder valueLen(Varint32FW field) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        private OctetsFW.Builder value() {
            if (this.lastFieldSet < 2) {
                this.valueLen(0);
            }
            assert (this.lastFieldSet == 2);
            return this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder value(OctetsFW value) {
            int newLimit;
            int size$;
            OctetsFW.Builder valueRW = this.value();
            if (value == null) {
                size$ = -1;
                newLimit = this.limit();
            } else {
                valueRW.set(value);
                newLimit = ((OctetsFW)valueRW.build()).limit();
                size$ = newLimit - this.limit();
            }
            if (size$ != this.dynamicValueValueLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"value\", does not match value %d set in %s", size$, this.dynamicValueValueLen, "valueLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder value(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder valueRW = this.value();
            mutator.accept(valueRW);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueValueLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"value\", does not match value %d set in %s", size$, this.dynamicValueValueLen, "valueLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder value(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder valueRW = this.value();
            valueRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueValueLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"value\", does not match value %d set in %s", size$, this.dynamicValueValueLen, "valueLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaHeaderFW>, ? extends Flyweight.Builder<KafkaHeaderFW>, KafkaHeaderFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaHeaderFW build() {
            if (this.lastFieldSet < 3) {
                this.valueLen(-1);
                this.lastFieldSet = 3;
            }
            assert (this.lastFieldSet == 3);
            this.lastFieldSet = -1;
            return (KafkaHeaderFW)super.build();
        }
    }
}

