/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;

public final class KafkaPartitionFW
extends Flyweight {
    public static final int FIELD_OFFSET_PARTITION_ID = 0;
    private static final int FIELD_SIZE_PARTITION_ID = 4;
    public static final int FIELD_OFFSET_LEADER_ID = 4;
    private static final int FIELD_SIZE_LEADER_ID = 4;

    public int partitionId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public int leaderId() {
        return this.buffer().getInt(this.offset() + 4);
    }

    @Override
    public KafkaPartitionFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        KafkaPartitionFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaPartitionFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + 4;
    }

    public String toString() {
        return String.format("KAFKA_PARTITION [partitionId=%d, leaderId=%d]", this.partitionId(), this.leaderId());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaPartitionFW> {
        private static final int INDEX_PARTITION_ID = 0;
        private static final int INDEX_LEADER_ID = 1;
        private static final int FIELD_COUNT = 2;
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaPartitionFW());
        }

        public Builder partitionId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder leaderId(int value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 4;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaPartitionFW>, ? extends Flyweight.Builder<KafkaPartitionFW>, KafkaPartitionFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaPartitionFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (KafkaPartitionFW)super.build();
        }
    }
}

