/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.StringFW;

public final class String16FW
extends StringFW {
    private static final int FIELD_SIZE_LENGTH = 2;
    private final ByteOrder byteOrder;
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

    public String16FW() {
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public String16FW(String value) {
        this(value, StandardCharsets.UTF_8);
    }

    public String16FW(String value, ByteOrder byteOrder) {
        this(value, StandardCharsets.UTF_8, byteOrder);
    }

    public String16FW(String value, Charset charset) {
        this(value, StandardCharsets.UTF_8, ByteOrder.nativeOrder());
    }

    public String16FW(String value, Charset charset, ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        if (value != null) {
            byte[] encoded = value.getBytes(charset);
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[2 + Math.max(encoded.length, 1)]);
            buffer.putShort(0, (short)(encoded.length & 0xFFFF), byteOrder);
            buffer.putBytes(2, encoded);
            this.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        } else {
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[3]);
            buffer.putShort(0, (short)-1);
            this.wrap((DirectBuffer)buffer, 0, buffer.capacity());
        }
    }

    public String16FW(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public int fieldSizeLength() {
        return 2;
    }

    @Override
    public int limit() {
        return this.offset() + 2 + Math.max(this.length(), 0);
    }

    public DirectBuffer value() {
        return this.length() == -1 ? null : this.valueRO;
    }

    @Override
    public String asString() {
        if (this.maxLimit() == this.offset() || this.length() == -1) {
            return null;
        }
        return this.buffer().getStringWithoutLengthUtf8(this.offset() + 2, this.length());
    }

    @Override
    public String16FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || offset + 2 > this.maxLimit() || this.limit() > maxLimit) {
            return null;
        }
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, offset + 2, length);
        }
        return this;
    }

    @Override
    public String16FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        String16FW.checkLimit(offset + 2, maxLimit);
        String16FW.checkLimit(this.limit(), maxLimit);
        int length = this.length();
        if (length != -1) {
            this.valueRO.wrap(buffer, offset + 2, length);
        }
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : String.format("\"%s\"", this.asString());
    }

    @Override
    public int length() {
        int length = this.buffer().getShort(this.offset(), this.byteOrder) & 0xFFFF;
        return length == 65535 ? -1 : length;
    }

    public static final class Builder
    extends StringFW.Builder<String16FW> {
        private final ByteOrder byteOrder;
        private boolean valueSet;

        public Builder() {
            super(new String16FW());
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(ByteOrder byteOrder) {
            super(new String16FW(byteOrder));
            this.byteOrder = byteOrder;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 2, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        @Override
        public Builder set(StringFW value) {
            if (value == null) {
                int newLimit = this.offset() + 2;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)-1, this.byteOrder);
                this.limit(newLimit);
            } else {
                int newLimit = this.offset() + 2 + value.length();
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)value.length(), this.byteOrder);
                this.buffer().putBytes(this.offset() + 2, value.buffer(), value.offset() + value.fieldSizeLength(), value.length());
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        @Override
        public Builder set(DirectBuffer srcBuffer, int srcOffset, int length) {
            Builder.checkLength(length);
            int offset = this.offset();
            int newLimit = offset + length + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(offset, (short)length, this.byteOrder);
            this.buffer().putBytes(offset + 2, srcBuffer, srcOffset, length);
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public Builder set(String value, Charset charset) {
            if (value == null) {
                int newLimit = this.offset() + 2;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)-1, this.byteOrder);
                this.limit(newLimit);
            } else {
                byte[] charBytes = value.getBytes(charset);
                Builder.checkLength(charBytes.length);
                int newLimit = this.offset() + 2 + charBytes.length;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)charBytes.length, this.byteOrder);
                this.buffer().putBytes(this.offset() + 2, charBytes);
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        private static void checkLength(int length) {
            int maxLength = 65534;
            if (length > 65534) {
                String msg = String.format("length=%d is beyond maximum length=%d", length, 65534);
                throw new IllegalArgumentException(msg);
            }
        }

        @Override
        public String16FW build() {
            if (!this.valueSet) {
                this.set(null, StandardCharsets.UTF_8);
            }
            return (String16FW)super.build();
        }
    }
}

