/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.kaazing.k3po.lang.el.BytesMatcher;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.KafkaCapabilities;
import org.reaktivity.specification.kafka.internal.types.KafkaCapabilitiesFW;
import org.reaktivity.specification.kafka.internal.types.KafkaConditionFW;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaFW;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaType;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaTypeFW;
import org.reaktivity.specification.kafka.internal.types.KafkaFilterFW;
import org.reaktivity.specification.kafka.internal.types.KafkaHeaderFW;
import org.reaktivity.specification.kafka.internal.types.KafkaKeyFW;
import org.reaktivity.specification.kafka.internal.types.KafkaNotFW;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetFW;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetType;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetTypeFW;
import org.reaktivity.specification.kafka.internal.types.OctetsFW;
import org.reaktivity.specification.kafka.internal.types.control.KafkaRouteExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaApi;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaBootstrapBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaDescribeBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaDescribeDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFetchBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFetchDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFetchFlushExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFlushExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMergedBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMergedDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMergedFlushExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMetaBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMetaDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaProduceBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaProduceDataExFW;

public final class KafkaFunctions {
    @Function
    public static KafkaRouteExBuilder routeEx() {
        return new KafkaRouteExBuilder();
    }

    @Function
    public static KafkaBeginExBuilder beginEx() {
        return new KafkaBeginExBuilder();
    }

    @Function
    public static KafkaDataExBuilder dataEx() {
        return new KafkaDataExBuilder();
    }

    @Function
    public static KafkaDataExMatcherBuilder matchDataEx() {
        return new KafkaDataExMatcherBuilder();
    }

    @Function
    public static KafkaFlushExBuilder flushEx() {
        return new KafkaFlushExBuilder();
    }

    @Function
    public static int length(String value) {
        return value.length();
    }

    @Function
    public static short lengthAsShort(String value) {
        return (short)value.length();
    }

    @Function
    public static int newRequestId() {
        return ThreadLocalRandom.current().nextInt();
    }

    @Function
    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)ThreadLocalRandom.current().nextInt(256);
        }
        return bytes;
    }

    @Function
    public static long timestamp() {
        return System.currentTimeMillis();
    }

    @Function
    public static byte[] varint(long value) {
        long bits = value << 1 ^ value >> 63;
        switch (bits != 0L ? (int)Math.ceil((double)(1 + Long.numberOfTrailingZeros(Long.highestOneBit(bits))) / 7.0) : 1) {
            case 1: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL)};
            }
            case 2: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL)};
            }
            case 3: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL)};
            }
            case 4: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL)};
            }
            case 5: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL)};
            }
            case 6: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL)};
            }
            case 7: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL)};
            }
            case 8: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL | 0x80L), (byte)(bits >> 49 & 0x7FL)};
            }
            case 9: {
                return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL | 0x80L), (byte)(bits >> 49 & 0x7FL | 0x80L), (byte)(bits >> 56 & 0x7FL)};
            }
        }
        return new byte[]{(byte)(bits >> 0 & 0x7FL | 0x80L), (byte)(bits >> 7 & 0x7FL | 0x80L), (byte)(bits >> 14 & 0x7FL | 0x80L), (byte)(bits >> 21 & 0x7FL | 0x80L), (byte)(bits >> 28 & 0x7FL | 0x80L), (byte)(bits >> 35 & 0x7FL | 0x80L), (byte)(bits >> 42 & 0x7FL | 0x80L), (byte)(bits >> 49 & 0x7FL | 0x80L), (byte)(bits >> 56 & 0x7FL | 0x80L), (byte)(bits >> 63 & 1L)};
    }

    @Function
    public static long offset(String type) {
        return KafkaOffsetType.valueOf(type).value();
    }

    private KafkaFunctions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(KafkaFunctions.class);
        }

        public String getPrefixName() {
            return "kafka";
        }
    }

    public static final class KafkaDataExMatcherBuilder {
        private final DirectBuffer bufferRO = new UnsafeBuffer();
        private final DirectBuffer keyRO = new UnsafeBuffer(0L, 0);
        private final DirectBuffer nameRO = new UnsafeBuffer(0L, 0);
        private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);
        private final KafkaDataExFW dataExRO = new KafkaDataExFW();
        private Integer typeId;
        private Integer kind;
        private Predicate<KafkaDataExFW> caseMatcher;

        public KafkaMergedDataExMatcherBuilder merged() {
            KafkaMergedDataExMatcherBuilder matcherBuilder = new KafkaMergedDataExMatcherBuilder();
            this.kind = KafkaApi.MERGED.value();
            this.caseMatcher = x$0 -> matcherBuilder.match(x$0);
            return matcherBuilder;
        }

        public KafkaFetchDataExMatcherBuilder fetch() {
            KafkaFetchDataExMatcherBuilder matcherBuilder = new KafkaFetchDataExMatcherBuilder();
            this.kind = KafkaApi.FETCH.value();
            this.caseMatcher = x$0 -> matcherBuilder.match(x$0);
            return matcherBuilder;
        }

        public KafkaProduceDataExMatcherBuilder produce() {
            KafkaProduceDataExMatcherBuilder matcherBuilder = new KafkaProduceDataExMatcherBuilder();
            this.kind = KafkaApi.PRODUCE.value();
            this.caseMatcher = x$0 -> matcherBuilder.match(x$0);
            return matcherBuilder;
        }

        public KafkaDataExMatcherBuilder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        public BytesMatcher build() {
            return this.typeId != null || this.kind != null ? this::match : buf -> null;
        }

        private KafkaDataExFW match(ByteBuffer byteBuf) throws Exception {
            if (!byteBuf.hasRemaining()) {
                return null;
            }
            this.bufferRO.wrap(byteBuf);
            KafkaDataExFW dataEx = this.dataExRO.tryWrap(this.bufferRO, byteBuf.position(), byteBuf.capacity());
            if (dataEx != null && this.matchTypeId(dataEx) && this.matchKind(dataEx) && this.matchCase(dataEx)) {
                byteBuf.position(byteBuf.position() + dataEx.sizeof());
                return dataEx;
            }
            throw new Exception(dataEx.toString());
        }

        private boolean matchTypeId(KafkaDataExFW dataEx) {
            return this.typeId == null || this.typeId.intValue() == dataEx.typeId();
        }

        private boolean matchKind(KafkaDataExFW dataEx) {
            return this.kind == null || this.kind.intValue() == dataEx.kind();
        }

        private boolean matchCase(KafkaDataExFW dataEx) throws Exception {
            return this.caseMatcher == null || this.caseMatcher.test(dataEx);
        }

        public final class KafkaMergedDataExMatcherBuilder {
            private Integer deferred;
            private Long timestamp;
            private KafkaOffsetFW.Builder partitionRW;
            private Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> progressRW;
            private KafkaDeltaFW.Builder deltaRW;
            private KafkaKeyFW.Builder keyRW;
            private Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW> headersRW;

            private KafkaMergedDataExMatcherBuilder() {
            }

            public KafkaMergedDataExMatcherBuilder deferred(int deferred) {
                this.deferred = deferred;
                return this;
            }

            public KafkaMergedDataExMatcherBuilder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public KafkaMergedDataExMatcherBuilder partition(int partitionId, long offset) {
                this.partition(partitionId, offset, -1L);
                return this;
            }

            public KafkaMergedDataExMatcherBuilder partition(int partitionId, long offset, long latestOffset) {
                assert (this.partitionRW == null);
                this.partitionRW = new KafkaOffsetFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                this.partitionRW.partitionId(partitionId).partitionOffset(offset).latestOffset(latestOffset);
                return this;
            }

            public KafkaMergedDataExMatcherBuilder progress(int partitionId, long offset) {
                this.progress(partitionId, offset, -1L);
                return this;
            }

            public KafkaMergedDataExMatcherBuilder progress(int partitionId, long offset, long latestOffset) {
                if (this.progressRW == null) {
                    this.progressRW = new Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW>(new KafkaOffsetFW.Builder(), new KafkaOffsetFW()).wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                }
                this.progressRW.item(i -> i.partitionId(partitionId).partitionOffset(offset).latestOffset(latestOffset));
                return this;
            }

            public KafkaMergedDataExMatcherBuilder key(String key) {
                assert (this.keyRW == null);
                this.keyRW = new KafkaKeyFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                if (key == null) {
                    this.keyRW.length(-1).value((OctetsFW)null);
                } else {
                    KafkaDataExMatcherBuilder.this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                    this.keyRW.length(KafkaDataExMatcherBuilder.this.keyRO.capacity()).value(KafkaDataExMatcherBuilder.this.keyRO, 0, KafkaDataExMatcherBuilder.this.keyRO.capacity());
                }
                return this;
            }

            public KafkaMergedDataExMatcherBuilder delta(String delta, long ancestorOffset) {
                assert (this.deltaRW == null);
                this.deltaRW = new KafkaDeltaFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                this.deltaRW.type(t -> t.set(KafkaDeltaType.valueOf(delta))).ancestorOffset(ancestorOffset);
                return this;
            }

            public KafkaMergedDataExMatcherBuilder header(String name, String value) {
                if (this.headersRW == null) {
                    this.headersRW = new Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>(new KafkaHeaderFW.Builder(), new KafkaHeaderFW()).wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                }
                if (value == null) {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    KafkaDataExMatcherBuilder.this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(KafkaDataExMatcherBuilder.this.valueRO.capacity()).value(KafkaDataExMatcherBuilder.this.valueRO, 0, KafkaDataExMatcherBuilder.this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaMergedDataExMatcherBuilder headerBytes(String name, byte[] value) {
                if (this.headersRW == null) {
                    this.headersRW = new Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>(new KafkaHeaderFW.Builder(), new KafkaHeaderFW()).wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                }
                if (value == null) {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    KafkaDataExMatcherBuilder.this.valueRO.wrap(value);
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(KafkaDataExMatcherBuilder.this.valueRO.capacity()).value(KafkaDataExMatcherBuilder.this.valueRO, 0, KafkaDataExMatcherBuilder.this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaDataExMatcherBuilder build() {
                return KafkaDataExMatcherBuilder.this;
            }

            private boolean match(KafkaDataExFW dataEx) {
                KafkaMergedDataExFW mergedDataEx = dataEx.merged();
                return this.matchPartition(mergedDataEx) && this.matchProgress(mergedDataEx) && this.matchDeferred(mergedDataEx) && this.matchTimestamp(mergedDataEx) && this.matchKey(mergedDataEx) && this.matchDelta(mergedDataEx) && this.matchHeaders(mergedDataEx);
            }

            private boolean matchPartition(KafkaMergedDataExFW mergedDataEx) {
                return this.partitionRW == null || this.partitionRW.build().equals(mergedDataEx.partition());
            }

            private boolean matchProgress(KafkaMergedDataExFW mergedDataEx) {
                return this.progressRW == null || this.progressRW.build().equals(mergedDataEx.progress());
            }

            private boolean matchDeferred(KafkaMergedDataExFW mergedDataEx) {
                return this.deferred == null || this.deferred.intValue() == mergedDataEx.deferred();
            }

            private boolean matchTimestamp(KafkaMergedDataExFW mergedDataEx) {
                return this.timestamp == null || this.timestamp.longValue() == mergedDataEx.timestamp();
            }

            private boolean matchKey(KafkaMergedDataExFW mergedDataEx) {
                return this.keyRW == null || this.keyRW.build().equals(mergedDataEx.key());
            }

            private boolean matchDelta(KafkaMergedDataExFW mergedDataEx) {
                return this.deltaRW == null || this.deltaRW.build().equals(mergedDataEx.delta());
            }

            private boolean matchHeaders(KafkaMergedDataExFW mergedDataEx) {
                return this.headersRW == null || this.headersRW.build().equals(mergedDataEx.headers());
            }
        }

        public final class KafkaProduceDataExMatcherBuilder {
            private Integer deferred;
            private Long timestamp;
            private Integer sequence;
            private KafkaKeyFW.Builder keyRW;
            private Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW> headersRW;

            private KafkaProduceDataExMatcherBuilder() {
            }

            public KafkaProduceDataExMatcherBuilder deferred(int deferred) {
                this.deferred = deferred;
                return this;
            }

            public KafkaProduceDataExMatcherBuilder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public KafkaProduceDataExMatcherBuilder sequence(int sequence) {
                this.sequence = sequence;
                return this;
            }

            public KafkaProduceDataExMatcherBuilder key(String key) {
                assert (this.keyRW == null);
                this.keyRW = new KafkaKeyFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                if (key == null) {
                    this.keyRW.length(-1).value((OctetsFW)null);
                } else {
                    KafkaDataExMatcherBuilder.this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                    this.keyRW.length(KafkaDataExMatcherBuilder.this.keyRO.capacity()).value(KafkaDataExMatcherBuilder.this.keyRO, 0, KafkaDataExMatcherBuilder.this.keyRO.capacity());
                }
                return this;
            }

            public KafkaProduceDataExMatcherBuilder header(String name, String value) {
                if (this.headersRW == null) {
                    this.headersRW = new Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>(new KafkaHeaderFW.Builder(), new KafkaHeaderFW()).wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                }
                if (value == null) {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    KafkaDataExMatcherBuilder.this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(KafkaDataExMatcherBuilder.this.valueRO.capacity()).value(KafkaDataExMatcherBuilder.this.valueRO, 0, KafkaDataExMatcherBuilder.this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaDataExMatcherBuilder build() {
                return KafkaDataExMatcherBuilder.this;
            }

            private boolean match(KafkaDataExFW dataEx) {
                KafkaProduceDataExFW produceDataEx = dataEx.produce();
                return this.matchDeferred(produceDataEx) && this.matchTimestamp(produceDataEx) && this.matchSequence(produceDataEx) && this.matchKey(produceDataEx) && this.matchHeaders(produceDataEx);
            }

            private boolean matchDeferred(KafkaProduceDataExFW produceDataEx) {
                return this.deferred == null || this.deferred.intValue() == produceDataEx.deferred();
            }

            private boolean matchTimestamp(KafkaProduceDataExFW produceDataEx) {
                return this.timestamp == null || this.timestamp.longValue() == produceDataEx.timestamp();
            }

            private boolean matchSequence(KafkaProduceDataExFW produceDataEx) {
                return this.sequence == null || this.sequence.intValue() == produceDataEx.sequence();
            }

            private boolean matchKey(KafkaProduceDataExFW produceDataEx) {
                return this.keyRW == null || this.keyRW.build().equals(produceDataEx.key());
            }

            private boolean matchHeaders(KafkaProduceDataExFW produceDataEx) {
                return this.headersRW == null || this.headersRW.build().equals(produceDataEx.headers());
            }
        }

        public final class KafkaFetchDataExMatcherBuilder {
            private Integer deferred;
            private Long timestamp;
            private KafkaOffsetFW.Builder partitionRW;
            private KafkaKeyFW.Builder keyRW;
            private KafkaDeltaFW.Builder deltaRW;
            private Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW> headersRW;

            private KafkaFetchDataExMatcherBuilder() {
            }

            public KafkaFetchDataExMatcherBuilder deferred(int deferred) {
                this.deferred = deferred;
                return this;
            }

            public KafkaFetchDataExMatcherBuilder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public KafkaFetchDataExMatcherBuilder partition(int partitionId, long partitionOffset) {
                this.partition(partitionId, partitionOffset, -1L);
                return this;
            }

            public KafkaFetchDataExMatcherBuilder partition(int partitionId, long partitionOffset, long latestOffset) {
                assert (this.partitionRW == null);
                this.partitionRW = new KafkaOffsetFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                this.partitionRW.partitionId(partitionId).partitionOffset(partitionOffset).latestOffset(latestOffset);
                return this;
            }

            public KafkaFetchDataExMatcherBuilder key(String key) {
                assert (this.keyRW == null);
                this.keyRW = new KafkaKeyFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                if (key == null) {
                    this.keyRW.length(-1).value((OctetsFW)null);
                } else {
                    KafkaDataExMatcherBuilder.this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                    this.keyRW.length(KafkaDataExMatcherBuilder.this.keyRO.capacity()).value(KafkaDataExMatcherBuilder.this.keyRO, 0, KafkaDataExMatcherBuilder.this.keyRO.capacity());
                }
                return this;
            }

            public KafkaFetchDataExMatcherBuilder delta(String delta, long ancestorOffset) {
                assert (this.deltaRW == null);
                this.deltaRW = new KafkaDeltaFW.Builder().wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                this.deltaRW.type(t -> t.set(KafkaDeltaType.valueOf(delta))).ancestorOffset(ancestorOffset);
                return this;
            }

            public KafkaFetchDataExMatcherBuilder header(String name, String value) {
                if (this.headersRW == null) {
                    this.headersRW = new Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>(new KafkaHeaderFW.Builder(), new KafkaHeaderFW()).wrap((MutableDirectBuffer)new UnsafeBuffer(new byte[1024]), 0, 1024);
                }
                if (value == null) {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    KafkaDataExMatcherBuilder.this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    KafkaDataExMatcherBuilder.this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                    this.headersRW.item(i -> i.nameLen(KafkaDataExMatcherBuilder.this.nameRO.capacity()).name(KafkaDataExMatcherBuilder.this.nameRO, 0, KafkaDataExMatcherBuilder.this.nameRO.capacity()).valueLen(KafkaDataExMatcherBuilder.this.valueRO.capacity()).value(KafkaDataExMatcherBuilder.this.valueRO, 0, KafkaDataExMatcherBuilder.this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaDataExMatcherBuilder build() {
                return KafkaDataExMatcherBuilder.this;
            }

            private boolean match(KafkaDataExFW dataEx) {
                KafkaFetchDataExFW fetchDataEx = dataEx.fetch();
                return this.matchDeferred(fetchDataEx) && this.matchTimestamp(fetchDataEx) && this.matchPartition(fetchDataEx) && this.matchKey(fetchDataEx) && this.matchDelta(fetchDataEx) && this.matchHeaders(fetchDataEx);
            }

            private boolean matchDeferred(KafkaFetchDataExFW fetchDataEx) {
                return this.deferred == null || this.deferred.intValue() == fetchDataEx.deferred();
            }

            private boolean matchTimestamp(KafkaFetchDataExFW fetchDataEx) {
                return this.timestamp == null || this.timestamp.longValue() == fetchDataEx.timestamp();
            }

            private boolean matchPartition(KafkaFetchDataExFW fetchDataEx) {
                return this.partitionRW == null || this.partitionRW.build().equals(fetchDataEx.partition());
            }

            private boolean matchKey(KafkaFetchDataExFW fetchDataEx) {
                return this.keyRW == null || this.keyRW.build().equals(fetchDataEx.key());
            }

            private boolean matchDelta(KafkaFetchDataExFW fetchDataEx) {
                return this.deltaRW == null || this.deltaRW.build().equals(fetchDataEx.delta());
            }

            private boolean matchHeaders(KafkaFetchDataExFW fetchDataEx) {
                return this.headersRW == null || this.headersRW.build().equals(fetchDataEx.headers());
            }
        }
    }

    public static final class KafkaFlushExBuilder {
        private final MutableDirectBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
        private final KafkaFlushExFW flushExRO = new KafkaFlushExFW();
        private final KafkaFlushExFW.Builder flushExRW = new KafkaFlushExFW.Builder();

        private KafkaFlushExBuilder() {
            this.flushExRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity());
        }

        public KafkaFlushExBuilder typeId(int typeId) {
            this.flushExRW.typeId(typeId);
            return this;
        }

        public KafkaMergedFlushExBuilder merged() {
            this.flushExRW.kind(KafkaApi.MERGED.value());
            return new KafkaMergedFlushExBuilder();
        }

        public KafkaFetchFlushExBuilder fetch() {
            this.flushExRW.kind(KafkaApi.FETCH.value());
            return new KafkaFetchFlushExBuilder();
        }

        public byte[] build() {
            KafkaFlushExFW flushEx = this.flushExRO;
            byte[] array = new byte[flushEx.sizeof()];
            flushEx.buffer().getBytes(flushEx.offset(), array);
            return array;
        }

        public final class KafkaFetchFlushExBuilder {
            private final KafkaFetchFlushExFW.Builder fetchFlushExRW = new KafkaFetchFlushExFW.Builder();

            private KafkaFetchFlushExBuilder() {
                this.fetchFlushExRW.wrap(KafkaFlushExBuilder.this.writeBuffer, 5, KafkaFlushExBuilder.this.writeBuffer.capacity());
            }

            public KafkaFetchFlushExBuilder partition(int partitionId, long offset) {
                this.fetchFlushExRW.partition(p -> p.partitionId(partitionId).partitionOffset(offset));
                return this;
            }

            public KafkaFetchFlushExBuilder partition(int partitionId, long offset, long latestOffset) {
                this.fetchFlushExRW.partition(p -> p.partitionId(partitionId).partitionOffset(offset).latestOffset(latestOffset));
                return this;
            }

            public KafkaFlushExBuilder build() {
                KafkaFetchFlushExFW fetchFlushEx = this.fetchFlushExRW.build();
                KafkaFlushExBuilder.this.flushExRO.wrap((DirectBuffer)KafkaFlushExBuilder.this.writeBuffer, 0, fetchFlushEx.limit());
                return KafkaFlushExBuilder.this;
            }
        }

        public final class KafkaMergedFlushExBuilder {
            private final KafkaMergedFlushExFW.Builder mergedFlushExRW = new KafkaMergedFlushExFW.Builder();

            private KafkaMergedFlushExBuilder() {
                this.mergedFlushExRW.wrap(KafkaFlushExBuilder.this.writeBuffer, 5, KafkaFlushExBuilder.this.writeBuffer.capacity());
            }

            public KafkaMergedFlushExBuilder progress(int partitionId, long offset) {
                this.progress(partitionId, offset, -1L);
                return this;
            }

            public KafkaMergedFlushExBuilder progress(int partitionId, long offset, long latestOffset) {
                this.mergedFlushExRW.progressItem(p -> p.partitionId(partitionId).partitionOffset(offset).latestOffset(latestOffset));
                return this;
            }

            public KafkaMergedFlushExBuilder capabilities(String capabilities) {
                this.mergedFlushExRW.capabilities((KafkaCapabilitiesFW.Builder c) -> c.set(KafkaCapabilities.valueOf(capabilities)));
                return this;
            }

            public KafkaFlushExBuilder build() {
                KafkaMergedFlushExFW mergedFlushEx = this.mergedFlushExRW.build();
                KafkaFlushExBuilder.this.flushExRO.wrap((DirectBuffer)KafkaFlushExBuilder.this.writeBuffer, 0, mergedFlushEx.limit());
                return KafkaFlushExBuilder.this;
            }
        }
    }

    public static final class KafkaDataExBuilder {
        private final MutableDirectBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
        private final KafkaDataExFW dataExRO = new KafkaDataExFW();
        private final KafkaDataExFW.Builder dataExRW = new KafkaDataExFW.Builder();

        private KafkaDataExBuilder() {
            this.dataExRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity());
        }

        public KafkaDataExBuilder typeId(int typeId) {
            this.dataExRW.typeId(typeId);
            return this;
        }

        public KafkaMergedDataExBuilder merged() {
            this.dataExRW.kind(KafkaApi.MERGED.value());
            return new KafkaMergedDataExBuilder();
        }

        public KafkaFetchDataExBuilder fetch() {
            this.dataExRW.kind(KafkaApi.FETCH.value());
            return new KafkaFetchDataExBuilder();
        }

        public KafkaMetaDataExBuilder meta() {
            this.dataExRW.kind(KafkaApi.META.value());
            return new KafkaMetaDataExBuilder();
        }

        public KafkaDescribeDataExBuilder describe() {
            this.dataExRW.kind(KafkaApi.DESCRIBE.value());
            return new KafkaDescribeDataExBuilder();
        }

        public KafkaProduceDataExBuilder produce() {
            this.dataExRW.kind(KafkaApi.PRODUCE.value());
            return new KafkaProduceDataExBuilder();
        }

        public byte[] build() {
            KafkaDataExFW dataEx = this.dataExRO;
            byte[] array = new byte[dataEx.sizeof()];
            dataEx.buffer().getBytes(dataEx.offset(), array);
            return array;
        }

        public final class KafkaProduceDataExBuilder {
            private final DirectBuffer keyRO = new UnsafeBuffer(0L, 0);
            private final DirectBuffer nameRO = new UnsafeBuffer(0L, 0);
            private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);
            private final KafkaProduceDataExFW.Builder produceDataExRW = new KafkaProduceDataExFW.Builder();

            private KafkaProduceDataExBuilder() {
                this.produceDataExRW.wrap(KafkaDataExBuilder.this.writeBuffer, 5, KafkaDataExBuilder.this.writeBuffer.capacity());
            }

            public KafkaProduceDataExBuilder deferred(int deferred) {
                this.produceDataExRW.deferred(deferred);
                return this;
            }

            public KafkaProduceDataExBuilder timestamp(long timestamp) {
                this.produceDataExRW.timestamp(timestamp);
                return this;
            }

            public KafkaProduceDataExBuilder sequence(int sequence) {
                this.produceDataExRW.sequence(sequence);
                return this;
            }

            public KafkaProduceDataExBuilder key(String key) {
                if (key == null) {
                    this.produceDataExRW.key((KafkaKeyFW.Builder m) -> m.length(-1).value((OctetsFW)null));
                } else {
                    this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                    this.produceDataExRW.key((KafkaKeyFW.Builder k) -> k.length(this.keyRO.capacity()).value(this.keyRO, 0, this.keyRO.capacity()));
                }
                return this;
            }

            public KafkaProduceDataExBuilder header(String name, String value) {
                if (value == null) {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.produceDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                    this.produceDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(this.valueRO.capacity()).value(this.valueRO, 0, this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaDataExBuilder build() {
                KafkaProduceDataExFW produceDataEx = this.produceDataExRW.build();
                KafkaDataExBuilder.this.dataExRO.wrap((DirectBuffer)KafkaDataExBuilder.this.writeBuffer, 0, produceDataEx.limit());
                return KafkaDataExBuilder.this;
            }
        }

        public final class KafkaDescribeDataExBuilder {
            private final KafkaDescribeDataExFW.Builder describeDataExRW = new KafkaDescribeDataExFW.Builder();

            private KafkaDescribeDataExBuilder() {
                this.describeDataExRW.wrap(KafkaDataExBuilder.this.writeBuffer, 5, KafkaDataExBuilder.this.writeBuffer.capacity());
            }

            public KafkaDescribeDataExBuilder config(String name, String value) {
                this.describeDataExRW.configsItem(c -> c.name(name).value(value));
                return this;
            }

            public KafkaDataExBuilder build() {
                KafkaDescribeDataExFW describeDataEx = this.describeDataExRW.build();
                KafkaDataExBuilder.this.dataExRO.wrap((DirectBuffer)KafkaDataExBuilder.this.writeBuffer, 0, describeDataEx.limit());
                return KafkaDataExBuilder.this;
            }
        }

        public final class KafkaMetaDataExBuilder {
            private final KafkaMetaDataExFW.Builder metaDataExRW = new KafkaMetaDataExFW.Builder();

            private KafkaMetaDataExBuilder() {
                this.metaDataExRW.wrap(KafkaDataExBuilder.this.writeBuffer, 5, KafkaDataExBuilder.this.writeBuffer.capacity());
            }

            public KafkaMetaDataExBuilder partition(int partitionId, int leaderId) {
                this.metaDataExRW.partitionsItem(p -> p.partitionId(partitionId).leaderId(leaderId));
                return this;
            }

            public KafkaDataExBuilder build() {
                KafkaMetaDataExFW metaDataEx = this.metaDataExRW.build();
                KafkaDataExBuilder.this.dataExRO.wrap((DirectBuffer)KafkaDataExBuilder.this.writeBuffer, 0, metaDataEx.limit());
                return KafkaDataExBuilder.this;
            }
        }

        public final class KafkaMergedDataExBuilder {
            private final DirectBuffer keyRO = new UnsafeBuffer(0L, 0);
            private final DirectBuffer nameRO = new UnsafeBuffer(0L, 0);
            private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);
            private final KafkaMergedDataExFW.Builder mergedDataExRW = new KafkaMergedDataExFW.Builder();

            private KafkaMergedDataExBuilder() {
                this.mergedDataExRW.wrap(KafkaDataExBuilder.this.writeBuffer, 5, KafkaDataExBuilder.this.writeBuffer.capacity());
            }

            public KafkaMergedDataExBuilder deferred(int deferred) {
                this.mergedDataExRW.deferred(deferred);
                return this;
            }

            public KafkaMergedDataExBuilder timestamp(long timestamp) {
                this.mergedDataExRW.timestamp(timestamp);
                return this;
            }

            public KafkaMergedDataExBuilder partition(int partitionId, long partitionOffset) {
                this.partition(partitionId, partitionOffset, -1L);
                return this;
            }

            public KafkaMergedDataExBuilder partition(int partitionId, long partitionOffset, long latestOffset) {
                this.mergedDataExRW.partition(p -> p.partitionId(partitionId).partitionOffset(partitionOffset).latestOffset(latestOffset));
                return this;
            }

            public KafkaMergedDataExBuilder progress(int partitionId, long partitionOffset) {
                this.progress(partitionId, partitionOffset, -1L);
                return this;
            }

            public KafkaMergedDataExBuilder progress(int partitionId, long partitionOffset, long latestOffset) {
                this.mergedDataExRW.progressItem(p -> p.partitionId(partitionId).partitionOffset(partitionOffset).latestOffset(latestOffset));
                return this;
            }

            public KafkaMergedDataExBuilder key(String key) {
                if (key == null) {
                    this.mergedDataExRW.key((KafkaKeyFW.Builder m) -> m.length(-1).value((OctetsFW)null));
                } else {
                    this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                    this.mergedDataExRW.key((KafkaKeyFW.Builder k) -> k.length(this.keyRO.capacity()).value(this.keyRO, 0, this.keyRO.capacity()));
                }
                return this;
            }

            public KafkaMergedDataExBuilder delta(String deltaType, long ancestorOffset) {
                this.mergedDataExRW.delta(d -> d.type(t -> t.set(KafkaDeltaType.valueOf(deltaType))).ancestorOffset(ancestorOffset));
                return this;
            }

            public KafkaMergedDataExBuilder header(String name, String value) {
                if (value == null) {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.mergedDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                    this.mergedDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(this.valueRO.capacity()).value(this.valueRO, 0, this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaMergedDataExBuilder headerBytes(String name, byte[] value) {
                if (value == null) {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.mergedDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.valueRO.wrap(value);
                    this.mergedDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(this.valueRO.capacity()).value(this.valueRO, 0, this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaDataExBuilder build() {
                KafkaMergedDataExFW mergedDataEx = this.mergedDataExRW.build();
                KafkaDataExBuilder.this.dataExRO.wrap((DirectBuffer)KafkaDataExBuilder.this.writeBuffer, 0, mergedDataEx.limit());
                return KafkaDataExBuilder.this;
            }
        }

        public final class KafkaFetchDataExBuilder {
            private final DirectBuffer keyRO = new UnsafeBuffer(0L, 0);
            private final DirectBuffer nameRO = new UnsafeBuffer(0L, 0);
            private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);
            private final KafkaFetchDataExFW.Builder fetchDataExRW = new KafkaFetchDataExFW.Builder();

            private KafkaFetchDataExBuilder() {
                this.fetchDataExRW.wrap(KafkaDataExBuilder.this.writeBuffer, 5, KafkaDataExBuilder.this.writeBuffer.capacity());
            }

            public KafkaFetchDataExBuilder deferred(int deferred) {
                this.fetchDataExRW.deferred(deferred);
                return this;
            }

            public KafkaFetchDataExBuilder timestamp(long timestamp) {
                this.fetchDataExRW.timestamp(timestamp);
                return this;
            }

            public KafkaFetchDataExBuilder partition(int partitionId, long partitionOffset) {
                this.fetchDataExRW.partition(p -> p.partitionId(partitionId).partitionOffset(partitionOffset));
                return this;
            }

            public KafkaFetchDataExBuilder partition(int partitionId, long partitionOffset, long latestOffset) {
                this.fetchDataExRW.partition(p -> p.partitionId(partitionId).partitionOffset(partitionOffset).latestOffset(latestOffset));
                return this;
            }

            public KafkaFetchDataExBuilder key(String key) {
                if (key == null) {
                    this.fetchDataExRW.key((KafkaKeyFW.Builder m) -> m.length(-1).value((OctetsFW)null));
                } else {
                    this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                    this.fetchDataExRW.key((KafkaKeyFW.Builder k) -> k.length(this.keyRO.capacity()).value(this.keyRO, 0, this.keyRO.capacity()));
                }
                return this;
            }

            public KafkaFetchDataExBuilder delta(String deltaType, long ancestorOffset) {
                this.fetchDataExRW.delta(d -> d.type(t -> t.set(KafkaDeltaType.valueOf(deltaType))).ancestorOffset(ancestorOffset));
                return this;
            }

            public KafkaFetchDataExBuilder header(String name, String value) {
                if (value == null) {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.fetchDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null));
                } else {
                    this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                    this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                    this.fetchDataExRW.headersItem(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(this.valueRO.capacity()).value(this.valueRO, 0, this.valueRO.capacity()));
                }
                return this;
            }

            public KafkaDataExBuilder build() {
                KafkaFetchDataExFW fetchDataEx = this.fetchDataExRW.build();
                KafkaDataExBuilder.this.dataExRO.wrap((DirectBuffer)KafkaDataExBuilder.this.writeBuffer, 0, fetchDataEx.limit());
                return KafkaDataExBuilder.this;
            }
        }
    }

    public static final class KafkaBeginExBuilder {
        private final MutableDirectBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
        private final KafkaBeginExFW beginExRO = new KafkaBeginExFW();
        private final KafkaBeginExFW.Builder beginExRW = new KafkaBeginExFW.Builder();

        private KafkaBeginExBuilder() {
            this.beginExRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity());
        }

        public KafkaBeginExBuilder typeId(int typeId) {
            this.beginExRW.typeId(typeId);
            return this;
        }

        public KafkaBootstrapBeginExBuilder bootstrap() {
            this.beginExRW.kind(KafkaApi.BOOTSTRAP.value());
            return new KafkaBootstrapBeginExBuilder();
        }

        public KafkaMergedBeginExBuilder merged() {
            this.beginExRW.kind(KafkaApi.MERGED.value());
            return new KafkaMergedBeginExBuilder();
        }

        public KafkaFetchBeginExBuilder fetch() {
            this.beginExRW.kind(KafkaApi.FETCH.value());
            return new KafkaFetchBeginExBuilder();
        }

        public KafkaMetaBeginExBuilder meta() {
            this.beginExRW.kind(KafkaApi.META.value());
            return new KafkaMetaBeginExBuilder();
        }

        public KafkaDescribeBeginExBuilder describe() {
            this.beginExRW.kind(KafkaApi.DESCRIBE.value());
            return new KafkaDescribeBeginExBuilder();
        }

        public KafkaProduceBeginExBuilder produce() {
            this.beginExRW.kind(KafkaApi.PRODUCE.value());
            return new KafkaProduceBeginExBuilder();
        }

        public byte[] build() {
            KafkaBeginExFW beginEx = this.beginExRO;
            byte[] array = new byte[beginEx.sizeof()];
            beginEx.buffer().getBytes(beginEx.offset(), array);
            return array;
        }

        public final class KafkaProduceBeginExBuilder {
            private final KafkaProduceBeginExFW.Builder produceBeginExRW = new KafkaProduceBeginExFW.Builder();
            private boolean transactionSet;

            private KafkaProduceBeginExBuilder() {
                this.produceBeginExRW.wrap(KafkaBeginExBuilder.this.writeBuffer, 5, KafkaBeginExBuilder.this.writeBuffer.capacity());
            }

            public KafkaProduceBeginExBuilder transaction(String transaction) {
                this.produceBeginExRW.transaction(transaction);
                this.transactionSet = true;
                return this;
            }

            public KafkaProduceBeginExBuilder producerId(long producerId) {
                this.ensureTransactionSet();
                this.produceBeginExRW.producerId(producerId);
                return this;
            }

            public KafkaProduceBeginExBuilder topic(String topic) {
                this.ensureTransactionSet();
                this.produceBeginExRW.topic(topic);
                return this;
            }

            public KafkaProduceBeginExBuilder partitionId(int partitionId) {
                this.ensureTransactionSet();
                this.produceBeginExRW.partitionId(partitionId);
                return this;
            }

            public KafkaBeginExBuilder build() {
                KafkaProduceBeginExFW produceBeginEx = this.produceBeginExRW.build();
                KafkaBeginExBuilder.this.beginExRO.wrap((DirectBuffer)KafkaBeginExBuilder.this.writeBuffer, 0, produceBeginEx.limit());
                return KafkaBeginExBuilder.this;
            }

            private void ensureTransactionSet() {
                if (!this.transactionSet) {
                    this.transaction(null);
                }
            }
        }

        public final class KafkaDescribeBeginExBuilder {
            private final KafkaDescribeBeginExFW.Builder describeBeginExRW = new KafkaDescribeBeginExFW.Builder();

            private KafkaDescribeBeginExBuilder() {
                this.describeBeginExRW.wrap(KafkaBeginExBuilder.this.writeBuffer, 5, KafkaBeginExBuilder.this.writeBuffer.capacity());
            }

            public KafkaDescribeBeginExBuilder topic(String name) {
                this.describeBeginExRW.topic(name);
                return this;
            }

            public KafkaDescribeBeginExBuilder config(String name) {
                this.describeBeginExRW.configsItem(c -> c.set(name, StandardCharsets.UTF_8));
                return this;
            }

            public KafkaBeginExBuilder build() {
                KafkaDescribeBeginExFW describeBeginEx = this.describeBeginExRW.build();
                KafkaBeginExBuilder.this.beginExRO.wrap((DirectBuffer)KafkaBeginExBuilder.this.writeBuffer, 0, describeBeginEx.limit());
                return KafkaBeginExBuilder.this;
            }
        }

        public final class KafkaMetaBeginExBuilder {
            private final KafkaMetaBeginExFW.Builder metaBeginExRW = new KafkaMetaBeginExFW.Builder();

            private KafkaMetaBeginExBuilder() {
                this.metaBeginExRW.wrap(KafkaBeginExBuilder.this.writeBuffer, 5, KafkaBeginExBuilder.this.writeBuffer.capacity());
            }

            public KafkaMetaBeginExBuilder topic(String topic) {
                this.metaBeginExRW.topic(topic);
                return this;
            }

            public KafkaBeginExBuilder build() {
                KafkaMetaBeginExFW metaBeginEx = this.metaBeginExRW.build();
                KafkaBeginExBuilder.this.beginExRO.wrap((DirectBuffer)KafkaBeginExBuilder.this.writeBuffer, 0, metaBeginEx.limit());
                return KafkaBeginExBuilder.this;
            }
        }

        public final class KafkaFetchBeginExBuilder {
            private final KafkaFetchBeginExFW.Builder fetchBeginExRW = new KafkaFetchBeginExFW.Builder();

            private KafkaFetchBeginExBuilder() {
                this.fetchBeginExRW.wrap(KafkaBeginExBuilder.this.writeBuffer, 5, KafkaBeginExBuilder.this.writeBuffer.capacity());
            }

            public KafkaFetchBeginExBuilder topic(String topic) {
                this.fetchBeginExRW.topic(topic);
                return this;
            }

            public KafkaFetchBeginExBuilder partition(int partitionId, long offset) {
                this.partition(partitionId, offset, -1L);
                return this;
            }

            public KafkaFetchBeginExBuilder partition(int partitionId, long offset, long latestOffset) {
                this.fetchBeginExRW.partition(p -> p.partitionId(partitionId).partitionOffset(offset).latestOffset(latestOffset));
                return this;
            }

            public KafkaFilterBuilder<KafkaFetchBeginExBuilder> filter() {
                return new KafkaFilterBuilder<KafkaFetchBeginExBuilder>(){

                    @Override
                    protected KafkaFetchBeginExBuilder build(KafkaFilterFW filter) {
                        KafkaFetchBeginExBuilder.this.fetchBeginExRW.filtersItem(fb -> this.set((KafkaFilterFW.Builder)fb, filter));
                        return KafkaFetchBeginExBuilder.this;
                    }
                };
            }

            public KafkaFetchBeginExBuilder deltaType(String deltaType) {
                this.fetchBeginExRW.deltaType((KafkaDeltaTypeFW.Builder d) -> d.set(KafkaDeltaType.valueOf(deltaType)));
                return this;
            }

            public KafkaBeginExBuilder build() {
                KafkaFetchBeginExFW fetchBeginEx = this.fetchBeginExRW.build();
                KafkaBeginExBuilder.this.beginExRO.wrap((DirectBuffer)KafkaBeginExBuilder.this.writeBuffer, 0, fetchBeginEx.limit());
                return KafkaBeginExBuilder.this;
            }
        }

        public final class KafkaMergedBeginExBuilder {
            private final KafkaMergedBeginExFW.Builder mergedBeginExRW = new KafkaMergedBeginExFW.Builder();

            private KafkaMergedBeginExBuilder() {
                this.mergedBeginExRW.wrap(KafkaBeginExBuilder.this.writeBuffer, 5, KafkaBeginExBuilder.this.writeBuffer.capacity());
            }

            public KafkaMergedBeginExBuilder capabilities(String capabilities) {
                this.mergedBeginExRW.capabilities((KafkaCapabilitiesFW.Builder c) -> c.set(KafkaCapabilities.valueOf(capabilities)));
                return this;
            }

            public KafkaMergedBeginExBuilder topic(String topic) {
                this.mergedBeginExRW.topic(topic);
                return this;
            }

            public KafkaMergedBeginExBuilder partition(int partitionId, long offset) {
                this.partition(partitionId, offset, -1L);
                return this;
            }

            public KafkaMergedBeginExBuilder partition(int partitionId, long offset, long latestOffset) {
                this.mergedBeginExRW.partitionsItem(p -> p.partitionId(partitionId).partitionOffset(offset).latestOffset(latestOffset));
                return this;
            }

            public KafkaFilterBuilder<KafkaMergedBeginExBuilder> filter() {
                return new KafkaFilterBuilder<KafkaMergedBeginExBuilder>(){

                    @Override
                    protected KafkaMergedBeginExBuilder build(KafkaFilterFW filter) {
                        KafkaMergedBeginExBuilder.this.mergedBeginExRW.filtersItem(fb -> this.set((KafkaFilterFW.Builder)fb, filter));
                        return KafkaMergedBeginExBuilder.this;
                    }
                };
            }

            public KafkaMergedBeginExBuilder deltaType(String delta) {
                this.mergedBeginExRW.deltaType((KafkaDeltaTypeFW.Builder d) -> d.set(KafkaDeltaType.valueOf(delta)));
                return this;
            }

            public KafkaBeginExBuilder build() {
                KafkaMergedBeginExFW mergedBeginEx = this.mergedBeginExRW.build();
                KafkaBeginExBuilder.this.beginExRO.wrap((DirectBuffer)KafkaBeginExBuilder.this.writeBuffer, 0, mergedBeginEx.limit());
                return KafkaBeginExBuilder.this;
            }
        }

        public final class KafkaBootstrapBeginExBuilder {
            private final KafkaBootstrapBeginExFW.Builder bootstrapBeginExRW = new KafkaBootstrapBeginExFW.Builder();

            private KafkaBootstrapBeginExBuilder() {
                this.bootstrapBeginExRW.wrap(KafkaBeginExBuilder.this.writeBuffer, 5, KafkaBeginExBuilder.this.writeBuffer.capacity());
            }

            public KafkaBootstrapBeginExBuilder topic(String topic) {
                this.bootstrapBeginExRW.topic(topic);
                return this;
            }

            public KafkaBeginExBuilder build() {
                KafkaBootstrapBeginExFW bootstrapBeginEx = this.bootstrapBeginExRW.build();
                KafkaBeginExBuilder.this.beginExRO.wrap((DirectBuffer)KafkaBeginExBuilder.this.writeBuffer, 0, bootstrapBeginEx.limit());
                return KafkaBeginExBuilder.this;
            }
        }
    }

    public static abstract class KafkaFilterBuilder<T> {
        private final KafkaFilterFW.Builder filterRW = new KafkaFilterFW.Builder();
        private final DirectBuffer keyRO = new UnsafeBuffer(0L, 0);
        private final DirectBuffer nameRO = new UnsafeBuffer(0L, 0);
        private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

        private KafkaFilterBuilder() {
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[1024]);
            this.filterRW.wrap((MutableDirectBuffer)buffer, 0, buffer.capacity());
        }

        public KafkaFilterBuilder<T> key(String key) {
            if (key != null) {
                this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                this.filterRW.conditionsItem(c -> c.key((KafkaKeyFW.Builder k) -> k.length(this.keyRO.capacity()).value(this.keyRO, 0, this.keyRO.capacity())));
            } else {
                this.filterRW.conditionsItem(c -> c.key((KafkaKeyFW.Builder k) -> k.length(-1).value((OctetsFW)null)));
            }
            return this;
        }

        public KafkaFilterBuilder<T> header(String name, String value) {
            if (value == null) {
                this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                this.filterRW.conditionsItem(c -> c.header(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null)));
            } else {
                this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                this.filterRW.conditionsItem(c -> c.header(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(this.valueRO.capacity()).value(this.valueRO, 0, this.valueRO.capacity())));
            }
            return this;
        }

        public KafkaFilterBuilder<T> keyNot(String key) {
            if (key != null) {
                this.keyRO.wrap(key.getBytes(StandardCharsets.UTF_8));
                this.filterRW.conditionsItem(i -> i.not(n -> n.condition(c -> c.key((KafkaKeyFW.Builder k) -> k.length(this.keyRO.capacity()).value(this.keyRO, 0, this.keyRO.capacity())))));
            } else {
                this.filterRW.conditionsItem(i -> i.not(n -> n.condition(c -> c.key((KafkaKeyFW.Builder k) -> k.length(-1).value((OctetsFW)null)))));
            }
            return this;
        }

        public KafkaFilterBuilder<T> headerNot(String name, String value) {
            if (value == null) {
                this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                this.filterRW.conditionsItem(i -> i.not(n -> n.condition(c -> c.header(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(-1).value((OctetsFW)null)))));
            } else {
                this.nameRO.wrap(name.getBytes(StandardCharsets.UTF_8));
                this.valueRO.wrap(value.getBytes(StandardCharsets.UTF_8));
                this.filterRW.conditionsItem(i -> i.not(n -> n.condition(c -> c.header(h -> h.nameLen(this.nameRO.capacity()).name(this.nameRO, 0, this.nameRO.capacity()).valueLen(this.valueRO.capacity()).value(this.valueRO, 0, this.valueRO.capacity())))));
            }
            return this;
        }

        public T build() {
            KafkaFilterFW filter = this.filterRW.build();
            return this.build(filter);
        }

        protected abstract T build(KafkaFilterFW var1);

        protected void set(KafkaFilterFW.Builder builder, KafkaFilterFW filter) {
            Array32FW<KafkaConditionFW> conditions = filter.conditions();
            builder.conditions(csb -> this.set((Array32FW.Builder<KafkaConditionFW.Builder, KafkaConditionFW>)csb, conditions));
        }

        private void set(Array32FW.Builder<KafkaConditionFW.Builder, KafkaConditionFW> builder, Array32FW<KafkaConditionFW> conditions) {
            conditions.forEach(c -> builder.item(ib -> this.set((KafkaConditionFW.Builder)ib, (KafkaConditionFW)c)));
        }

        private void set(KafkaConditionFW.Builder builder, KafkaConditionFW condition) {
            block0 : switch (condition.kind()) {
                case 0: {
                    KafkaKeyFW key = condition.key();
                    builder.key((KafkaKeyFW.Builder kb) -> kb.length(key.length()).value(key.value()));
                    break;
                }
                case 1: {
                    KafkaHeaderFW header = condition.header();
                    builder.header(hb -> hb.nameLen(header.nameLen()).name(header.name()).valueLen(header.valueLen()).value(header.value()));
                    break;
                }
                case 2: {
                    KafkaNotFW not = condition.not();
                    KafkaConditionFW notCondition = not.condition();
                    switch (notCondition.kind()) {
                        case 0: {
                            KafkaKeyFW notKey = notCondition.key();
                            builder.not(n -> n.condition(c -> c.key((KafkaKeyFW.Builder kb) -> kb.length(notKey.length()).value(notKey.value()))));
                            break block0;
                        }
                        case 1: {
                            KafkaHeaderFW notHeader = notCondition.header();
                            builder.not(n -> n.condition(c -> c.header(hb -> hb.nameLen(notHeader.nameLen()).name(notHeader.name()).valueLen(notHeader.valueLen()).value(notHeader.value()))));
                        }
                    }
                }
            }
        }
    }

    public static final class KafkaRouteExBuilder {
        private final KafkaRouteExFW.Builder routeExRW;

        private KafkaRouteExBuilder() {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[8192]);
            this.routeExRW = new KafkaRouteExFW.Builder().wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity());
        }

        public KafkaRouteExBuilder topic(String topic) {
            this.routeExRW.topic(topic);
            return this;
        }

        public KafkaRouteExBuilder deltaType(String deltaType) {
            this.routeExRW.deltaType((KafkaDeltaTypeFW.Builder d) -> d.set(KafkaDeltaType.valueOf(deltaType)));
            return this;
        }

        public KafkaRouteExBuilder defaultOffset(String defaultOffset) {
            this.routeExRW.defaultOffset((KafkaOffsetTypeFW.Builder p) -> p.set(KafkaOffsetType.valueOf(defaultOffset)));
            return this;
        }

        public byte[] build() {
            KafkaRouteExFW routeEx = this.routeExRW.build();
            byte[] array = new byte[routeEx.sizeof()];
            routeEx.buffer().getBytes(routeEx.offset(), array);
            return array;
        }
    }
}

