/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaDescribeDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFetchDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMergedDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMetaDataExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaProduceDataExFW;

public final class KafkaDataExFW
extends Flyweight {
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 4;
    public static final int KIND_MERGED = 255;
    public static final int FIELD_OFFSET_MERGED = 5;
    public static final int KIND_META = 3;
    public static final int FIELD_OFFSET_META = 5;
    public static final int KIND_DESCRIBE = 32;
    public static final int FIELD_OFFSET_DESCRIBE = 5;
    public static final int KIND_FETCH = 1;
    public static final int FIELD_OFFSET_FETCH = 5;
    public static final int KIND_PRODUCE = 0;
    public static final int FIELD_OFFSET_PRODUCE = 5;
    private KafkaMergedDataExFW mergedRO;
    private KafkaMetaDataExFW metaRO;
    private KafkaDescribeDataExFW describeRO;
    private KafkaFetchDataExFW fetchRO;
    private KafkaProduceDataExFW produceRO;

    public int kind() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public KafkaMergedDataExFW merged() {
        if (this.mergedRO == null) {
            this.mergedRO = new KafkaMergedDataExFW();
        }
        return this.mergedRO;
    }

    public KafkaMetaDataExFW meta() {
        if (this.metaRO == null) {
            this.metaRO = new KafkaMetaDataExFW();
        }
        return this.metaRO;
    }

    public KafkaDescribeDataExFW describe() {
        if (this.describeRO == null) {
            this.describeRO = new KafkaDescribeDataExFW();
        }
        return this.describeRO;
    }

    public KafkaFetchDataExFW fetch() {
        if (this.fetchRO == null) {
            this.fetchRO = new KafkaFetchDataExFW();
        }
        return this.fetchRO;
    }

    public KafkaProduceDataExFW produce() {
        if (this.produceRO == null) {
            this.produceRO = new KafkaProduceDataExFW();
        }
        return this.produceRO;
    }

    @Override
    public KafkaDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 255: {
                if (this.merged().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 3: {
                if (this.meta().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 32: {
                if (this.describe().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 1: {
                if (this.fetch().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 0: {
                if (this.produce().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 255: {
                this.merged().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 3: {
                this.meta().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 32: {
                this.describe().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 1: {
                this.fetch().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 0: {
                this.produce().wrap(buffer, offset + 5, maxLimit);
                break;
            }
        }
        KafkaDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 255: {
                return this.merged().limit();
            }
            case 3: {
                return this.meta().limit();
            }
            case 32: {
                return this.describe().limit();
            }
            case 1: {
                return this.fetch().limit();
            }
            case 0: {
                return this.produce().limit();
            }
        }
        return this.offset() + 0 + 4;
    }

    public String toString() {
        switch (this.kind()) {
            case 255: {
                return String.format("KAFKA_DATA_EX [typeId=%d, merged=%s]", this.typeId(), this.merged());
            }
            case 3: {
                return String.format("KAFKA_DATA_EX [typeId=%d, meta=%s]", this.typeId(), this.meta());
            }
            case 32: {
                return String.format("KAFKA_DATA_EX [typeId=%d, describe=%s]", this.typeId(), this.describe());
            }
            case 1: {
                return String.format("KAFKA_DATA_EX [typeId=%d, fetch=%s]", this.typeId(), this.fetch());
            }
            case 0: {
                return String.format("KAFKA_DATA_EX [typeId=%d, produce=%s]", this.typeId(), this.produce());
            }
        }
        return String.format("KAFKA_DATA_EX [typeId=%d]", this.typeId());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaDataExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private KafkaMergedDataExFW.Builder mergedRW;
        private KafkaMetaDataExFW.Builder metaRW;
        private KafkaDescribeDataExFW.Builder describeRW;
        private KafkaFetchDataExFW.Builder fetchRW;
        private KafkaProduceDataExFW.Builder produceRW;
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaDataExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder kind(int value) {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            this.buffer().putByte(this.offset() + 4, (byte)(value & 0xFF));
            return this;
        }

        private KafkaMergedDataExFW.Builder merged() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            if (this.mergedRW == null) {
                this.mergedRW = new KafkaMergedDataExFW.Builder();
            }
            return this.mergedRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder merged(Consumer<KafkaMergedDataExFW.Builder> mutator) {
            this.kind(255);
            KafkaMergedDataExFW.Builder merged = this.merged();
            mutator.accept(merged);
            this.limit(merged.build().limit());
            return this;
        }

        private KafkaMetaDataExFW.Builder meta() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            if (this.metaRW == null) {
                this.metaRW = new KafkaMetaDataExFW.Builder();
            }
            return this.metaRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder meta(Consumer<KafkaMetaDataExFW.Builder> mutator) {
            this.kind(3);
            KafkaMetaDataExFW.Builder meta = this.meta();
            mutator.accept(meta);
            this.limit(meta.build().limit());
            return this;
        }

        private KafkaDescribeDataExFW.Builder describe() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            if (this.describeRW == null) {
                this.describeRW = new KafkaDescribeDataExFW.Builder();
            }
            return this.describeRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder describe(Consumer<KafkaDescribeDataExFW.Builder> mutator) {
            this.kind(32);
            KafkaDescribeDataExFW.Builder describe = this.describe();
            mutator.accept(describe);
            this.limit(describe.build().limit());
            return this;
        }

        private KafkaFetchDataExFW.Builder fetch() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            if (this.fetchRW == null) {
                this.fetchRW = new KafkaFetchDataExFW.Builder();
            }
            return this.fetchRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder fetch(Consumer<KafkaFetchDataExFW.Builder> mutator) {
            this.kind(1);
            KafkaFetchDataExFW.Builder fetch = this.fetch();
            mutator.accept(fetch);
            this.limit(fetch.build().limit());
            return this;
        }

        private KafkaProduceDataExFW.Builder produce() {
            int newLimit = this.maxLimit();
            KafkaDataExFW.checkLimit(newLimit, this.maxLimit());
            if (this.produceRW == null) {
                this.produceRW = new KafkaProduceDataExFW.Builder();
            }
            return this.produceRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder produce(Consumer<KafkaProduceDataExFW.Builder> mutator) {
            this.kind(0);
            KafkaProduceDataExFW.Builder produce = this.produce();
            mutator.accept(produce);
            this.limit(produce.build().limit());
            return this;
        }

        @Override
        public KafkaDataExFW build() {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            return (KafkaDataExFW)super.build();
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            return this;
        }
    }
}

