/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.String16FW;

public final class KafkaDescribeBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TOPIC = 0;
    public static final int FIELD_OFFSET_CONFIGS = 0;
    private final String16FW topicRO = new String16FW();
    private final Array32FW<String16FW> configsRO = new Array32FW<String16FW>(new String16FW());

    public String16FW topic() {
        return this.topicRO;
    }

    public Array32FW<String16FW> configs() {
        return this.configsRO;
    }

    @Override
    public KafkaDescribeBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.topicRO.wrap(buffer, offset + 0, maxLimit);
        this.configsRO.wrap(buffer, this.topicRO.limit() + 0, maxLimit);
        KafkaDescribeBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaDescribeBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.configsRO.tryWrap(buffer, this.topicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.configsRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_DESCRIBE_BEGIN_EX [topic=%s, configs=%s]", this.topicRO.asString(), this.configs());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaDescribeBeginExFW> {
        private static final int INDEX_TOPIC = 0;
        private static final int INDEX_CONFIGS = 1;
        private static final int FIELD_COUNT = 2;
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final Array32FW.Builder<String16FW.Builder, String16FW> configsRW = new Array32FW.Builder<String16FW.Builder, String16FW>(new String16FW.Builder(), new String16FW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaDescribeBeginExFW());
        }

        private String16FW.Builder topic() {
            assert (this.lastFieldSet == -1);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set((Flyweight)value);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder configs(Consumer<Array32FW.Builder<String16FW.Builder, String16FW>> mutator) {
            assert (this.lastFieldSet == 0);
            Flyweight.Builder configsRW = this.configsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<String16FW.Builder, String16FW>)configsRW);
            this.limit(((Array32FW)((Array32FW.Builder)configsRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder configs(Array32FW<String16FW> field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            KafkaDescribeBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder configsItem(Consumer<String16FW.Builder> mutator) {
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.configsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.configsRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.configsRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaDescribeBeginExFW>, ? extends Flyweight.Builder<KafkaDescribeBeginExFW>, KafkaDescribeBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaDescribeBeginExFW build() {
            if (this.lastFieldSet < 1) {
                this.configs((Array32FW.Builder<String16FW.Builder, String16FW> b) -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (KafkaDescribeBeginExFW)super.build();
        }
    }
}

