/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaType;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaTypeFW;
import org.reaktivity.specification.kafka.internal.types.KafkaFilterFW;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetFW;
import org.reaktivity.specification.kafka.internal.types.String16FW;

public final class KafkaFetchBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TOPIC = 0;
    public static final int FIELD_OFFSET_PARTITION = 0;
    public static final int FIELD_OFFSET_FILTERS = 0;
    public static final int FIELD_OFFSET_DELTA_TYPE = 0;
    private final String16FW topicRO = new String16FW();
    private final KafkaOffsetFW partitionRO = new KafkaOffsetFW();
    private final Array32FW<KafkaFilterFW> filtersRO = new Array32FW<KafkaFilterFW>(new KafkaFilterFW());
    private KafkaDeltaTypeFW deltaTypeRO = new KafkaDeltaTypeFW();

    public String16FW topic() {
        return this.topicRO;
    }

    public KafkaOffsetFW partition() {
        return this.partitionRO;
    }

    public Array32FW<KafkaFilterFW> filters() {
        return this.filtersRO;
    }

    public KafkaDeltaTypeFW deltaType() {
        return this.deltaTypeRO;
    }

    @Override
    public KafkaFetchBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.topicRO.wrap(buffer, offset + 0, maxLimit);
        this.partitionRO.wrap(buffer, this.topicRO.limit() + 0, maxLimit);
        this.filtersRO.wrap(buffer, this.partitionRO.limit() + 0, maxLimit);
        this.deltaTypeRO.wrap(buffer, this.filtersRO.limit() + 0, maxLimit);
        KafkaFetchBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaFetchBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.partitionRO.tryWrap(buffer, this.topicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.filtersRO.tryWrap(buffer, this.partitionRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.deltaTypeRO.tryWrap(buffer, this.filtersRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.deltaTypeRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_FETCH_BEGIN_EX [topic=%s, partition=%s, filters=%s, deltaType=%s]", this.topicRO.asString(), this.partition(), this.filters(), this.deltaType());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaFetchBeginExFW> {
        private static final int INDEX_TOPIC = 0;
        private static final int INDEX_PARTITION = 1;
        private static final int INDEX_FILTERS = 2;
        private static final int INDEX_DELTA_TYPE = 3;
        public static final KafkaDeltaType DEFAULT_DELTA_TYPE = KafkaDeltaType.NONE;
        private static final int FIELD_COUNT = 4;
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final KafkaOffsetFW.Builder partitionRW = new KafkaOffsetFW.Builder();
        private final Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> filtersRW = new Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>(new KafkaFilterFW.Builder(), new KafkaFilterFW());
        private final KafkaDeltaTypeFW.Builder deltaTypeRW = new KafkaDeltaTypeFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaFetchBeginExFW());
        }

        private String16FW.Builder topic() {
            assert (this.lastFieldSet == -1);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set((Flyweight)value);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder partition(Consumer<KafkaOffsetFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            KafkaOffsetFW.Builder partitionRW = this.partitionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(partitionRW);
            this.limit(partitionRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder partition(KafkaOffsetFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder filters(Consumer<Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>> mutator) {
            if (this.lastFieldSet < 1) {
                this.partition((KafkaOffsetFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            Flyweight.Builder filtersRW = this.filtersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>)filtersRW);
            this.limit(((Array32FW)((Array32FW.Builder)filtersRW).build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder filters(Array32FW<KafkaFilterFW> field) {
            if (this.lastFieldSet < 1) {
                this.partition((KafkaOffsetFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder filtersItem(Consumer<KafkaFilterFW.Builder> mutator) {
            if (this.lastFieldSet < 1) {
                this.partition((KafkaOffsetFW.Builder b) -> {});
            }
            assert (this.lastFieldSet >= 1);
            if (this.lastFieldSet < 2) {
                this.filtersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.filtersRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.filtersRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder deltaType(Consumer<KafkaDeltaTypeFW.Builder> mutator) {
            if (this.lastFieldSet < 2) {
                this.filters((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> b) -> {});
            }
            assert (this.lastFieldSet == 2);
            KafkaDeltaTypeFW.Builder deltaTypeRW = this.deltaTypeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(deltaTypeRW);
            this.limit(deltaTypeRW.build().limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder deltaType(KafkaDeltaTypeFW field) {
            if (this.lastFieldSet < 2) {
                this.filters((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> b) -> {});
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaFetchBeginExFW>, ? extends Flyweight.Builder<KafkaFetchBeginExFW>, KafkaFetchBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaFetchBeginExFW build() {
            if (this.lastFieldSet < 3) {
                this.deltaType((KafkaDeltaTypeFW.Builder b) -> b.set(DEFAULT_DELTA_TYPE));
            }
            assert (this.lastFieldSet == 3);
            this.lastFieldSet = -1;
            return (KafkaFetchBeginExFW)super.build();
        }
    }
}

