/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaCapabilities;
import org.reaktivity.specification.kafka.internal.types.KafkaCapabilitiesFW;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaType;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaTypeFW;
import org.reaktivity.specification.kafka.internal.types.KafkaFilterFW;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetFW;
import org.reaktivity.specification.kafka.internal.types.String16FW;

public final class KafkaMergedBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_CAPABILITIES = 0;
    public static final int FIELD_OFFSET_TOPIC = 0;
    public static final int FIELD_OFFSET_PARTITIONS = 0;
    public static final int FIELD_OFFSET_FILTERS = 0;
    public static final int FIELD_OFFSET_DELTA_TYPE = 0;
    private KafkaCapabilitiesFW capabilitiesRO = new KafkaCapabilitiesFW();
    private final String16FW topicRO = new String16FW();
    private final Array32FW<KafkaOffsetFW> partitionsRO = new Array32FW<KafkaOffsetFW>(new KafkaOffsetFW());
    private final Array32FW<KafkaFilterFW> filtersRO = new Array32FW<KafkaFilterFW>(new KafkaFilterFW());
    private KafkaDeltaTypeFW deltaTypeRO = new KafkaDeltaTypeFW();

    public KafkaCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    public String16FW topic() {
        return this.topicRO;
    }

    public Array32FW<KafkaOffsetFW> partitions() {
        return this.partitionsRO;
    }

    public Array32FW<KafkaFilterFW> filters() {
        return this.filtersRO;
    }

    public KafkaDeltaTypeFW deltaType() {
        return this.deltaTypeRO;
    }

    @Override
    public KafkaMergedBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.capabilitiesRO.wrap(buffer, offset + 0, maxLimit);
        this.topicRO.wrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit);
        this.partitionsRO.wrap(buffer, this.topicRO.limit() + 0, maxLimit);
        this.filtersRO.wrap(buffer, this.partitionsRO.limit() + 0, maxLimit);
        this.deltaTypeRO.wrap(buffer, this.filtersRO.limit() + 0, maxLimit);
        KafkaMergedBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaMergedBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, this.capabilitiesRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.partitionsRO.tryWrap(buffer, this.topicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.filtersRO.tryWrap(buffer, this.partitionsRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.deltaTypeRO.tryWrap(buffer, this.filtersRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.deltaTypeRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_MERGED_BEGIN_EX [capabilities=%s, topic=%s, partitions=%s, filters=%s, deltaType=%s]", this.capabilities(), this.topicRO.asString(), this.partitions(), this.filters(), this.deltaType());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaMergedBeginExFW> {
        private static final int INDEX_CAPABILITIES = 0;
        public static final KafkaCapabilities DEFAULT_CAPABILITIES = KafkaCapabilities.PRODUCE_AND_FETCH;
        private static final int INDEX_TOPIC = 1;
        private static final int INDEX_PARTITIONS = 2;
        private static final int INDEX_FILTERS = 3;
        private static final int INDEX_DELTA_TYPE = 4;
        public static final KafkaDeltaType DEFAULT_DELTA_TYPE = KafkaDeltaType.NONE;
        private static final int FIELD_COUNT = 5;
        private final KafkaCapabilitiesFW.Builder capabilitiesRW = new KafkaCapabilitiesFW.Builder();
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> partitionsRW = new Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW>(new KafkaOffsetFW.Builder(), new KafkaOffsetFW());
        private final Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> filtersRW = new Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>(new KafkaFilterFW.Builder(), new KafkaFilterFW());
        private final KafkaDeltaTypeFW.Builder deltaTypeRW = new KafkaDeltaTypeFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaMergedBeginExFW());
        }

        public Builder capabilities(Consumer<KafkaCapabilitiesFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            KafkaCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder capabilities(KafkaCapabilitiesFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            KafkaMergedBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        private String16FW.Builder topic() {
            if (this.lastFieldSet < 0) {
                this.capabilities((KafkaCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 0);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set((Flyweight)value);
            this.lastFieldSet = 1;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder partitions(Consumer<Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW>> mutator) {
            assert (this.lastFieldSet == 1);
            Flyweight.Builder partitionsRW = this.partitionsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW>)partitionsRW);
            this.limit(((Array32FW)((Array32FW.Builder)partitionsRW).build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder partitions(Array32FW<KafkaOffsetFW> field) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            KafkaMergedBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder partitionsItem(Consumer<KafkaOffsetFW.Builder> mutator) {
            assert (this.lastFieldSet >= 1);
            if (this.lastFieldSet < 2) {
                this.partitionsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.partitionsRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.partitionsRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder filters(Consumer<Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>> mutator) {
            if (this.lastFieldSet < 2) {
                this.partitions((Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> b) -> {});
            }
            assert (this.lastFieldSet == 2);
            Flyweight.Builder filtersRW = this.filtersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW>)filtersRW);
            this.limit(((Array32FW)((Array32FW.Builder)filtersRW).build()).limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder filters(Array32FW<KafkaFilterFW> field) {
            if (this.lastFieldSet < 2) {
                this.partitions((Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> b) -> {});
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + field.sizeof();
            KafkaMergedBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder filtersItem(Consumer<KafkaFilterFW.Builder> mutator) {
            if (this.lastFieldSet < 2) {
                this.partitions((Array32FW.Builder<KafkaOffsetFW.Builder, KafkaOffsetFW> b) -> {});
            }
            assert (this.lastFieldSet >= 2);
            if (this.lastFieldSet < 3) {
                this.filtersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.filtersRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.filtersRW.build()).limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder deltaType(Consumer<KafkaDeltaTypeFW.Builder> mutator) {
            if (this.lastFieldSet < 3) {
                this.filters((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> b) -> {});
            }
            assert (this.lastFieldSet == 3);
            KafkaDeltaTypeFW.Builder deltaTypeRW = this.deltaTypeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(deltaTypeRW);
            this.limit(deltaTypeRW.build().limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder deltaType(KafkaDeltaTypeFW field) {
            if (this.lastFieldSet < 3) {
                this.filters((Array32FW.Builder<KafkaFilterFW.Builder, KafkaFilterFW> b) -> {});
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + field.sizeof();
            KafkaMergedBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 4;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<KafkaMergedBeginExFW>, ? extends Flyweight.Builder<KafkaMergedBeginExFW>, KafkaMergedBeginExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaMergedBeginExFW build() {
            if (this.lastFieldSet < 4) {
                this.deltaType((KafkaDeltaTypeFW.Builder b) -> b.set(DEFAULT_DELTA_TYPE));
            }
            assert (this.lastFieldSet == 4);
            this.lastFieldSet = -1;
            return (KafkaMergedBeginExFW)super.build();
        }
    }
}

