/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaCapabilities;

public final class KafkaCapabilitiesFW
extends Flyweight {
    private static final int FIELD_OFFSET_VALUE = 0;
    private static final int FIELD_SIZE_VALUE = 1;

    @Override
    public int limit() {
        return this.offset() + 1;
    }

    public KafkaCapabilities get() {
        return KafkaCapabilities.valueOf(this.buffer().getByte(this.offset() + 0) & 0xFF);
    }

    @Override
    public KafkaCapabilitiesFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaCapabilitiesFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        KafkaCapabilitiesFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : this.get().toString();
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaCapabilitiesFW> {
        private boolean valueSet;

        public Builder() {
            super(new KafkaCapabilitiesFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }

        public Builder set(KafkaCapabilitiesFW value) {
            int newLimit = this.offset() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(KafkaCapabilities value) {
            MutableDirectBuffer buffer = this.buffer();
            int offset = this.offset();
            int newLimit = offset + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            buffer.putByte(offset, (byte)(value.value() & 0xFF));
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public KafkaCapabilitiesFW build() {
            if (!this.valueSet) {
                throw new IllegalStateException("KafkaCapabilities not set");
            }
            return (KafkaCapabilitiesFW)super.build();
        }
    }
}

