/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaHeaderFW;
import org.reaktivity.specification.kafka.internal.types.KafkaHeadersFW;
import org.reaktivity.specification.kafka.internal.types.KafkaKeyFW;
import org.reaktivity.specification.kafka.internal.types.KafkaNotFW;

public final class KafkaConditionFW
extends Flyweight {
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 0;
    public static final int KIND_KEY = 0;
    public static final int FIELD_OFFSET_KEY = 1;
    public static final int KIND_HEADER = 1;
    public static final int FIELD_OFFSET_HEADER = 1;
    public static final int KIND_NOT = 2;
    public static final int FIELD_OFFSET_NOT = 1;
    public static final int KIND_HEADERS = 3;
    public static final int FIELD_OFFSET_HEADERS = 1;
    private KafkaKeyFW keyRO;
    private KafkaHeaderFW headerRO;
    private KafkaNotFW notRO;
    private KafkaHeadersFW headersRO;

    public int kind() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public KafkaKeyFW key() {
        if (this.keyRO == null) {
            this.keyRO = new KafkaKeyFW();
        }
        return this.keyRO;
    }

    public KafkaHeaderFW header() {
        if (this.headerRO == null) {
            this.headerRO = new KafkaHeaderFW();
        }
        return this.headerRO;
    }

    public KafkaNotFW not() {
        if (this.notRO == null) {
            this.notRO = new KafkaNotFW();
        }
        return this.notRO;
    }

    public KafkaHeadersFW headers() {
        if (this.headersRO == null) {
            this.headersRO = new KafkaHeadersFW();
        }
        return this.headersRO;
    }

    @Override
    public KafkaConditionFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 0: {
                if (this.key().tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 1: {
                if (this.header().tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 2: {
                if (this.not().tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 3: {
                if (this.headers().tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaConditionFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 0: {
                this.key().wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 1: {
                this.header().wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 2: {
                this.not().wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 3: {
                this.headers().wrap(buffer, offset + 1, maxLimit);
                break;
            }
        }
        KafkaConditionFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 0: {
                return this.key().limit();
            }
            case 1: {
                return this.header().limit();
            }
            case 2: {
                return this.not().limit();
            }
            case 3: {
                return this.headers().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case 0: {
                return String.format("KAFKA_CONDITION [key=%s]", this.key());
            }
            case 1: {
                return String.format("KAFKA_CONDITION [header=%s]", this.header());
            }
            case 2: {
                return String.format("KAFKA_CONDITION [not=%s]", this.not());
            }
            case 3: {
                return String.format("KAFKA_CONDITION [headers=%s]", this.headers());
            }
        }
        return String.format("KAFKA_CONDITION [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaConditionFW> {
        private KafkaKeyFW.Builder keyRW;
        private KafkaHeaderFW.Builder headerRW;
        private KafkaNotFW.Builder notRW;
        private KafkaHeadersFW.Builder headersRW;

        public Builder() {
            super(new KafkaConditionFW());
        }

        public Builder kind(int value) {
            this.buffer().putByte(this.offset() + 0, (byte)(value & 0xFF));
            return this;
        }

        private KafkaKeyFW.Builder key() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            if (this.keyRW == null) {
                this.keyRW = new KafkaKeyFW.Builder();
            }
            return this.keyRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder key(Consumer<KafkaKeyFW.Builder> mutator) {
            this.kind(0);
            KafkaKeyFW.Builder key = this.key();
            mutator.accept(key);
            this.limit(key.build().limit());
            return this;
        }

        public Builder key(KafkaKeyFW field) {
            this.kind(0);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaHeaderFW.Builder header() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            if (this.headerRW == null) {
                this.headerRW = new KafkaHeaderFW.Builder();
            }
            return this.headerRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder header(Consumer<KafkaHeaderFW.Builder> mutator) {
            this.kind(1);
            KafkaHeaderFW.Builder header = this.header();
            mutator.accept(header);
            this.limit(header.build().limit());
            return this;
        }

        public Builder header(KafkaHeaderFW field) {
            this.kind(1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaNotFW.Builder not() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            if (this.notRW == null) {
                this.notRW = new KafkaNotFW.Builder();
            }
            return this.notRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder not(Consumer<KafkaNotFW.Builder> mutator) {
            this.kind(2);
            KafkaNotFW.Builder not = this.not();
            mutator.accept(not);
            this.limit(not.build().limit());
            return this;
        }

        public Builder not(KafkaNotFW field) {
            this.kind(2);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaHeadersFW.Builder headers() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            if (this.headersRW == null) {
                this.headersRW = new KafkaHeadersFW.Builder();
            }
            return this.headersRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder headers(Consumer<KafkaHeadersFW.Builder> mutator) {
            this.kind(3);
            KafkaHeadersFW.Builder headers = this.headers();
            mutator.accept(headers);
            this.limit(headers.build().limit());
            return this;
        }

        public Builder headers(KafkaHeadersFW field) {
            this.kind(3);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

