/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaType;

public final class KafkaDeltaTypeFW
extends Flyweight {
    private static final int FIELD_OFFSET_VALUE = 0;
    private static final int FIELD_SIZE_VALUE = 1;

    @Override
    public int limit() {
        return this.offset() + 1;
    }

    public KafkaDeltaType get() {
        return KafkaDeltaType.valueOf(this.buffer().getByte(this.offset() + 0));
    }

    @Override
    public KafkaDeltaTypeFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaDeltaTypeFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        KafkaDeltaTypeFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : this.get().toString();
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaDeltaTypeFW> {
        private boolean valueSet;

        public Builder() {
            super(new KafkaDeltaTypeFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }

        public Builder set(KafkaDeltaTypeFW value) {
            int newLimit = this.offset() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(KafkaDeltaType value) {
            MutableDirectBuffer buffer = this.buffer();
            int offset = this.offset();
            int newLimit = offset + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            buffer.putByte(offset, (byte)value.ordinal());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public KafkaDeltaTypeFW build() {
            if (!this.valueSet) {
                throw new IllegalStateException("KafkaDeltaType not set");
            }
            return (KafkaDeltaTypeFW)super.build();
        }
    }
}

