/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaValueMatchFW;
import org.reaktivity.specification.kafka.internal.types.OctetsFW;
import org.reaktivity.specification.kafka.internal.types.Varint32FW;

public final class KafkaHeadersFW
extends Flyweight {
    public static final int FIELD_OFFSET_NAME_LEN = 0;
    public static final int FIELD_OFFSET_NAME = 0;
    public static final int FIELD_OFFSET_VALUES = 0;
    private final Varint32FW nameLenRO = new Varint32FW();
    private final OctetsFW nameRO = new OctetsFW();
    private final Array32FW<KafkaValueMatchFW> valuesRO = new Array32FW<KafkaValueMatchFW>(new KafkaValueMatchFW());

    public int nameLen() {
        return this.nameLenRO.value();
    }

    public OctetsFW name() {
        return this.nameRO;
    }

    public Array32FW<KafkaValueMatchFW> values() {
        return this.valuesRO;
    }

    @Override
    public KafkaHeadersFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nameLenRO.wrap(buffer, offset + 0, maxLimit);
        this.nameRO.wrap(buffer, this.nameLenRO.limit() + 0, this.nameLenRO.limit() + 0 + this.nameLen());
        this.valuesRO.wrap(buffer, this.nameRO.limit() + 0, maxLimit);
        KafkaHeadersFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaHeadersFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.nameLenRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        int limit = this.nameLenRO.limit() + 0 + this.nameLen();
        if (limit > maxLimit || null == this.nameRO.tryWrap(buffer, this.nameLenRO.limit() + 0, limit)) {
            return null;
        }
        if (null == this.valuesRO.tryWrap(buffer, this.nameRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valuesRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_HEADERS [nameLen=%s, name=%s, values=%s]", this.nameLen(), this.name(), this.values());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaHeadersFW> {
        private static final int INDEX_NAME_LEN = 0;
        public static final int DEFAULT_NAME_LEN = 0;
        private static final int INDEX_NAME = 1;
        private static final int INDEX_VALUES = 2;
        private static final int FIELD_COUNT = 3;
        private int dynamicValueNameLen;
        private final Varint32FW.Builder nameLenRW = new Varint32FW.Builder();
        private final OctetsFW.Builder nameRW = new OctetsFW.Builder();
        private final Array32FW.Builder<KafkaValueMatchFW.Builder, KafkaValueMatchFW> valuesRW = new Array32FW.Builder<KafkaValueMatchFW.Builder, KafkaValueMatchFW>(new KafkaValueMatchFW.Builder(), new KafkaValueMatchFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaHeadersFW());
        }

        public Builder nameLen(int value) {
            assert (this.lastFieldSet == -1);
            Varint32FW.Builder nameLenRW = this.nameLenRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            nameLenRW.set(value);
            this.dynamicValueNameLen = value;
            this.limit(nameLenRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder nameLen(Varint32FW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        private OctetsFW.Builder name() {
            if (this.lastFieldSet < 0) {
                this.nameLen(0);
            }
            assert (this.lastFieldSet == 0);
            return this.nameRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder name(OctetsFW value) {
            OctetsFW.Builder nameRW = this.name();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"name\" that does not default to null");
            }
            nameRW.set(value);
            int newLimit = ((OctetsFW)nameRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueNameLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"name\", does not match value %d set in %s", size$, this.dynamicValueNameLen, "nameLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder name(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder nameRW = this.name();
            mutator.accept(nameRW);
            int newLimit = ((OctetsFW)nameRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueNameLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"name\", does not match value %d set in %s", size$, this.dynamicValueNameLen, "nameLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder name(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder nameRW = this.name();
            nameRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)nameRW.build()).limit();
            int size$ = newLimit - this.limit();
            if (size$ != this.dynamicValueNameLen) {
                throw new IllegalStateException(String.format("%d bytes have been set for field \"name\", does not match value %d set in %s", size$, this.dynamicValueNameLen, "nameLen"));
            }
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder values(Consumer<Array32FW.Builder<KafkaValueMatchFW.Builder, KafkaValueMatchFW>> mutator) {
            assert (this.lastFieldSet == 1);
            Flyweight.Builder valuesRW = this.valuesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaValueMatchFW.Builder, KafkaValueMatchFW>)valuesRW);
            this.limit(((Array32FW)((Array32FW.Builder)valuesRW).build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder values(Array32FW<KafkaValueMatchFW> field) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder valuesItem(Consumer<KafkaValueMatchFW.Builder> mutator) {
            assert (this.lastFieldSet >= 1);
            if (this.lastFieldSet < 2) {
                this.valuesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.valuesRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.valuesRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaHeadersFW build() {
            if (this.lastFieldSet < 2) {
                this.values((Array32FW.Builder<KafkaValueMatchFW.Builder, KafkaValueMatchFW> b) -> {});
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (KafkaHeadersFW)super.build();
        }
    }
}

