/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaConditionFW;

public final class KafkaNotFW
extends Flyweight {
    public static final int FIELD_OFFSET_CONDITION = 0;
    private final KafkaConditionFW conditionRO = new KafkaConditionFW();

    public KafkaConditionFW condition() {
        return this.conditionRO;
    }

    @Override
    public KafkaNotFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.conditionRO.wrap(buffer, offset + 0, maxLimit);
        KafkaNotFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaNotFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.conditionRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.conditionRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_NOT [condition=%s]", this.condition());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaNotFW> {
        private static final int INDEX_CONDITION = 0;
        private static final int FIELD_COUNT = 1;
        private final KafkaConditionFW.Builder conditionRW = new KafkaConditionFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaNotFW());
        }

        public Builder condition(Consumer<KafkaConditionFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            KafkaConditionFW.Builder conditionRW = this.conditionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(conditionRW);
            this.limit(((KafkaConditionFW)conditionRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder condition(KafkaConditionFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaNotFW build() {
            if (this.lastFieldSet < 0) {
                this.condition((KafkaConditionFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (KafkaNotFW)super.build();
        }
    }
}

