/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;

public final class KafkaOffsetFW
extends Flyweight {
    public static final int FIELD_OFFSET_PARTITION_ID = 0;
    private static final int FIELD_SIZE_PARTITION_ID = 4;
    public static final int FIELD_OFFSET_PARTITION_OFFSET = 4;
    private static final int FIELD_SIZE_PARTITION_OFFSET = 8;
    public static final int FIELD_OFFSET_LATEST_OFFSET = 12;
    private static final int FIELD_SIZE_LATEST_OFFSET = 8;

    public int partitionId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public long partitionOffset() {
        return this.buffer().getLong(this.offset() + 4);
    }

    public long latestOffset() {
        return this.buffer().getLong(this.offset() + 12);
    }

    @Override
    public KafkaOffsetFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        KafkaOffsetFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaOffsetFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 12 + 8;
    }

    public String toString() {
        return String.format("KAFKA_OFFSET [partitionId=%d, partitionOffset=%d, latestOffset=%d]", this.partitionId(), this.partitionOffset(), this.latestOffset());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaOffsetFW> {
        private static final int INDEX_PARTITION_ID = 0;
        private static final int INDEX_PARTITION_OFFSET = 1;
        private static final int INDEX_LATEST_OFFSET = 2;
        public static final long DEFAULT_LATEST_OFFSET = -1L;
        private static final int FIELD_COUNT = 3;
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaOffsetFW());
        }

        public Builder partitionId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder partitionOffset(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder latestOffset(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaOffsetFW build() {
            if (this.lastFieldSet < 2) {
                this.latestOffset(-1L);
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (KafkaOffsetFW)super.build();
        }
    }
}

