/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaSkip;

public final class KafkaSkipFW
extends Flyweight {
    private static final int FIELD_OFFSET_VALUE = 0;
    private static final int FIELD_SIZE_VALUE = 1;

    @Override
    public int limit() {
        return this.offset() + 1;
    }

    public KafkaSkip get() {
        return KafkaSkip.valueOf(this.buffer().getByte(this.offset() + 0) & 0xFF);
    }

    @Override
    public KafkaSkipFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null || this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaSkipFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        KafkaSkipFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : this.get().toString();
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaSkipFW> {
        private boolean valueSet;

        public Builder() {
            super(new KafkaSkipFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }

        public Builder set(KafkaSkipFW value) {
            int newLimit = this.offset() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(KafkaSkip value) {
            MutableDirectBuffer buffer = this.buffer();
            int offset = this.offset();
            int newLimit = offset + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            buffer.putByte(offset, (byte)(value.value() & 0xFF));
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public KafkaSkipFW build() {
            if (!this.valueSet) {
                throw new IllegalStateException("KafkaSkip not set");
            }
            return (KafkaSkipFW)super.build();
        }
    }
}

