/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaSkipFW;
import org.reaktivity.specification.kafka.internal.types.KafkaValueFW;

public final class KafkaValueMatchFW
extends Flyweight {
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 0;
    public static final int KIND_VALUE = 0;
    public static final int FIELD_OFFSET_VALUE = 1;
    public static final int KIND_SKIP = 1;
    public static final int FIELD_OFFSET_SKIP = 1;
    private KafkaValueFW valueRO;
    private KafkaSkipFW skipRO;

    public int kind() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public KafkaValueFW value() {
        if (this.valueRO == null) {
            this.valueRO = new KafkaValueFW();
        }
        return this.valueRO;
    }

    public KafkaSkipFW skip() {
        if (this.skipRO == null) {
            this.skipRO = new KafkaSkipFW();
        }
        return this.skipRO;
    }

    @Override
    public KafkaValueMatchFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 0: {
                if (this.value().tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 1: {
                if (this.skip().tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaValueMatchFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 0: {
                this.value().wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 1: {
                this.skip().wrap(buffer, offset + 1, maxLimit);
                break;
            }
        }
        KafkaValueMatchFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 0: {
                return this.value().limit();
            }
            case 1: {
                return this.skip().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case 0: {
                return String.format("KAFKA_VALUE_MATCH [value=%s]", this.value());
            }
            case 1: {
                return String.format("KAFKA_VALUE_MATCH [skip=%s]", this.skip());
            }
        }
        return String.format("KAFKA_VALUE_MATCH [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaValueMatchFW> {
        private KafkaValueFW.Builder valueRW;
        private KafkaSkipFW.Builder skipRW;

        public Builder() {
            super(new KafkaValueMatchFW());
        }

        public Builder kind(int value) {
            this.buffer().putByte(this.offset() + 0, (byte)(value & 0xFF));
            return this;
        }

        private KafkaValueFW.Builder value() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            if (this.valueRW == null) {
                this.valueRW = new KafkaValueFW.Builder();
            }
            return this.valueRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder value(Consumer<KafkaValueFW.Builder> mutator) {
            this.kind(0);
            KafkaValueFW.Builder value = this.value();
            mutator.accept(value);
            this.limit(value.build().limit());
            return this;
        }

        public Builder value(KafkaValueFW field) {
            this.kind(0);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaSkipFW.Builder skip() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            if (this.skipRW == null) {
                this.skipRW = new KafkaSkipFW.Builder();
            }
            return this.skipRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder skip(Consumer<KafkaSkipFW.Builder> mutator) {
            this.kind(1);
            KafkaSkipFW.Builder skip = this.skip();
            mutator.accept(skip);
            this.limit(skip.build().limit());
            return this;
        }

        public Builder skip(KafkaSkipFW field) {
            this.kind(1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

