/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaType;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaTypeFW;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetType;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetTypeFW;
import org.reaktivity.specification.kafka.internal.types.String16FW;

public final class KafkaRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TOPIC = 0;
    public static final int FIELD_OFFSET_DELTA_TYPE = 0;
    public static final int FIELD_OFFSET_DEFAULT_OFFSET = 0;
    private final String16FW topicRO = new String16FW();
    private KafkaDeltaTypeFW deltaTypeRO = new KafkaDeltaTypeFW();
    private KafkaOffsetTypeFW defaultOffsetRO = new KafkaOffsetTypeFW();

    public String16FW topic() {
        return this.topicRO;
    }

    public KafkaDeltaTypeFW deltaType() {
        return this.deltaTypeRO;
    }

    public KafkaOffsetTypeFW defaultOffset() {
        return this.defaultOffsetRO;
    }

    @Override
    public KafkaRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.topicRO.wrap(buffer, offset + 0, maxLimit);
        this.deltaTypeRO.wrap(buffer, this.topicRO.limit() + 0, maxLimit);
        this.defaultOffsetRO.wrap(buffer, this.deltaTypeRO.limit() + 0, maxLimit);
        KafkaRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.deltaTypeRO.tryWrap(buffer, this.topicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.defaultOffsetRO.tryWrap(buffer, this.deltaTypeRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.defaultOffsetRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_ROUTE_EX [topic=%s, deltaType=%s, defaultOffset=%s]", this.topicRO.asString(), this.deltaType(), this.defaultOffset());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaRouteExFW> {
        private static final int INDEX_TOPIC = 0;
        private static final int INDEX_DELTA_TYPE = 1;
        public static final KafkaDeltaType DEFAULT_DELTA_TYPE = KafkaDeltaType.NONE;
        private static final int INDEX_DEFAULT_OFFSET = 2;
        public static final KafkaOffsetType DEFAULT_DEFAULT_OFFSET = KafkaOffsetType.HISTORICAL;
        private static final int FIELD_COUNT = 3;
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final KafkaDeltaTypeFW.Builder deltaTypeRW = new KafkaDeltaTypeFW.Builder();
        private final KafkaOffsetTypeFW.Builder defaultOffsetRW = new KafkaOffsetTypeFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaRouteExFW());
        }

        private String16FW.Builder topic() {
            assert (this.lastFieldSet == -1);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set((Flyweight)value);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder deltaType(Consumer<KafkaDeltaTypeFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            KafkaDeltaTypeFW.Builder deltaTypeRW = this.deltaTypeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(deltaTypeRW);
            this.limit(deltaTypeRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder deltaType(KafkaDeltaTypeFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            KafkaRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder defaultOffset(Consumer<KafkaOffsetTypeFW.Builder> mutator) {
            if (this.lastFieldSet < 1) {
                this.deltaType((KafkaDeltaTypeFW.Builder b) -> b.set(DEFAULT_DELTA_TYPE));
            }
            assert (this.lastFieldSet == 1);
            KafkaOffsetTypeFW.Builder defaultOffsetRW = this.defaultOffsetRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(defaultOffsetRW);
            this.limit(defaultOffsetRW.build().limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder defaultOffset(KafkaOffsetTypeFW field) {
            if (this.lastFieldSet < 1) {
                this.deltaType((KafkaDeltaTypeFW.Builder b) -> b.set(DEFAULT_DELTA_TYPE));
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            KafkaRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaRouteExFW build() {
            if (this.lastFieldSet < 2) {
                this.defaultOffset((KafkaOffsetTypeFW.Builder b) -> b.set(DEFAULT_DEFAULT_OFFSET));
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (KafkaRouteExFW)super.build();
        }
    }
}

