/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.control;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;

public final class RoutedFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_ROUTE_ID = 8;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int TYPE_ID = 0x40000001;

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long routeId() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public int typeId() {
        return 0x40000001;
    }

    @Override
    public RoutedFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        RoutedFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public RoutedFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 8 + 8;
    }

    public String toString() {
        return String.format("ROUTED [correlationId=%d, routeId=%d]", this.correlationId(), this.routeId());
    }

    public static final class Builder
    extends Flyweight.Builder<RoutedFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_ROUTE_ID = 1;
        private static final int FIELD_COUNT = 2;
        private int lastFieldSet = -1;

        public Builder() {
            super(new RoutedFW());
        }

        public Builder correlationId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            RoutedFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            RoutedFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public RoutedFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (RoutedFW)super.build();
        }
    }
}

