/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaBootstrapBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaDescribeBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaFetchBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMergedBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaMetaBeginExFW;
import org.reaktivity.specification.kafka.internal.types.stream.KafkaProduceBeginExFW;

public final class KafkaBeginExFW
extends Flyweight {
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 4;
    public static final int KIND_BOOTSTRAP = 254;
    public static final int FIELD_OFFSET_BOOTSTRAP = 5;
    public static final int KIND_MERGED = 255;
    public static final int FIELD_OFFSET_MERGED = 5;
    public static final int KIND_META = 3;
    public static final int FIELD_OFFSET_META = 5;
    public static final int KIND_DESCRIBE = 32;
    public static final int FIELD_OFFSET_DESCRIBE = 5;
    public static final int KIND_FETCH = 1;
    public static final int FIELD_OFFSET_FETCH = 5;
    public static final int KIND_PRODUCE = 0;
    public static final int FIELD_OFFSET_PRODUCE = 5;
    private KafkaBootstrapBeginExFW bootstrapRO;
    private KafkaMergedBeginExFW mergedRO;
    private KafkaMetaBeginExFW metaRO;
    private KafkaDescribeBeginExFW describeRO;
    private KafkaFetchBeginExFW fetchRO;
    private KafkaProduceBeginExFW produceRO;

    public int kind() {
        return this.buffer().getByte(this.offset() + 4) & 0xFF;
    }

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public KafkaBootstrapBeginExFW bootstrap() {
        if (this.bootstrapRO == null) {
            this.bootstrapRO = new KafkaBootstrapBeginExFW();
        }
        return this.bootstrapRO;
    }

    public KafkaMergedBeginExFW merged() {
        if (this.mergedRO == null) {
            this.mergedRO = new KafkaMergedBeginExFW();
        }
        return this.mergedRO;
    }

    public KafkaMetaBeginExFW meta() {
        if (this.metaRO == null) {
            this.metaRO = new KafkaMetaBeginExFW();
        }
        return this.metaRO;
    }

    public KafkaDescribeBeginExFW describe() {
        if (this.describeRO == null) {
            this.describeRO = new KafkaDescribeBeginExFW();
        }
        return this.describeRO;
    }

    public KafkaFetchBeginExFW fetch() {
        if (this.fetchRO == null) {
            this.fetchRO = new KafkaFetchBeginExFW();
        }
        return this.fetchRO;
    }

    public KafkaProduceBeginExFW produce() {
        if (this.produceRO == null) {
            this.produceRO = new KafkaProduceBeginExFW();
        }
        return this.produceRO;
    }

    @Override
    public KafkaBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 254: {
                if (this.bootstrap().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 255: {
                if (this.merged().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 3: {
                if (this.meta().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 32: {
                if (this.describe().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 1: {
                if (this.fetch().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
            case 0: {
                if (this.produce().tryWrap(buffer, offset + 5, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public KafkaBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 254: {
                this.bootstrap().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 255: {
                this.merged().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 3: {
                this.meta().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 32: {
                this.describe().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 1: {
                this.fetch().wrap(buffer, offset + 5, maxLimit);
                break;
            }
            case 0: {
                this.produce().wrap(buffer, offset + 5, maxLimit);
                break;
            }
        }
        KafkaBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 254: {
                return this.bootstrap().limit();
            }
            case 255: {
                return this.merged().limit();
            }
            case 3: {
                return this.meta().limit();
            }
            case 32: {
                return this.describe().limit();
            }
            case 1: {
                return this.fetch().limit();
            }
            case 0: {
                return this.produce().limit();
            }
        }
        return this.offset() + 0 + 4;
    }

    public String toString() {
        switch (this.kind()) {
            case 254: {
                return String.format("KAFKA_BEGIN_EX [typeId=%d, bootstrap=%s]", this.typeId(), this.bootstrap());
            }
            case 255: {
                return String.format("KAFKA_BEGIN_EX [typeId=%d, merged=%s]", this.typeId(), this.merged());
            }
            case 3: {
                return String.format("KAFKA_BEGIN_EX [typeId=%d, meta=%s]", this.typeId(), this.meta());
            }
            case 32: {
                return String.format("KAFKA_BEGIN_EX [typeId=%d, describe=%s]", this.typeId(), this.describe());
            }
            case 1: {
                return String.format("KAFKA_BEGIN_EX [typeId=%d, fetch=%s]", this.typeId(), this.fetch());
            }
            case 0: {
                return String.format("KAFKA_BEGIN_EX [typeId=%d, produce=%s]", this.typeId(), this.produce());
            }
        }
        return String.format("KAFKA_BEGIN_EX [typeId=%d]", this.typeId());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private KafkaBootstrapBeginExFW.Builder bootstrapRW;
        private KafkaMergedBeginExFW.Builder mergedRW;
        private KafkaMetaBeginExFW.Builder metaRW;
        private KafkaDescribeBeginExFW.Builder describeRW;
        private KafkaFetchBeginExFW.Builder fetchRW;
        private KafkaProduceBeginExFW.Builder produceRW;
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder kind(int value) {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            this.buffer().putByte(this.offset() + 4, (byte)(value & 0xFF));
            return this;
        }

        private KafkaBootstrapBeginExFW.Builder bootstrap() {
            int newLimit = this.maxLimit();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            if (this.bootstrapRW == null) {
                this.bootstrapRW = new KafkaBootstrapBeginExFW.Builder();
            }
            return this.bootstrapRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder bootstrap(Consumer<KafkaBootstrapBeginExFW.Builder> mutator) {
            this.kind(254);
            KafkaBootstrapBeginExFW.Builder bootstrap = this.bootstrap();
            mutator.accept(bootstrap);
            this.limit(bootstrap.build().limit());
            return this;
        }

        public Builder bootstrap(KafkaBootstrapBeginExFW field) {
            this.kind(254);
            int newLimit = this.limit() + field.sizeof();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaMergedBeginExFW.Builder merged() {
            int newLimit = this.maxLimit();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            if (this.mergedRW == null) {
                this.mergedRW = new KafkaMergedBeginExFW.Builder();
            }
            return this.mergedRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder merged(Consumer<KafkaMergedBeginExFW.Builder> mutator) {
            this.kind(255);
            KafkaMergedBeginExFW.Builder merged = this.merged();
            mutator.accept(merged);
            this.limit(merged.build().limit());
            return this;
        }

        public Builder merged(KafkaMergedBeginExFW field) {
            this.kind(255);
            int newLimit = this.limit() + field.sizeof();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaMetaBeginExFW.Builder meta() {
            int newLimit = this.maxLimit();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            if (this.metaRW == null) {
                this.metaRW = new KafkaMetaBeginExFW.Builder();
            }
            return this.metaRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder meta(Consumer<KafkaMetaBeginExFW.Builder> mutator) {
            this.kind(3);
            KafkaMetaBeginExFW.Builder meta = this.meta();
            mutator.accept(meta);
            this.limit(meta.build().limit());
            return this;
        }

        public Builder meta(KafkaMetaBeginExFW field) {
            this.kind(3);
            int newLimit = this.limit() + field.sizeof();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaDescribeBeginExFW.Builder describe() {
            int newLimit = this.maxLimit();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            if (this.describeRW == null) {
                this.describeRW = new KafkaDescribeBeginExFW.Builder();
            }
            return this.describeRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder describe(Consumer<KafkaDescribeBeginExFW.Builder> mutator) {
            this.kind(32);
            KafkaDescribeBeginExFW.Builder describe = this.describe();
            mutator.accept(describe);
            this.limit(describe.build().limit());
            return this;
        }

        public Builder describe(KafkaDescribeBeginExFW field) {
            this.kind(32);
            int newLimit = this.limit() + field.sizeof();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaFetchBeginExFW.Builder fetch() {
            int newLimit = this.maxLimit();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            if (this.fetchRW == null) {
                this.fetchRW = new KafkaFetchBeginExFW.Builder();
            }
            return this.fetchRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder fetch(Consumer<KafkaFetchBeginExFW.Builder> mutator) {
            this.kind(1);
            KafkaFetchBeginExFW.Builder fetch = this.fetch();
            mutator.accept(fetch);
            this.limit(fetch.build().limit());
            return this;
        }

        public Builder fetch(KafkaFetchBeginExFW field) {
            this.kind(1);
            int newLimit = this.limit() + field.sizeof();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private KafkaProduceBeginExFW.Builder produce() {
            int newLimit = this.maxLimit();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            if (this.produceRW == null) {
                this.produceRW = new KafkaProduceBeginExFW.Builder();
            }
            return this.produceRW.wrap(this.buffer(), this.offset() + 5, newLimit);
        }

        public Builder produce(Consumer<KafkaProduceBeginExFW.Builder> mutator) {
            this.kind(0);
            KafkaProduceBeginExFW.Builder produce = this.produce();
            mutator.accept(produce);
            this.limit(produce.build().limit());
            return this;
        }

        public Builder produce(KafkaProduceBeginExFW field) {
            this.kind(0);
            int newLimit = this.limit() + field.sizeof();
            KafkaBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        @Override
        public KafkaBeginExFW build() {
            assert (this.lastFieldSet == 0) : "Field \"typeId\" is not set";
            return (KafkaBeginExFW)super.build();
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            return this;
        }
    }
}

