/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaDeltaFW;
import org.reaktivity.specification.kafka.internal.types.KafkaHeaderFW;
import org.reaktivity.specification.kafka.internal.types.KafkaKeyFW;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetFW;

public final class KafkaFetchDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_DEFERRED = 0;
    private static final int FIELD_SIZE_DEFERRED = 4;
    public static final int FIELD_OFFSET_TIMESTAMP = 4;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_HEADERS_SIZE_MAX = 12;
    private static final int FIELD_SIZE_HEADERS_SIZE_MAX = 4;
    public static final int FIELD_OFFSET_PARTITION = 16;
    public static final int FIELD_OFFSET_KEY = 0;
    public static final int FIELD_OFFSET_DELTA = 0;
    public static final int FIELD_OFFSET_HEADERS = 0;
    private final KafkaOffsetFW partitionRO = new KafkaOffsetFW();
    private final KafkaKeyFW keyRO = new KafkaKeyFW();
    private final KafkaDeltaFW deltaRO = new KafkaDeltaFW();
    private final Array32FW<KafkaHeaderFW> headersRO = new Array32FW<KafkaHeaderFW>(new KafkaHeaderFW());

    public int deferred() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 4);
    }

    public int headersSizeMax() {
        return this.buffer().getInt(this.offset() + 12);
    }

    public KafkaOffsetFW partition() {
        return this.partitionRO;
    }

    public KafkaKeyFW key() {
        return this.keyRO;
    }

    public KafkaDeltaFW delta() {
        return this.deltaRO;
    }

    public Array32FW<KafkaHeaderFW> headers() {
        return this.headersRO;
    }

    @Override
    public KafkaFetchDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.partitionRO.wrap(buffer, offset + 16, maxLimit);
        this.keyRO.wrap(buffer, this.partitionRO.limit() + 0, maxLimit);
        this.deltaRO.wrap(buffer, this.keyRO.limit() + 0, maxLimit);
        this.headersRO.wrap(buffer, this.deltaRO.limit() + 0, maxLimit);
        KafkaFetchDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaFetchDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.partitionRO.tryWrap(buffer, offset + 16, maxLimit)) {
            return null;
        }
        if (null == this.keyRO.tryWrap(buffer, this.partitionRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.deltaRO.tryWrap(buffer, this.keyRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.headersRO.tryWrap(buffer, this.deltaRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.headersRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_FETCH_DATA_EX [deferred=%d, timestamp=%d, headersSizeMax=%d, partition=%s, key=%s, delta=%s, headers=%s]", this.deferred(), this.timestamp(), this.headersSizeMax(), this.partition(), this.key(), this.delta(), this.headers());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaFetchDataExFW> {
        private static final int INDEX_DEFERRED = 0;
        public static final int DEFAULT_DEFERRED = 0;
        private static final int INDEX_TIMESTAMP = 1;
        public static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_HEADERS_SIZE_MAX = 2;
        public static final int DEFAULT_HEADERS_SIZE_MAX = 4;
        private static final int INDEX_PARTITION = 3;
        private static final int INDEX_KEY = 4;
        private static final int INDEX_DELTA = 5;
        private static final int INDEX_HEADERS = 6;
        private static final int FIELD_COUNT = 7;
        private final KafkaOffsetFW.Builder partitionRW = new KafkaOffsetFW.Builder();
        private final KafkaKeyFW.Builder keyRW = new KafkaKeyFW.Builder();
        private final KafkaDeltaFW.Builder deltaRW = new KafkaDeltaFW.Builder();
        private final Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW> headersRW = new Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>(new KafkaHeaderFW.Builder(), new KafkaHeaderFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaFetchDataExFW());
        }

        public Builder deferred(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            KafkaFetchDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            if (this.lastFieldSet < 0) {
                this.deferred(0);
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            KafkaFetchDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder headersSizeMax(int value) {
            if (this.lastFieldSet < 1) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 4;
            KafkaFetchDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder partition(Consumer<KafkaOffsetFW.Builder> mutator) {
            if (this.lastFieldSet < 2) {
                this.headersSizeMax(4);
            }
            assert (this.lastFieldSet == 2);
            KafkaOffsetFW.Builder partitionRW = this.partitionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(partitionRW);
            this.limit(partitionRW.build().limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder partition(KafkaOffsetFW field) {
            if (this.lastFieldSet < 2) {
                this.headersSizeMax(4);
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder key(Consumer<KafkaKeyFW.Builder> mutator) {
            if (this.lastFieldSet < 3) {
                this.partition((KafkaOffsetFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 3);
            KafkaKeyFW.Builder keyRW = this.keyRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(keyRW);
            this.limit(keyRW.build().limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder key(KafkaKeyFW field) {
            if (this.lastFieldSet < 3) {
                this.partition((KafkaOffsetFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 4;
            return this;
        }

        public Builder delta(Consumer<KafkaDeltaFW.Builder> mutator) {
            if (this.lastFieldSet < 4) {
                this.key((KafkaKeyFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 4);
            KafkaDeltaFW.Builder deltaRW = this.deltaRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(deltaRW);
            this.limit(deltaRW.build().limit());
            this.lastFieldSet = 5;
            return this;
        }

        public Builder delta(KafkaDeltaFW field) {
            if (this.lastFieldSet < 4) {
                this.key((KafkaKeyFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 5;
            return this;
        }

        public Builder headers(Consumer<Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>> mutator) {
            if (this.lastFieldSet < 5) {
                this.delta((KafkaDeltaFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 5);
            Flyweight.Builder headersRW = this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>)headersRW);
            this.limit(((Array32FW)((Array32FW.Builder)headersRW).build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder headers(Array32FW<KafkaHeaderFW> field) {
            if (this.lastFieldSet < 5) {
                this.delta((KafkaDeltaFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + field.sizeof();
            KafkaFetchDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 6;
            return this;
        }

        public Builder headersItem(Consumer<KafkaHeaderFW.Builder> mutator) {
            if (this.lastFieldSet < 5) {
                this.delta((KafkaDeltaFW.Builder b) -> {});
            }
            assert (this.lastFieldSet >= 5);
            if (this.lastFieldSet < 6) {
                this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.headersRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.headersRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaFetchDataExFW build() {
            if (this.lastFieldSet < 6) {
                this.headers((Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet == 6);
            this.lastFieldSet = -1;
            return (KafkaFetchDataExFW)super.build();
        }
    }
}

