/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaPartitionFW;

public final class KafkaMetaDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_PARTITIONS = 0;
    private final Array32FW<KafkaPartitionFW> partitionsRO = new Array32FW<KafkaPartitionFW>(new KafkaPartitionFW());

    public Array32FW<KafkaPartitionFW> partitions() {
        return this.partitionsRO;
    }

    @Override
    public KafkaMetaDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.partitionsRO.wrap(buffer, offset + 0, maxLimit);
        KafkaMetaDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaMetaDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.partitionsRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.partitionsRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_META_DATA_EX [partitions=%s]", this.partitions());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaMetaDataExFW> {
        private static final int INDEX_PARTITIONS = 0;
        private static final int FIELD_COUNT = 1;
        private final Array32FW.Builder<KafkaPartitionFW.Builder, KafkaPartitionFW> partitionsRW = new Array32FW.Builder<KafkaPartitionFW.Builder, KafkaPartitionFW>(new KafkaPartitionFW.Builder(), new KafkaPartitionFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaMetaDataExFW());
        }

        public Builder partitions(Consumer<Array32FW.Builder<KafkaPartitionFW.Builder, KafkaPartitionFW>> mutator) {
            assert (this.lastFieldSet == -1);
            Flyweight.Builder partitionsRW = this.partitionsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaPartitionFW.Builder, KafkaPartitionFW>)partitionsRW);
            this.limit(((Array32FW)((Array32FW.Builder)partitionsRW).build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder partitions(Array32FW<KafkaPartitionFW> field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            KafkaMetaDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder partitionsItem(Consumer<KafkaPartitionFW.Builder> mutator) {
            assert (this.lastFieldSet >= -1);
            if (this.lastFieldSet < 0) {
                this.partitionsRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.partitionsRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.partitionsRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaMetaDataExFW build() {
            if (this.lastFieldSet < 0) {
                this.partitions((Array32FW.Builder<KafkaPartitionFW.Builder, KafkaPartitionFW> b) -> {});
            }
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (KafkaMetaDataExFW)super.build();
        }
    }
}

