/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaOffsetFW;
import org.reaktivity.specification.kafka.internal.types.String16FW;
import org.reaktivity.specification.kafka.internal.types.String8FW;

public final class KafkaProduceBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TRANSACTION = 0;
    public static final int FIELD_OFFSET_PRODUCER_ID = 0;
    private static final int FIELD_SIZE_PRODUCER_ID = 8;
    public static final int FIELD_OFFSET_TOPIC = 8;
    public static final int FIELD_OFFSET_PARTITION = 0;
    private final String8FW transactionRO = new String8FW();
    private final String16FW topicRO = new String16FW();
    private final KafkaOffsetFW partitionRO = new KafkaOffsetFW();

    public String8FW transaction() {
        return this.transactionRO;
    }

    public long producerId() {
        return this.buffer().getLong(this.transactionRO.limit() + 0);
    }

    public String16FW topic() {
        return this.topicRO;
    }

    public KafkaOffsetFW partition() {
        return this.partitionRO;
    }

    @Override
    public KafkaProduceBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.transactionRO.wrap(buffer, offset + 0, maxLimit);
        this.topicRO.wrap(buffer, this.transactionRO.limit() + 8, maxLimit);
        this.partitionRO.wrap(buffer, this.topicRO.limit() + 0, maxLimit);
        KafkaProduceBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaProduceBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.transactionRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.topicRO.tryWrap(buffer, this.transactionRO.limit() + 8, maxLimit)) {
            return null;
        }
        if (null == this.partitionRO.tryWrap(buffer, this.topicRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.partitionRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_PRODUCE_BEGIN_EX [transaction=%s, producerId=%d, topic=%s, partition=%s]", this.transactionRO.asString(), this.producerId(), this.topicRO.asString(), this.partition());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaProduceBeginExFW> {
        private static final int INDEX_TRANSACTION = 0;
        private static final int INDEX_PRODUCER_ID = 1;
        public static final long DEFAULT_PRODUCER_ID = 0L;
        private static final int INDEX_TOPIC = 2;
        private static final int INDEX_PARTITION = 3;
        private static final int FIELD_COUNT = 4;
        private final String8FW.Builder transactionRW = new String8FW.Builder();
        private final String16FW.Builder topicRW = new String16FW.Builder();
        private final KafkaOffsetFW.Builder partitionRW = new KafkaOffsetFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaProduceBeginExFW());
        }

        private String8FW.Builder transaction() {
            assert (this.lastFieldSet == -1);
            return this.transactionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder transaction(String value) {
            String8FW.Builder transactionRW = this.transaction();
            transactionRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(transactionRW.build().limit());
            return this;
        }

        public Builder transaction(String8FW value) {
            String8FW.Builder transactionRW = this.transaction();
            transactionRW.set((Flyweight)value);
            this.lastFieldSet = 0;
            this.limit(transactionRW.build().limit());
            return this;
        }

        public Builder transaction(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder transactionRW = this.transaction();
            transactionRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(transactionRW.build().limit());
            return this;
        }

        public Builder producerId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            KafkaProduceBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        private String16FW.Builder topic() {
            if (this.lastFieldSet < 1) {
                this.producerId(0L);
            }
            assert (this.lastFieldSet == 1);
            return this.topicRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder topic(String value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(String16FW value) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set((Flyweight)value);
            this.lastFieldSet = 2;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder topic(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder topicRW = this.topic();
            topicRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(topicRW.build().limit());
            return this;
        }

        public Builder partition(Consumer<KafkaOffsetFW.Builder> mutator) {
            assert (this.lastFieldSet == 2);
            KafkaOffsetFW.Builder partitionRW = this.partitionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(partitionRW);
            this.limit(partitionRW.build().limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder partition(KafkaOffsetFW field) {
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + field.sizeof();
            KafkaProduceBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaProduceBeginExFW build() {
            if (this.lastFieldSet < 3) {
                this.partition((KafkaOffsetFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 3);
            this.lastFieldSet = -1;
            return (KafkaProduceBeginExFW)super.build();
        }
    }
}

