/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.Array32FW;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;
import org.reaktivity.specification.kafka.internal.types.KafkaHeaderFW;
import org.reaktivity.specification.kafka.internal.types.KafkaKeyFW;

public final class KafkaProduceDataExFW
extends Flyweight {
    public static final int FIELD_OFFSET_DEFERRED = 0;
    private static final int FIELD_SIZE_DEFERRED = 4;
    public static final int FIELD_OFFSET_TIMESTAMP = 4;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_SEQUENCE = 12;
    private static final int FIELD_SIZE_SEQUENCE = 4;
    public static final int FIELD_OFFSET_CRC32C = 16;
    private static final int FIELD_SIZE_CRC32C = 4;
    public static final int FIELD_OFFSET_KEY = 20;
    public static final int FIELD_OFFSET_HEADERS = 0;
    private final KafkaKeyFW keyRO = new KafkaKeyFW();
    private final Array32FW<KafkaHeaderFW> headersRO = new Array32FW<KafkaHeaderFW>(new KafkaHeaderFW());

    public int deferred() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 4);
    }

    public int sequence() {
        return this.buffer().getInt(this.offset() + 12);
    }

    public long crc32c() {
        return (long)this.buffer().getInt(this.offset() + 16) & 0xFFFFFFFFL;
    }

    public KafkaKeyFW key() {
        return this.keyRO;
    }

    public Array32FW<KafkaHeaderFW> headers() {
        return this.headersRO;
    }

    @Override
    public KafkaProduceDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.keyRO.wrap(buffer, offset + 20, maxLimit);
        this.headersRO.wrap(buffer, this.keyRO.limit() + 0, maxLimit);
        KafkaProduceDataExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaProduceDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.keyRO.tryWrap(buffer, offset + 20, maxLimit)) {
            return null;
        }
        if (null == this.headersRO.tryWrap(buffer, this.keyRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.headersRO.limit();
    }

    public String toString() {
        return String.format("KAFKA_PRODUCE_DATA_EX [deferred=%d, timestamp=%d, sequence=%d, crc32c=%d, key=%s, headers=%s]", this.deferred(), this.timestamp(), this.sequence(), this.crc32c(), this.key(), this.headers());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaProduceDataExFW> {
        private static final int INDEX_DEFERRED = 0;
        public static final int DEFAULT_DEFERRED = 0;
        private static final int INDEX_TIMESTAMP = 1;
        public static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_SEQUENCE = 2;
        public static final int DEFAULT_SEQUENCE = -1;
        private static final int INDEX_CRC32C = 3;
        public static final long DEFAULT_CRC32C = 0L;
        private static final int INDEX_KEY = 4;
        private static final int INDEX_HEADERS = 5;
        private static final int FIELD_COUNT = 6;
        private final KafkaKeyFW.Builder keyRW = new KafkaKeyFW.Builder();
        private final Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW> headersRW = new Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>(new KafkaHeaderFW.Builder(), new KafkaHeaderFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaProduceDataExFW());
        }

        public Builder deferred(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            KafkaProduceDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            if (this.lastFieldSet < 0) {
                this.deferred(0);
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            KafkaProduceDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder sequence(int value) {
            if (this.lastFieldSet < 1) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 4;
            KafkaProduceDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder crc32c(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"crc32c\"", value));
            }
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"crc32c\"", value));
            }
            if (this.lastFieldSet < 2) {
                this.sequence(-1);
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 4;
            KafkaProduceDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), (int)(value & 0xFFFFFFFFL));
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder key(Consumer<KafkaKeyFW.Builder> mutator) {
            if (this.lastFieldSet < 3) {
                this.crc32c(0L);
            }
            assert (this.lastFieldSet == 3);
            KafkaKeyFW.Builder keyRW = this.keyRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(keyRW);
            this.limit(keyRW.build().limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder key(KafkaKeyFW field) {
            if (this.lastFieldSet < 3) {
                this.crc32c(0L);
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + field.sizeof();
            KafkaProduceDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 4;
            return this;
        }

        public Builder headers(Consumer<Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>> mutator) {
            if (this.lastFieldSet < 4) {
                this.key((KafkaKeyFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 4);
            Flyweight.Builder headersRW = this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW>)headersRW);
            this.limit(((Array32FW)((Array32FW.Builder)headersRW).build()).limit());
            this.lastFieldSet = 5;
            return this;
        }

        public Builder headers(Array32FW<KafkaHeaderFW> field) {
            if (this.lastFieldSet < 4) {
                this.key((KafkaKeyFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + field.sizeof();
            KafkaProduceDataExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 5;
            return this;
        }

        public Builder headersItem(Consumer<KafkaHeaderFW.Builder> mutator) {
            if (this.lastFieldSet < 4) {
                this.key((KafkaKeyFW.Builder b) -> {});
            }
            assert (this.lastFieldSet >= 4);
            if (this.lastFieldSet < 5) {
                this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.headersRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.headersRW.build()).limit());
            this.lastFieldSet = 5;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaProduceDataExFW build() {
            if (this.lastFieldSet < 5) {
                this.headers((Array32FW.Builder<KafkaHeaderFW.Builder, KafkaHeaderFW> b) -> {});
            }
            assert (this.lastFieldSet == 5);
            this.lastFieldSet = -1;
            return (KafkaProduceDataExFW)super.build();
        }
    }
}

