/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.kafka.internal.types.stream;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.kafka.internal.types.ArrayFW;
import org.reaktivity.specification.kafka.internal.types.Flyweight;

public final class KafkaResetExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_ERROR = 4;
    private static final int FIELD_SIZE_ERROR = 4;

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public int error() {
        return this.buffer().getInt(this.offset() + 4);
    }

    @Override
    public KafkaResetExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        KafkaResetExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public KafkaResetExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + 4;
    }

    public String toString() {
        return String.format("KAFKA_RESET_EX [typeId=%d, error=%d]", this.typeId(), this.error());
    }

    public static final class Builder
    extends Flyweight.Builder<KafkaResetExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_ERROR = 1;
        public static final int DEFAULT_ERROR = 0;
        private static final int FIELD_COUNT = 2;
        private int lastFieldSet = -1;

        public Builder() {
            super(new KafkaResetExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            KafkaResetExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder error(int value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 4;
            KafkaResetExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public KafkaResetExFW build() {
            if (this.lastFieldSet < 1) {
                this.error(0);
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (KafkaResetExFW)super.build();
        }
    }
}

