/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast.visit;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstAbstractMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstListMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstListNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstMapNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstStructNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ListFlyweightGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeSpecGenerator;

public final class ListVisitor
extends AstNode.Visitor<Collection<TypeSpecGenerator<?>>> {
    private final ListFlyweightGenerator generator;
    private final TypeResolver resolver;
    private final Set<TypeSpecGenerator<?>> defaultResult;

    public ListVisitor(ListFlyweightGenerator generator, TypeResolver resolver) {
        this.generator = generator;
        this.resolver = resolver;
        this.defaultResult = Collections.singleton(generator);
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitList(AstListNode listNode) {
        super.visitList(listNode);
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitStruct(AstStructNode structNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitMember(AstAbstractMemberNode memberNode) {
        AstListMemberNode listMemberNode = (AstListMemberNode)memberNode;
        String memberName = listMemberNode.name();
        AstType memberType = listMemberNode.type();
        AstType arrayItemTypeName = null;
        AstType mapKeyType = null;
        AstType mapValueType = null;
        ClassName mapParamName = null;
        ClassName originalMapKeyName = null;
        ClassName originalMapValueName = null;
        AstNamedNode memberTypeNode = this.resolver.resolve(memberType.name());
        if (memberTypeNode != null) {
            if (memberTypeNode.getKind() == AstNamedNode.Kind.VARIANT) {
                AstVariantNode varNode = (AstVariantNode)memberTypeNode;
                AstType ofType = varNode.of();
                if (AstType.ARRAY.equals(ofType)) {
                    AstType arrayType;
                    arrayItemTypeName = arrayType = listMemberNode.typeParams().get(0);
                } else if (AstType.MAP.equals(ofType)) {
                    mapKeyType = listMemberNode.typeParams().get(0);
                    mapValueType = listMemberNode.typeParams().get(1);
                }
            } else if (memberTypeNode.getKind() == AstNamedNode.Kind.MAP) {
                AstMapNode mapNode = (AstMapNode)memberTypeNode;
                AstType keyType = mapNode.keyType();
                AstType valueType = mapNode.valueType();
                AstType mapParam = listMemberNode.typeParams().get(0);
                mapParamName = this.resolver.resolveClass(mapParam);
                originalMapKeyName = Objects.requireNonNullElse(this.resolver.resolveClass(keyType), mapParamName);
                originalMapValueName = Objects.requireNonNullElse(this.resolver.resolveClass(valueType), mapParamName);
            }
        }
        int size = listMemberNode.size();
        TypeName sizeTypeName = listMemberNode.sizeType() == null ? null : (listMemberNode.sizeType().isUnsignedInt() ? this.resolver.resolveUnsignedType(listMemberNode.sizeType()) : this.resolver.resolveType(listMemberNode.sizeType()));
        boolean usedAsSize = listMemberNode.usedAsSize();
        Object defaultValue = listMemberNode.defaultValue();
        AstByteOrder byteOrder = listMemberNode.byteOrder();
        TypeName memberTypeName = this.resolver.resolveType(memberType);
        if (memberTypeName == null) {
            throw new IllegalArgumentException(String.format(" Unable to resolve type %s for field %s", memberType, memberName));
        }
        TypeName memberUnsignedTypeName = memberType.isUnsignedInt() ? this.resolver.resolveUnsignedType(memberType) : null;
        this.generator.addMember(memberName, memberType, memberTypeName, memberUnsignedTypeName, usedAsSize, defaultValue, byteOrder, listMemberNode.isRequired(), arrayItemTypeName, mapKeyType, mapValueType, mapParamName, originalMapKeyName, originalMapValueName);
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitEnum(AstEnumNode enumNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitUnion(AstUnionNode unionNode) {
        return this.defaultResult();
    }

    @Override
    public Collection<TypeSpecGenerator<?>> visitVariant(AstVariantNode variantNode) {
        return this.defaultResult();
    }

    @Override
    protected Collection<TypeSpecGenerator<?>> defaultResult() {
        return this.defaultResult;
    }
}

